/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.config;

import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.wsspi.wssecurity.config.KeyLocatorException;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class KeyStoreKeyLocator
implements KeyLocator {
    private static final int STATUS_OK = 0;
    private static final int STATUS_CERT_ERROR = 1;
    private static final int STATUS_KEYID_ERROR = 2;
    private static final int STATUS_KEY_ERROR = 4;
    private static final TraceComponent tc = Tr.register(KeyStoreKeyLocator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = KeyStoreKeyLocator.class.getName();
    private static final long DAYS_IN_MS = 86400000L;
    private static final long DEFAULT_DAYS_IN_MS_BEFORE_EXPIRE_WARNING = 5184000000L;
    private static final String DAYS_BEFORE_EXPIRE_WARNING_KEYS = "com.ibm.ws.wssecurity.daysBeforeExpireWarning";
    private Map fInitMap = null;
    private Map fName2Container = new HashMap();
    private Map fName2PrivContainer = new HashMap();
    private Map fKey2Container = new HashMap();
    private String fDefaultName;
    private long daysInMSBeforeExpireWarning = 5184000000L;
    private volatile boolean fInitialized = false;

    protected String getDefaultBasePath() {
        return null;
    }

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(map)");
        }
        this.fInitMap = map;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init()");
        }
    }

    protected synchronized void doInit() throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doInit(map)");
        }
        if (this.fInitialized) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"doInit()");
            }
            return;
        }
        String type = null;
        String path = null;
        String ksRef = null;
        char[] storepass = null;
        HashMap<String, String> id2Alias = new HashMap<String, String>();
        HashMap<String, char[]> id2Keypass = new HashMap<String, char[]>();
        HashMap<String, String> id2Name = new HashMap<String, String>();
        String defaultName = null;
        String base = this.getDefaultBasePath();
        for (String name : this.fInitMap.keySet()) {
            String value = (String)this.fInitMap.get(name);
            if (name.equals("type")) {
                type = value;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("doInit() - keystore type: " + value));
                continue;
            }
            if (name.equals("path")) {
                path = value;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("doInit() - keystore path: " + value));
                continue;
            }
            if (name.equals("base")) {
                base = value;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("doInit() - keystore base: " + value));
                continue;
            }
            if (name.equals("storepass")) {
                storepass = value.toCharArray();
                continue;
            }
            if (name.equals("keyStoreRef")) {
                ksRef = value;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("doInit() - keystore reference: " + value));
                continue;
            }
            if (name.startsWith("alias_")) {
                id2Alias.put(name.substring("alias_".length()), value);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("doInit() - keystore " + name + ": " + value));
                continue;
            }
            if (name.startsWith("keypass_")) {
                id2Keypass.put(name.substring("keypass_".length()), value.toCharArray());
                continue;
            }
            if (name.startsWith("name_")) {
                id2Name.put(name.substring("name_".length()), value);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("doInit() - keystore " + name + ": " + value));
                continue;
            }
            if (name.equals("default")) {
                defaultName = value;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("doInit() - keystore default: " + value));
                continue;
            }
            if (!name.equals(DAYS_BEFORE_EXPIRE_WARNING_KEYS)) continue;
            if (value != null && value.length() != 0) {
                if ((value = value.trim()).length() != 0) {
                    long tmpval = 0L;
                    try {
                        tmpval = Long.parseLong(value);
                        this.daysInMSBeforeExpireWarning = tmpval * 86400000L;
                    }
                    catch (NumberFormatException e) {
                        Tr.processException((Throwable)e, (String)(clsName + ".doInit"), (String)"182", (Object)this);
                        Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5190W", (Object)new Object[]{DAYS_BEFORE_EXPIRE_WARNING_KEYS, value, new Long(60L)});
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"doInit() - no value define for: com.ibm.ws.wssecurity.daysBeforeExpireWarning");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"doInit() - no value define for: com.ibm.ws.wssecurity.daysBeforeExpireWarning");
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("doInit() - days before expire warning: " + this.daysInMSBeforeExpireWarning / 86400000L));
        }
        if (type == null) {
            type = KeyStore.getDefaultType();
        }
        if (path == null) {
            throw new NullPointerException("Keystore path not specified");
        }
        String file = path;
        if (base != null) {
            file = ConfigUtil.fixKeystorePath(path, (String)base);
        }
        KeyStore store = null;
        try {
            store = ksRef != null ? ConfigUtil.getKeyStore(ksRef) : ConfigUtil.getKeyStore((String)type, (String)file, storepass);
        }
        catch (SoapSecurityException e) {
            throw new KeyLocatorException(e.toString());
        }
        try {
            Enumeration<String> e = store.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Certificate cert = store.getCertificate(alias);
                X509Certificate x509 = null;
                PublicKey key = null;
                String name = null;
                int status = 0;
                long expiration = -1L;
                String errorMes = null;
                if (cert != null && cert instanceof X509Certificate) {
                    x509 = (X509Certificate)cert;
                    key = x509.getPublicKey();
                    name = x509.getSubjectDN().getName();
                    expiration = x509.getNotAfter().getTime();
                    if (expiration - System.currentTimeMillis() < this.daysInMSBeforeExpireWarning) {
                        long millisBeforeExpiration = expiration - System.currentTimeMillis();
                        long daysLeft = millisBeforeExpiration / 86400000L;
                        Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5189W", (Object)new Object[]{name, alias, path, new Long(daysLeft)});
                    }
                    try {
                        x509.checkValidity();
                    }
                    catch (CertificateExpiredException cee) {
                        ++status;
                        Tr.processException((Throwable)cee, (String)(clsName + ".doInit"), (String)"261", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5181E", (Object)new Object[]{name, alias, path, cee});
                        errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5181E", (String[])new String[]{name, alias, path, cee.getMessage()});
                    }
                    catch (CertificateException ce) {
                        ++status;
                        Tr.processException((Throwable)ce, (String)(clsName + ".doInit"), (String)"268", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5182E", (Object)new Object[]{name, alias, path, ce});
                        errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5182E", (String[])new String[]{name, alias, path, ce.getMessage()});
                    }
                }
                if (x509 == null) continue;
                KeyContainer container = new KeyContainer(path, alias, name, key, x509, status, expiration, this.daysInMSBeforeExpireWarning, errorMes);
                this.fName2Container.put(container.getName(), container);
                this.fKey2Container.put(key, container);
            }
            for (String id : id2Name.keySet()) {
                char[] keypass;
                KeyContainer container;
                long expiration;
                String alias = (String)id2Alias.get(id);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("doInit() - id=" + id + " alias=" + alias));
                }
                if (alias == null) continue;
                Certificate cert = store.getCertificate(alias);
                if (cert != null) {
                    String dnName;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"doInit() - private key found");
                    }
                    String name = (String)id2Name.get(id);
                    X509Certificate x509 = null;
                    Key key = null;
                    int status = 0;
                    expiration = -1L;
                    String errorMes = null;
                    if (cert instanceof X509Certificate) {
                        x509 = (X509Certificate)cert;
                        key = x509.getPublicKey();
                        expiration = x509.getNotAfter().getTime();
                        if (expiration - System.currentTimeMillis() < this.daysInMSBeforeExpireWarning) {
                            long millisBeforeExpiration = expiration - System.currentTimeMillis();
                            long daysLeft = millisBeforeExpiration / 86400000L;
                            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5189W", (Object)new Object[]{name, alias, path, new Long(daysLeft)});
                        }
                        try {
                            x509.checkValidity();
                        }
                        catch (CertificateExpiredException cee) {
                            ++status;
                            Tr.processException((Throwable)cee, (String)(clsName + ".doInit"), (String)"318", (Object)this);
                            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5181E", (Object)new Object[]{name, alias, path, cee});
                            errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5181E", (String[])new String[]{name, alias, path, cee.getMessage()});
                        }
                        catch (CertificateException ce) {
                            ++status;
                            Tr.processException((Throwable)ce, (String)(clsName + ".doInit"), (String)"325", (Object)this);
                            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5182E", (Object)new Object[]{name, alias, path, ce});
                            errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5182E", (String[])new String[]{name, alias, path, ce.getMessage()});
                        }
                        container = new KeyContainer(path, alias, name, key, x509, status, expiration, this.daysInMSBeforeExpireWarning, errorMes);
                        this.fName2Container.put(container.getName(), container);
                        this.fKey2Container.put(key, container);
                    }
                    char[] keypass2 = (char[])id2Keypass.get(id);
                    if (tc.isDebugEnabled()) {
                        if (keypass2 != null) {
                            Tr.debug((TraceComponent)tc, (String)"doInit() - keypass is not null");
                        } else {
                            Tr.debug((TraceComponent)tc, (String)"doInit() - keypass is null");
                        }
                    }
                    if (keypass2 == null) continue;
                    key = null;
                    status = 0;
                    errorMes = null;
                    try {
                        key = store.getKey(alias, (char[])id2Keypass.get(id));
                    }
                    catch (NoSuchAlgorithmException e2) {
                        status = 4;
                        Tr.processException((Throwable)e2, (String)(clsName + ".doInit"), (String)"354", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5183E", (Object)new Object[]{alias, path, e2});
                        errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5183E", (String[])new String[]{alias, path, e2.getMessage()});
                    }
                    catch (UnrecoverableKeyException e3) {
                        status = 4;
                        Tr.processException((Throwable)e3, (String)(clsName + ".doInit"), (String)"360", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5184E", (Object)new Object[]{alias, path, e3});
                        errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5184E", (String[])new String[]{alias, path, e3.getMessage()});
                    }
                    if (tc.isDebugEnabled()) {
                        if (key != null) {
                            Tr.debug((TraceComponent)tc, (String)"doInit() - key is not null");
                        } else {
                            Tr.debug((TraceComponent)tc, (String)"doInit() - key is null");
                        }
                    }
                    if (key == null) continue;
                    KeyContainer container2 = new KeyContainer(path, alias, name, key, x509, status, expiration, this.daysInMSBeforeExpireWarning, errorMes);
                    this.fName2PrivContainer.put(container2.getName(), container2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("KeyStoreKeyLocator.doInit() - added priv key for name " + container2.getName()));
                    }
                    if (x509 == null || x509.getSubjectDN() == null || (dnName = x509.getSubjectDN().getName()) == null || dnName.length() <= 0) continue;
                    String nornamizedDn = KeyStoreKeyLocator.encodedName(dnName);
                    this.fName2PrivContainer.put(nornamizedDn, container2);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("KeyStoreKeyLocator.doInit() - added priv key for name " + nornamizedDn));
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"doInit() - private key not found.");
                }
                if ((keypass = (char[])id2Keypass.get(id)) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"doInit() - keypass is not null");
                    }
                    Key key = null;
                    String name = null;
                    int status = 0;
                    expiration = -1L;
                    String errorMes = null;
                    try {
                        key = store.getKey(alias, keypass);
                    }
                    catch (NoSuchAlgorithmException e4) {
                        status = 4;
                        Tr.processException((Throwable)e4, (String)(clsName + ".doInit"), (String)"412", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5183E", (Object)new Object[]{alias, path, e4});
                        errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5183E", (String[])new String[]{alias, path, e4.getMessage()});
                    }
                    catch (UnrecoverableKeyException e5) {
                        status = 4;
                        Tr.processException((Throwable)e5, (String)(clsName + ".doInit"), (String)"418", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5184E", (Object)new Object[]{alias, path, e5});
                        errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5184E", (String[])new String[]{alias, path, e5.getMessage()});
                    }
                    if (key != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"doInit() - key is not null");
                        }
                        name = (String)id2Name.get(id);
                        container = new KeyContainer(path, alias, name, key, null, status, expiration, this.daysInMSBeforeExpireWarning, errorMes);
                        this.fName2Container.put(container.getName(), container);
                        this.fKey2Container.put(key, container);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("KeyStoreKeyLocator.doInit() - added key for name " + container.getName()));
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"doInit() - key is null");
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"doInit() - keypass is null");
            }
        }
        catch (KeyStoreException e) {
            Tr.processException((Throwable)e, (String)(clsName + ".doInit"), (String)"451", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.KeyStoreKeyLocator.exception", (Object)new Object[]{path, e});
            throw new KeyLocatorException(e.toString());
        }
        if (defaultName != null) {
            this.fDefaultName = KeyStoreKeyLocator.encodedName(defaultName);
        }
        this.fInitialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("doInit() - fInitialized [" + this.fInitialized + "]"));
        }
    }

    public Set getNames(Object context) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getNames(" + context + ")"));
        }
        if (!this.fInitialized) {
            this.doInit();
        }
        Set names = this.fName2Container.keySet();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getNames(Object context) returns " + names));
        }
        return names;
    }

    protected Key getConfidentialKey(String name, Object context) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getConfidentialKey(" + name + "," + context + ")"));
        }
        name = name != null ? KeyStoreKeyLocator.encodedName(name) : this.fDefaultName;
        Key key = null;
        if (name != null) {
            KeyContainer container = (KeyContainer)this.fName2PrivContainer.get(name);
            if (container == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getConfidentialKey - priv key NOT found for " + name));
                    Tr.debug((TraceComponent)tc, (String)("getConfidentialKey - priv container map: " + this.fName2PrivContainer));
                }
                container = (KeyContainer)this.fName2Container.get(name);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getConfKey - priv key found for " + name));
            }
            if (container != null) {
                key = container.getKey();
            }
        }
        if (key == null) {
            String resKey = "security.wssecurity.KeyStoreKeyLocator.s41";
            Tr.error((TraceComponent)tc, (String)resKey);
            throw new KeyLocatorException(ConfigUtil.getMessage((String)resKey) + name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getConfidentialKey(String name, Object context) returns " + key));
        }
        return key;
    }

    public Key getEncryptionKey(String name, Object context) throws KeyLocatorException {
        KeyContainer container;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEncryptionKey(" + name + "," + context + ")"));
        }
        if (!this.fInitialized) {
            this.doInit();
        }
        name = name != null ? KeyStoreKeyLocator.encodedName(name) : this.fDefaultName;
        Key key = null;
        if (name != null && (container = (KeyContainer)this.fName2Container.get(name)) != null) {
            key = container.getKey();
        }
        if (key == null) {
            String resKey = "security.wssecurity.KeyStoreKeyLocator.s41";
            Tr.error((TraceComponent)tc, (String)resKey);
            throw new KeyLocatorException(ConfigUtil.getMessage((String)resKey) + name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEncryptionKey(String name, Object context) returns " + key));
        }
        return key;
    }

    public Key getDecryptionKey(String name, Object context) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getDecryptionKey(" + name + "," + context + ")"));
        }
        if (!this.fInitialized) {
            this.doInit();
        }
        Key key = this.getConfidentialKey(name, context);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getDecryptionKey(String name, Object context) returns " + key));
        }
        return key;
    }

    public Key getSigningKey(String name) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getSigningKey(" + name + ")"));
        }
        if (!this.fInitialized) {
            this.doInit();
        }
        Key key = this.getConfidentialKey(name, null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSigningKey(String name) returns " + key));
        }
        return key;
    }

    public Key getVerificationKey(String name) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getVefificationKey(" + name + ")"));
        }
        if (!this.fInitialized) {
            this.doInit();
        }
        Key key = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getVerificationKey(String name) returns " + key));
        }
        return key;
    }

    public String getName(Key key) throws KeyLocatorException {
        KeyContainer container;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getName(" + key + ")"));
        }
        if (!this.fInitialized) {
            this.doInit();
        }
        String name = null;
        if (key != null && (container = (KeyContainer)this.fKey2Container.get(key)) != null) {
            name = container.getName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getName(Key key) returns " + name));
        }
        return name;
    }

    public Certificate getCertificate(Key key) throws KeyLocatorException {
        KeyContainer container;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCertificate(" + key + ")"));
        }
        if (!this.fInitialized) {
            this.doInit();
        }
        Certificate cert = null;
        if (key != null && (container = (KeyContainer)this.fKey2Container.get(key)) != null) {
            cert = container.getCertificate();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCertificate(Key key) returns " + cert));
        }
        return cert;
    }

    public Certificate getCertificate(String name) throws KeyLocatorException {
        KeyContainer container;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCertificate(" + name + ")"));
        }
        if (!this.fInitialized) {
            this.doInit();
        }
        name = name != null ? KeyStoreKeyLocator.encodedName(name) : this.fDefaultName;
        Certificate cert = null;
        if (name != null && (container = (KeyContainer)this.fName2Container.get(name)) != null) {
            cert = container.getCertificate();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCertificate(String name) returns " + cert));
        }
        return cert;
    }

    public static String encodedName(String dn) throws KeyLocatorException {
        String encoded;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("encodedName(" + dn + ")"));
        }
        if ((encoded = KeyInfo.X509Data.encodeDName((String)dn)) == null) {
            String resKey = "security.wssecurity.KeyStoreKeyLocator.malformedname";
            Tr.error((TraceComponent)tc, (String)resKey, (Object)new Object[]{dn});
            throw new KeyLocatorException(MessageFormat.format(ConfigUtil.getMessage((String)resKey), dn));
        }
        if (encoded.length() == 0) {
            encoded = dn;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("encodedName(String dn) returns " + encoded));
        }
        return encoded;
    }

    public String getName(String name) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getName(" + name + ")"));
        }
        if (!this.fInitialized) {
            this.doInit();
        }
        name = name != null ? KeyStoreKeyLocator.encodedName(name) : this.fDefaultName;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getName(String name) returns " + name));
        }
        return name;
    }

    class KeyContainer {
        private String fKspath;
        private String fAlias;
        private String fName;
        private Key fKey;
        private Certificate fCertificate;
        private int fStatus;
        private long fExpiration;
        private long fDaysInMSBeforeExpireWarning;
        private String fErrorMes;

        private KeyContainer(String ksPath, String alias, String name, Key key, Certificate cert, int status, long expiration, long daysInMSBeforeExpireWarning, String errorMes) throws KeyLocatorException {
            this.fKspath = ksPath;
            this.fAlias = alias;
            this.fName = KeyStoreKeyLocator.encodedName(name);
            this.fKey = key;
            this.fCertificate = cert;
            this.fStatus = status;
            this.fExpiration = expiration;
            this.fDaysInMSBeforeExpireWarning = daysInMSBeforeExpireWarning;
            this.fErrorMes = errorMes;
        }

        private String getName() {
            return this.fName;
        }

        private Key getKey() throws KeyLocatorException {
            if ((this.fStatus & 1) == 1 || (this.fStatus & 4) == 4) {
                throw new KeyLocatorException(this.fErrorMes);
            }
            return this.fKey;
        }

        private Certificate getCertificate() throws KeyLocatorException {
            if ((this.fStatus & 1) == 1) {
                throw new KeyLocatorException(this.fErrorMes);
            }
            this.checkExpiration();
            return this.fCertificate;
        }

        private void checkExpiration() throws KeyLocatorException {
            if (this.fExpiration >= 0L) {
                long millisBeforeExpiration = this.fExpiration - System.currentTimeMillis();
                if (millisBeforeExpiration < 0L) {
                    ++this.fStatus;
                    this.fErrorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5181E", (String[])new String[]{this.fName, this.fAlias, this.fKspath, "expiration time - current system time = " + millisBeforeExpiration + " ms."});
                    throw new KeyLocatorException(this.fErrorMes);
                }
                if (millisBeforeExpiration < this.fDaysInMSBeforeExpireWarning) {
                    long daysLeft = millisBeforeExpiration / 86400000L;
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5189W", (Object)new Object[]{this.fName, this.fAlias, this.fKspath, new Long(daysLeft)});
                }
            }
        }
    }
}

