/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.config;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.wsspi.wssecurity.config.KeyLocatorException;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CertInRequestKeyLocator
implements KeyLocator {
    private static final TraceComponent tc = Tr.register(CertInRequestKeyLocator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = CertInRequestKeyLocator.class.getName();
    private static final String F_CERTIFICATE = clsName + ".fCert";
    private static final String F_KEY = clsName + ".fKey";
    private static final String F_NAME = clsName + ".fName";
    private static final String F_NAMES = clsName + ".fNames";

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(map)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init()");
        }
    }

    private void getCertInRequest(Object context) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCertInRequest(" + context + ")"));
        }
        if (!(context instanceof Map)) {
            throw new KeyLocatorException("Internal error: invalid context object.");
        }
        Object obj = ((Map)context).get("com.ibm.xml.soapsec.RequestCert");
        if (!(obj instanceof X509Certificate)) {
            String resKey = "security.wssecurity.CertInRequestKeyLocator.nocert";
            Tr.error((TraceComponent)tc, (String)resKey);
            throw new KeyLocatorException(ConfigUtil.getMessage((String)resKey));
        }
        MessageContext ctx = this.getMessageContext();
        X509Certificate tmpCert = (X509Certificate)obj;
        ctx.setProperty(F_CERTIFICATE, tmpCert);
        ctx.setProperty(F_KEY, tmpCert.getPublicKey());
        String tmpName = tmpCert.getSubjectDN().getName();
        HashSet<String> tmpSet = new HashSet<String>();
        tmpSet.add(tmpName);
        ctx.setProperty(F_NAME, tmpName);
        ctx.setProperty(F_NAMES, tmpSet);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCertInRequest(Object context)");
        }
    }

    public Set getNames(Object context) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getNames(" + context + ")"));
        }
        if (this.getFName() == null) {
            this.getCertInRequest(context);
        }
        Set ret = this.getFNames();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getNames(Object context) returns " + ret));
        }
        return ret;
    }

    public Key getEncryptionKey(String name, Object context) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEncryptionKey(" + name + "," + context + ")"));
        }
        if (this.getFCert() == null) {
            this.getCertInRequest(context);
        }
        Key ret = this.getFKey();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEncryptionKey(String name, Object context) returns " + ret));
        }
        return ret;
    }

    public Key getDecryptionKey(String name, Object context) throws KeyLocatorException {
        throw new KeyLocatorException("Not implemented.");
    }

    public Key getSigningKey(String name) throws KeyLocatorException {
        throw new KeyLocatorException("Not implemented.");
    }

    public Key getVerificationKey(String name) throws KeyLocatorException {
        throw new KeyLocatorException("Not implemented.");
    }

    public String getName(Key key) throws KeyLocatorException {
        String ret;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getName(" + key + ")"));
        }
        if ((ret = this.getFName()) == null) {
            String resKey = "security.wssecurity.CertInRequestKeyLocator.nocert";
            Tr.error((TraceComponent)tc, (String)resKey);
            throw new KeyLocatorException(ConfigUtil.getMessage((String)resKey));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getName(Key key) returns " + ret));
        }
        return ret;
    }

    public String getName(String name) throws KeyLocatorException {
        String ret;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getName(" + name + ")"));
        }
        if ((ret = this.getFName()) == null) {
            String resKey = "security.wssecurity.CertInRequestKeyLocator.nocert";
            Tr.error((TraceComponent)tc, (String)resKey);
            throw new KeyLocatorException(ConfigUtil.getMessage((String)resKey));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getName(String name) returns " + ret));
        }
        return ret;
    }

    public Certificate getCertificate(Key key) throws KeyLocatorException {
        X509Certificate ret;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCertificate(" + key + ")"));
        }
        if ((ret = this.getFCert()) == null) {
            String resKey = "security.wssecurity.CertInRequestKeyLocator.nocert";
            Tr.error((TraceComponent)tc, (String)resKey);
            throw new KeyLocatorException(ConfigUtil.getMessage((String)resKey));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCertificate(Key key) returns " + ret));
        }
        return ret;
    }

    public Certificate getCertificate(String name) throws KeyLocatorException {
        X509Certificate ret;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCertificate(" + name + ")"));
        }
        if ((ret = this.getFCert()) == null) {
            String resKey = "security.wssecurity.CertInRequestKeyLocator.nocert";
            Tr.error((TraceComponent)tc, (String)resKey);
            throw new KeyLocatorException(ConfigUtil.getMessage((String)resKey));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCertificate(String name) returns " + ret));
        }
        return ret;
    }

    private MessageContext getMessageContext() throws KeyLocatorException {
        MessageContext ctx;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMessageContext()");
        }
        if ((ctx = MessageContext.getCurrentThreadsContext()) == null) {
            throw new KeyLocatorException("Internal error: message context is null.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMessageContext()");
        }
        return ctx;
    }

    private X509Certificate getFCert() throws KeyLocatorException {
        return (X509Certificate)this.getMessageContext().getProperty(F_CERTIFICATE);
    }

    private Key getFKey() throws KeyLocatorException {
        return (Key)this.getMessageContext().getProperty(F_KEY);
    }

    private String getFName() throws KeyLocatorException {
        return (String)this.getMessageContext().getProperty(F_NAME);
    }

    private Set getFNames() throws KeyLocatorException {
        return (Set)this.getMessageContext().getProperty(F_NAMES);
    }
}

