/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.token;

import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.WSSToken;
import com.ibm.xml.soapsec.util.CertificateUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

public class X509BSToken
extends WSSToken {
    private static final TraceComponent tc = Tr.register(X509BSToken.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = X509BSToken.class.getName();
    private static final String setCertPermission = "wssecurity.X509BSToken.setCert";
    private static final String setBytesPermission = "wssecurity.X509BSToken.setBytes";
    private static final WebSphereRuntimePermission SETCERT_PERM = new WebSphereRuntimePermission("wssecurity.X509BSToken.setCert");
    private static final WebSphereRuntimePermission SETBYTES_PERM = new WebSphereRuntimePermission("wssecurity.X509BSToken.setBytes");
    public static final String KEY_LOCATOR = "com.ibm.wsspi.wssecurity.token.x509.keyLocator";
    public static final String CERT_INFO = "com.ibm.wsspi.wssecurity.token.x509.certificate";
    public static final String TRUST_ANY = "com.ibm.wsspi.wssecurity.token.x509.trustAny";
    public static final String PROVIDER = "com.ibm.wsspi.wssecurity.token.x509.provider";
    public static final String PKIX_BUILDERPARAM = "com.ibm.wsspi.wssecurity.token.x509.pkixBuilderParam";
    public static final String CERT_STORES = "com.ibm.wsspi.wssecurity.token.x509.certStores";
    private X509Certificate _cert;
    private String _uid;
    private byte[] _binary;
    private volatile int hashCode = 0;
    private boolean _isValid = false;

    public X509BSToken(String tokenId, X509Certificate cert, QName vtype) {
        this._tokenId = tokenId == null ? "" : tokenId;
        this._cert = cert;
        this._uid = null;
        this._vtype = vtype;
    }

    public X509Certificate getCert() throws SoapSecurityException {
        if (this._cert != null) {
            if (this.isReadOnly()) {
                try {
                    return CertificateUtil.generateX509Certificate((byte[])this._cert.getEncoded(), null);
                }
                catch (Exception e) {
                    throw SoapSecurityException.format("security.wssecurity.X509BSToken.getCert01", e);
                }
            }
            return this._cert;
        }
        if (this._binary != null) {
            try {
                this._cert = CertificateUtil.generateX509Certificate((byte[])this._binary, null);
                this._uid = null;
                if (this.isReadOnly()) {
                    return CertificateUtil.generateX509Certificate((byte[])this._binary, null);
                }
                return this._cert;
            }
            catch (Exception e) {
                throw SoapSecurityException.format("security.wssecurity.X509BSToken.getCert01", e);
            }
        }
        if (this._tokenelem != null) {
            return null;
        }
        return null;
    }

    public void setCert(X509Certificate cert) {
        Tr.entry((TraceComponent)tc, (String)"setCert");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + SETCERT_PERM.toString()));
            }
            sm.checkPermission(SETCERT_PERM);
        }
        Tr.exit((TraceComponent)tc, (String)"setCert");
        if (this.isReadOnly()) {
            return;
        }
        this._cert = cert;
        this._uid = null;
    }

    public byte[] getBytes() {
        try {
            if (this.isReadOnly()) {
                byte[] thisBinary = new byte[this._binary.length];
                System.arraycopy(this._binary, 0, thisBinary, 0, this._binary.length);
                return thisBinary != null ? thisBinary : (byte[])(this._cert != null ? this._cert.getEncoded() : null);
            }
            return this._binary != null ? this._binary : (byte[])(this._cert != null ? this._cert.getEncoded() : null);
        }
        catch (CertificateEncodingException e) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.X509BSToken.getBytes01", (Object)new Object[]{this._cert, e});
            return null;
        }
    }

    public void setBytes(byte[] binary) {
        Tr.entry((TraceComponent)tc, (String)"setBytes");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + SETBYTES_PERM.toString()));
            }
            sm.checkPermission(SETBYTES_PERM);
        }
        Tr.exit((TraceComponent)tc, (String)"setBytes");
        if (this.isReadOnly()) {
            return;
        }
        this._binary = binary;
    }

    public long getExpiration() {
        long expiration = 0L;
        if (this._cert != null) {
            Date expirationDate = this._cert.getNotAfter();
            expiration = expirationDate.getTime();
        }
        return expiration;
    }

    public void setExpiration(long expiration) {
    }

    public String getPrincipal() {
        String ret = null;
        if (this._cert != null) {
            ret = this._cert.getSubjectDN().getName();
        }
        return ret;
    }

    public String getUniqueID() {
        if (this._uid == null) {
            this._uid = String.valueOf(this.hashCode());
        }
        if (this.isReadOnly()) {
            String thisUid = new String(this._uid);
            return thisUid;
        }
        return this._uid;
    }

    public int hashCode() {
        if (this.hashCode == 0 && this._cert != null) {
            this.hashCode = this._cert.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof X509BSToken)) {
            return false;
        }
        X509BSToken tok = (X509BSToken)o;
        return tok.hashCode() == this.hashCode();
    }

    public boolean isValid() {
        if (this._cert != null) {
            try {
                this._cert.checkValidity();
                this._isValid = true;
            }
            catch (Exception e) {
                this._isValid = false;
            }
        }
        return this._isValid;
    }

    public short getVersion() {
        short ret = -1;
        if (this._cert != null) {
            ret = new Integer(this._cert.getVersion()).shortValue();
        }
        return ret;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("X509BSToken[tokenId=[").append(this._tokenId);
        buf.append("], element=[").append(DOMUtil.getDisplayName((Node)this._tokenelem));
        if (this._cert == null) {
            buf.append("], cert=[null");
        } else {
            buf.append("], cert=[SubjectDN=").append(this._cert.getSubjectDN());
            buf.append(", IssuerDN=").append(this._cert.getIssuerDN());
            buf.append(", IssuerSerial=").append(this._cert.getSerialNumber());
        }
        buf.append("]");
        return buf.toString();
    }
}

