/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.auth.token.WSSToken;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LTPAToken
extends WSSToken {
    private static final TraceComponent tc = Tr.register(LTPAToken.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String compName = "security.wssecurity";
    private static final String setBytesPermission = "wssecurity.LTPAToken.setBytes";
    private static final String getBytesPermission = "wssecurity.LTPAToken.getBytes";
    private String uid = null;
    private byte[] _cred = null;
    private String _username = null;
    private char[] _password = null;
    private QName DEFAULT_VALUE_TYPE = Constants.LTPA_TOKEN;
    private WSCredential _wsCred = null;
    private volatile int hashCode = 0;
    private static final WebSphereRuntimePermission SETBYTES_PERM = new WebSphereRuntimePermission("wssecurity.LTPAToken.setBytes");
    private static final WebSphereRuntimePermission GETBYTES_PERM = new WebSphereRuntimePermission("wssecurity.LTPAToken.getBytes");

    public LTPAToken(String tokenId, byte[] cred, String username, char[] password, Element elem) {
        this._tokenId = tokenId == null ? "" : tokenId;
        this._cred = cred;
        this._username = username;
        this._password = password;
        this._tokenelem = elem;
        this._vtype = this.DEFAULT_VALUE_TYPE;
    }

    public LTPAToken(String tokenId, byte[] cred) {
        this(tokenId, cred, null, null, null);
    }

    public void setBytes(byte[] cred) {
        Tr.entry(tc, "setBytes");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETBYTES_PERM.toString());
            }
            sm.checkPermission(SETBYTES_PERM);
        }
        Tr.exit(tc, "setBytes");
        if (this.isReadOnly()) {
            return;
        }
        this._cred = cred;
    }

    public byte[] getBytes() {
        Tr.entry(tc, "getBytes");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GETBYTES_PERM.toString());
            }
            sm.checkPermission(GETBYTES_PERM);
        }
        Tr.exit(tc, "getBytes");
        if (this.isReadOnly()) {
            byte[] cred = new byte[this._cred.length];
            System.arraycopy(this._cred, 0, cred, 0, this._cred.length);
            return cred;
        }
        return this._cred;
    }

    public boolean isValid() {
        return false;
    }

    public long getExpiration() {
        if (this._wsCred != null) {
            try {
                return this._wsCred.getExpiration();
            }
            catch (Exception e) {
                Tr.error(tc, "security.wssecurity.WSEC0156E", e);
                return -1L;
            }
        }
        return 0L;
    }

    public String getPrincipal() {
        if (this.isReadOnly()) {
            String thisUsername = new String(this._username);
            return thisUsername;
        }
        return this._username;
    }

    public String getUniqueID() {
        if (this.uid == null) {
            this.uid = String.valueOf(this.hashCode());
        }
        return this.uid;
    }

    public int hashCode() {
        if (this.hashCode == 0 && this._cred != null && this._cred.length > 0) {
            String credStr = new String(this._cred);
            this.hashCode = credStr.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LTPAToken)) {
            return false;
        }
        LTPAToken tok = (LTPAToken)o;
        return tok.hashCode() == this.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("LTPAToken[tokenId=[").append(this._tokenId);
        buf.append("], element=[").append(DOMUtil.getDisplayName((Node)this._tokenelem));
        buf.append("], username=[").append(this._username);
        buf.append("]");
        return buf.toString();
    }
}

