/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.module;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.token.UserRegistryProcessor;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.auth.callback.PropertyCallback;
import com.ibm.wsspi.wssecurity.auth.token.UsernameToken;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class UsernameLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(UsernameLoginModule.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private String comp = "security.wssecurity";
    private static final String clsName = UsernameLoginModule.class.getName();
    private Subject _subject;
    private CallbackHandler _handler;
    private Map _sharedState;
    private Map _options;
    private String _username;
    private char[] _password;
    private Map _properties = null;
    private SOAPMessageContext _messageContext = null;
    private boolean disableURCheck = false;
    private static final String _DISABLE_REGISTRY_CHECK = "com.ibm.wsspi.wssecurity.auth.module.UsernameLoginModule.disableUserRegistryCheck";

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize(Subject subject,CallbackHandler handler,Map sharedState,Map options)");
        }
        this._subject = subject;
        this._handler = handler;
        this._sharedState = sharedState;
        this._options = options;
        if (this._handler != null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CallbackHandler: " + this._handler.getClass().getName()));
        }
        this.disableURCheck = "true".equalsIgnoreCase((String)this._options.get(_DISABLE_REGISTRY_CHECK));
        if (tc.isDebugEnabled() && this.disableURCheck) {
            Tr.debug((TraceComponent)tc, (String)"com.ibm.wsspi.wssecurity.auth.module.UsernameLoginModule.disableUserRegistryCheck=true.  UsernameLoginModule user registry checking will be disabled");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize(Subject subject,CallbackHandler handler,Map sharedState,Map options)");
        }
    }

    public boolean login() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"login()");
        }
        boolean ret = true;
        NameCallback usernameCB = new NameCallback("username: ");
        PasswordCallback passwordCB = new PasswordCallback("password: ", false);
        PropertyCallback propertyCB = new PropertyCallback(null);
        Callback[] callbacks = new Callback[]{usernameCB, passwordCB, propertyCB};
        String disableSingleURCheck = null;
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            throw new LoginException(ConfigUtil.getMessage((String)(this.comp + ".BSTokenLoginModule.s01"), (String[])new String[]{e.toString()}));
        }
        this._username = usernameCB.getName();
        this._password = passwordCB.getPassword();
        this._properties = propertyCB.getProperties();
        if (this._properties != null) {
            this._messageContext = (SOAPMessageContext)this._properties.get("com.ibm.wsspi.wssecurity.core.messageContext");
            disableSingleURCheck = (String)this._properties.get(_DISABLE_REGISTRY_CHECK);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("usernameCB [" + usernameCB + "], passwordCB [" + passwordCB));
            String pwd = this._password == null ? "null" : "not null";
            Tr.debug((TraceComponent)tc, (String)("username [" + this._username + "], password [" + pwd + "]"));
        }
        if (this.disableURCheck || disableSingleURCheck != null && "true".equals(disableSingleURCheck)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Skipping registry check, returning true.");
            }
            ret = true;
        } else if (this._username != null && this._username.length() > 0) {
            boolean checkRegistry = UserRegistryProcessor.checkRegistry(this._username, this._password);
            if (!checkRegistry) {
                throw new LoginException(ConfigUtil.getMessage((String)(this.comp + ".UserRegistryProcessor.s01"), (String[])new String[]{this._username, "UserRegistryProcessor.checkRegistry()=" + checkRegistry}));
            }
        } else {
            ret = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login()");
        }
        return ret;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit()");
        }
        boolean ret = true;
        boolean uncheck = false;
        UsernameToken token = new UsernameToken(null, null, null);
        if (this._username != null && this._username.length() > 0) {
            final UsernameToken tokenPriv = token;
            final String usernamePriv = this._username;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    tokenPriv.setUsername(usernamePriv);
                    return null;
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Added Username [" + this._username + "]."));
            }
            uncheck = true;
        } else {
            ret = false;
        }
        if (this._password != null && this._password.length > 0) {
            final char[] passwordPriv = this._password;
            final UsernameToken tokenPriv = token;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    tokenPriv.setPassword(passwordPriv);
                    return null;
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Added Password [not null].");
            }
        }
        if (!uncheck) {
            throw new LoginException(ConfigUtil.getMessage((String)(this.comp + ".LoginProcessor.s11")));
        }
        if (this._properties == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WARNING: Can't return username and user password because properties parameter is null.");
            }
        } else {
            this._properties.put(Constants.WSSECURITY_TOKEN_LOGININFO, token);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"commit()");
        }
        return ret;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logout()");
        }
        return true;
    }
}

