/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.module;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.wssecurity.util.KRB5Util;
import com.ibm.wsspi.wssecurity.token.KRBMappedIdentityToken;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public abstract class KRBIdentityMappingLoginModule
implements LoginModule {
    private static final String comp = "security.wssecurity.KRBIdentityMappingLoginModule";
    private Subject subject = null;
    private Map sharedState = null;
    private static TraceComponent tc = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize()");
        }
        this.subject = subject;
        this.sharedState = sharedState;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize()");
        }
    }

    public abstract boolean login() throws LoginException;

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        boolean bResult = false;
        try {
            KRBMappedIdentityToken krbMappedIdentityToken;
            String mapped_was_principal = (String)this.sharedState.get("com.ibm.wsspi.wssecurity.Constants.Mapped_DN");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Mapped kerberos was principal " + mapped_was_principal);
            }
            HashMap<String, String> krbProperties = new HashMap<String, String>();
            krbProperties.put("WASPrincipal", mapped_was_principal);
            krbProperties.put("uniqueID", "mapped_" + KRB5Util.getUniqueID(mapped_was_principal, true));
            krbProperties.put("ValueType", "http://www.ibm.com/WebSphere#KerberosMappedToken");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Create a Kerberos Mapped Identity Token");
            }
            if (KRB5Util.addCredentialToSubject(this.subject, krbMappedIdentityToken = new KRBMappedIdentityToken(krbProperties))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Subject is updated with mapped kerberos token.");
                }
                bResult = true;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Subject is not updated with mapped kerberos token.");
            }
        }
        catch (Throwable t) {
            Tr.error(tc, "security.wssecurity.kerberos.unexpected.exception", KRB5Util.stackToString(t));
            FFDCFilter.processException(t, KRBIdentityMappingLoginModule.class.getName(), "1");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return bResult;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        this.cleanup();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        this.cleanup();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }

    private void cleanup() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }

    static {
        tc = Tr.register(KRBIdentityMappingLoginModule.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    }
}

