/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.module;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.wsspi.wssecurity.auth.callback.PropertyCallback;
import com.ibm.wsspi.wssecurity.auth.module.WSSecurityMappingModule;
import com.ibm.xml.soapsec.util.Tr;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class IDAssertionLoginModule
extends WSSecurityMappingModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = false;
    private boolean disableURCheck = true;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username = null;
    private Map properties = null;
    private static final String _LOGINUSERNAME = "LoginUsername";
    private static final String _DISABLE_REGISTRY_CHECK = "com.ibm.wsspi.wssecurity.auth.module.IDAssertionLoginModule.disableUserRegistryCheck";
    private static final String clsName = IDAssertionLoginModule.class.getName();
    private static final TraceComponent tc = com.ibm.ejs.ras.Tr.register(IDAssertionLoginModule.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final WebSphereRuntimePermission PERM = new WebSphereRuntimePermission("wssecurity.IDAssertionLoginModule.login");

    public IDAssertionLoginModule() {
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.entry(tc, "IDAssertionLoginModule()");
        }
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit(tc, "IDAssertionLoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.entry(tc, "initialize()", new Object[]{subject, callbackHandler, sharedState, options});
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        String val = (String)this.options.get(_DISABLE_REGISTRY_CHECK);
        if (val != null) {
            this.disableURCheck = "true".equalsIgnoreCase(val);
        }
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit(tc, "initialize()");
        }
    }

    public boolean login() throws LoginException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.entry(tc, "login()");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(PERM);
        }
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler available to garner authentication information from the user.");
        }
        this.succeeded = false;
        this.username = null;
        this.properties = null;
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PropertyCallback(null)};
        try {
            this.callbackHandler.handle(callbacks);
            String DN = (String)this.sharedState.get("com.ibm.wsspi.wssecurity.Constants.DN");
            if (DN != null && (DN = DN.trim()).length() != 0) {
                if (this.debug || tc.isDebugEnabled()) {
                    com.ibm.ejs.ras.Tr.debug(tc, "The identity is overrided by user in the shared state");
                }
                this.username = DN;
            }
            if (this.username == null) {
                this.username = ((NameCallback)callbacks[0]).getName();
            }
            if (this.debug || tc.isDebugEnabled()) {
                com.ibm.ejs.ras.Tr.debug(tc, "login() - username is " + this.username);
            }
            this.properties = ((PropertyCallback)callbacks[1]).getProperties();
            if (this.debug || tc.isDebugEnabled()) {
                com.ibm.ejs.ras.Tr.debug(tc, "login() - properties are " + this.properties);
            }
        }
        catch (IOException ioe) {
            Tr.processException((Throwable)ioe, (String)(clsName + ".login"), (String)"174", (Object)this);
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            Tr.processException((Throwable)uce, (String)(clsName + ".login"), (String)"178", (Object)this);
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication" + " information from the user");
        }
        if (this.disableURCheck) {
            this.succeeded = true;
        } else {
            if (tc.isDebugEnabled()) {
                com.ibm.ejs.ras.Tr.debug(tc, "Invoking jaas login for: " + this.username);
            }
            this.succeeded = this._login(this.username);
        }
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit(tc, "login() returns " + this.succeeded + ", username is " + this.username);
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.entry(tc, "commit()");
        }
        this.commitSucceeded = false;
        if (!this.succeeded) {
            if (this.debug || tc.isDebugEnabled()) {
                com.ibm.ejs.ras.Tr.debug(tc, "Do not commit() because login() failed.");
            }
        } else {
            if (this.debug || tc.isDebugEnabled()) {
                com.ibm.ejs.ras.Tr.debug(tc, "Starting to commit changes to subject.");
            }
            if (this.properties == null) {
                if (tc.isDebugEnabled()) {
                    com.ibm.ejs.ras.Tr.debug(tc, "WARNING: Can't return username because properties parameter is null.");
                }
            } else {
                this.properties.put(_LOGINUSERNAME, this.username);
                if (this.debug || tc.isDebugEnabled()) {
                    com.ibm.ejs.ras.Tr.debug(tc, "Commit succeeded!");
                }
                this.commitSucceeded = true;
            }
        }
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit(tc, "commit() returns " + this.commitSucceeded);
        }
        return this.commitSucceeded;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.entry(tc, "abort()");
        }
        this.cleanup();
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.entry(tc, "logout()");
        }
        this.cleanup();
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit(tc, "logout()");
        }
        return true;
    }

    private void cleanup() {
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.entry(tc, "cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        this.username = null;
        if (this.properties != null) {
            this.properties.remove(_LOGINUSERNAME);
            this.properties = null;
        }
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit(tc, "cleanup()");
        }
    }
}

