/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.callback;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.BSTokenCallbackHandler;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class X509CallbackHandler
extends BSTokenCallbackHandler {
    private static final TraceComponent tc = Tr.register(X509CallbackHandler.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = X509CallbackHandler.class.getName();

    public X509CallbackHandler(Map properties) {
        super(properties);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"X509CallbackHandler(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"X509CallbackHandler(Map properties)");
        }
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        BSTokenCallbackHandler.TokenInformation tinfo;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handle(Callback[] callbacks)");
        }
        if ((tinfo = super._handle(callbacks)) != null && tinfo._config != null) {
            try {
                Certificate cert;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Getting the X509 Certificate with the alias [" + tinfo._alias + "]."));
                }
                if ((cert = tinfo._config.getCertificate(tinfo._alias)) == null) {
                    throw this.processError(tinfo);
                }
                if (cert instanceof X509Certificate) {
                    tinfo._bsCallback.setCert((X509Certificate)cert);
                    tinfo._bsCallback.setKeyStorePath(tinfo._config.getKeyStorePath());
                    tinfo._bsCallback.setAlias(tinfo._alias);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Succeeded to get the X509 Certificate with the alias [" + tinfo._alias + "]."));
                    }
                }
            }
            catch (SoapSecurityException e) {
                Tr.processException((Throwable)e, (String)(clsName + ".handle"), (String)"106", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.X509CallbackHandler.s01", (Object)new Object[]{e});
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handle(Callback[] callbacks)");
        }
    }
}

