/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.callback;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.BSTokenCallbackHandler;
import com.ibm.xml.soapsec.util.CertificateUtil;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class PKCS7CallbackHandler
extends BSTokenCallbackHandler {
    private static final TraceComponent tc = Tr.register(PKCS7CallbackHandler.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = PKCS7CallbackHandler.class.getName();

    public PKCS7CallbackHandler(Map properties) {
        super(properties);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"PKCS7CallbackHandler(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"PKCS7CallbackHandler(Map properties)");
        }
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        BSTokenCallbackHandler.TokenInformation tinfo;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("handle(Callback[] callbacks[" + callbacks + "])"));
        }
        if ((tinfo = super._handle(callbacks)) != null && tinfo._config != null) {
            Provider provider = (Provider)tinfo._properties.get("com.ibm.wsspi.wssecurity.token.x509.provider");
            List certStores = (List)tinfo._properties.get("com.ibm.wsspi.wssecurity.token.x509.certStores");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Provider [" + provider + "], CertStores [" + certStores + "]."));
            }
            try {
                byte[] binary;
                Certificate cert;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Getting the X509 Certificate with the alias [" + tinfo._alias + "]."));
                }
                if ((cert = tinfo._config.getCertificate(tinfo._alias)) == null) {
                    throw this.processError(tinfo);
                }
                if (cert instanceof X509Certificate) {
                    tinfo._bsCallback.setCert((X509Certificate)cert);
                    tinfo._bsCallback.setKeyStorePath(tinfo._config.getKeyStorePath());
                    tinfo._bsCallback.setAlias(tinfo._alias);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Succeeded to get the X509 Certificate with the alias [" + tinfo._alias + "]."));
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Genarating the pkcs7 with the alias [" + tinfo._alias + "]."));
                }
                if ((binary = CertificateUtil.encodePKCS7((Provider)provider, (List)certStores, (KeyStore)tinfo._config.getKeyStore(), (String)tinfo._alias)) == null) {
                    throw new IOException(ConfigUtil.getMessage((String)"security.wssecurity.PkiPathCallbackHandler.s02"));
                }
                tinfo._bsCallback.setBinary(binary);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Succeeded to generate the pkcs7 with the alias [" + tinfo._alias + "]."));
                }
            }
            catch (CertStoreException e) {
                Tr.processException((Throwable)e, (String)(clsName + ".handle"), (String)"139", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.PkiPathCallbackHandler.s01", (Object)new Object[]{e});
                IOException ioe = new IOException(ConfigUtil.getMessage((String)"security.wssecurity.PkiPathCallbackHandler.s01", (String[])new String[]{e.getClass().getName() + ": " + e.getMessage()}));
                ioe.initCause(e);
                throw ioe;
            }
            catch (KeyStoreException e) {
                Tr.processException((Throwable)e, (String)(clsName + ".handle"), (String)"146", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.PkiPathCallbackHandler.s01", (Object)new Object[]{e});
                IOException ioe = new IOException(ConfigUtil.getMessage((String)"security.wssecurity.PkiPathCallbackHandler.s01", (String[])new String[]{e.getClass().getName() + ": " + e.getMessage()}));
                ioe.initCause(e);
                throw ioe;
            }
            catch (SoapSecurityException e) {
                Tr.processException((Throwable)e, (String)(clsName + ".handle"), (String)"153", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.PkiPathCallbackHandler.s01", (Object)new Object[]{e});
                IOException ioe = new IOException(ConfigUtil.getMessage((String)"security.wssecurity.PkiPathCallbackHandler.s01", (String[])new String[]{e.getClass().getName() + ": " + e.getMessage()}));
                ioe.initCause(e);
                throw ioe;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handle()");
        }
    }
}

