/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.callback;

import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.token.WSSMarkerObject;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.core.TokenCacheManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.token.PropagationToken;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.wsspi.security.csiv2.CSIv2PerformPolicy;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.wssecurity.auth.callback.BinaryTokenCallback;
import com.ibm.wsspi.wssecurity.auth.callback.PropertyCallback;
import com.ibm.wsspi.wssecurity.auth.callback.TokenPropagationCallbackHandler;
import com.ibm.wsspi.wssecurity.auth.callback.XMLTokenSenderCallback;
import com.ibm.wsspi.wssecurity.config.CallbackHandlerConfig;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;

public class LTPATokenCallbackHandler
implements CallbackHandler {
    private static final TraceComponent tc = Tr.register(LTPATokenCallbackHandler.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = LTPATokenCallbackHandler.class.getName();
    private String _username = "";
    private char[] _password = null;
    private CallbackHandlerConfig _config = null;

    public LTPATokenCallbackHandler() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "GUIPromptCallbackHandler()");
        }
        if ((this._username == null || this._username.length() == 0) && WSSecurityPlatformContextFactory.getInstance().isServer()) {
            Tr.warning(tc, "security.wssecurity.WSEC0151W", this.getClass().getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "GUIPromptCallbackHandler()");
        }
    }

    public LTPATokenCallbackHandler(String userid, char[] password, Map properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "LTPATokenCallbackHandler(String, char[], Map)", new Object[]{"Default user: " + userid});
        }
        this._username = userid;
        this._password = password;
        if ((this._username == null || this._username.length() == 0) && WSSecurityPlatformContextFactory.getInstance().isServer()) {
            Tr.warning(tc, "security.wssecurity.WSEC0151W", this.getClass().getName());
        }
        if (properties == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: The properties parameter is null.");
            }
            this._config = null;
        } else {
            this._config = (CallbackHandlerConfig)properties.get("com.ibm.wsspi.wssecurity.config.callbackHandler.configKey");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CallbackHandlerConfig [" + this._config + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "LTPATokenCallbackHandler(String, char[], Map)");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (LTPATokenCallbackHandler.tc.isEntryEnabled()) {
            Tr.entry(LTPATokenCallbackHandler.tc, "handle(Callback[] callbacks)");
        }
        if (!WSSecurityPlatformContextFactory.getInstance().isServer()) {
            message = MessageFormat.format(ConfigConstants.getMessage("security.wssecurity.WSEC0154E"), new String[]{this.getClass().getName()});
            throw new IOException(message);
        }
        len = 0;
        if (callbacks == null || (len = callbacks.length) == 0) {
            if (LTPATokenCallbackHandler.tc.isDebugEnabled()) {
                Tr.debug(LTPATokenCallbackHandler.tc, "handle(callbacks = \"{ }\")");
            }
            if (LTPATokenCallbackHandler.tc.isEntryEnabled()) {
                Tr.exit(LTPATokenCallbackHandler.tc, "handle(Callback[] callbacks)");
            }
            return;
        }
        if (LTPATokenCallbackHandler.tc.isDebugEnabled()) {
            sb = new StringBuffer();
            sb.append("{ ");
            for (i = 0; i < len; ++i) {
                sb.append(callbacks[i].getClass().getName());
                if (i >= len - 1) continue;
                sb.append(", ");
            }
            sb.append(" }");
            Tr.debug(LTPATokenCallbackHandler.tc, "handle(callbacks = \"" + sb.toString() + "\")");
        }
        properties = null;
        context = null;
        tokenType = null;
        btCallback = null;
        for (i = 0; i < len; ++i) {
            c = callbacks[i];
            if (c instanceof BinaryTokenCallback) {
                btCallback = (BinaryTokenCallback)c;
                continue;
            }
            if (c instanceof XMLTokenSenderCallback) continue;
            if (callbacks[i] instanceof PropertyCallback) {
                if (properties == null) {
                    properties = ((PropertyCallback)callbacks[i]).getProperties();
                }
                if (properties == null) continue;
                context = (Map)properties.get("com.ibm.ws.webservices.wssecurity.constants.wssecurityContext");
                tokenType = (QName)properties.get("com.ibm.ws.webservices.wssecurity.constants.tokenType");
                if (!LTPATokenCallbackHandler.tc.isDebugEnabled()) continue;
                if (tokenType != null) {
                    Tr.debug(LTPATokenCallbackHandler.tc, "token type is: " + tokenType);
                    continue;
                }
                Tr.debug(LTPATokenCallbackHandler.tc, "token type is null");
                continue;
            }
            throw new UnsupportedCallbackException(c, ConfigConstants.getMessage("security.wssecurity.WSEC0153E"));
        }
        tokenPropagation = false;
        if (tokenType != null && Constants.LTPA_TOKEN_PROPAGATION.equals(tokenType)) {
            tokenPropagation = true;
        }
        if (tokenPropagation && this._username != null && this._username.length() > 0 && this._password != null && this._password.length > 0) {
            Tr.warning(LTPATokenCallbackHandler.tc, "security.wssecurity.WSEC0167W");
            tokenPropagation = false;
        }
        if (LTPATokenCallbackHandler.tc.isDebugEnabled()) {
            Tr.debug(LTPATokenCallbackHandler.tc, "token propagation is " + tokenPropagation);
        }
        contextMgr = ContextManagerFactory.getInstance();
        subject = null;
        wsCred = null;
        token = null;
        if (tokenPropagation) {
            if (!WSSecurityPlatformContextFactory.getInstance().isServerSecurityEnabled()) {
                message = ConfigConstants.getMessage("security.wssecurity.WSEC0166E");
                throw new IOException(message);
            }
            try {
                block52: {
                    tokenMgr = TokenCacheManagerFactory.getInstance();
                    runAsSubject = WSSubject.getRunAsSubject();
                    wsCredTokenMapper = null;
                    uniqueID = null;
                    try {
                        wsCredTokenMapper = _wsCredToken._wsCredTokenMapper;
                        if (wsCredTokenMapper != null && runAsSubject != null) {
                            uniqueID = wsCredTokenMapper.createSubjectUniqueID(runAsSubject);
                        }
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, LTPATokenCallbackHandler.clsName + ".login", "297", this);
                        if (!LTPATokenCallbackHandler.tc.isDebugEnabled()) break block52;
                        Tr.debug(LTPATokenCallbackHandler.tc, "Caught exception while getting unique ID from subject.", new Object[]{e});
                    }
                }
                if (LTPATokenCallbackHandler.tc.isDebugEnabled()) {
                    Tr.debug(LTPATokenCallbackHandler.tc, "Unique ID from tokens in contextSubject: " + uniqueID);
                }
                if (tokenMgr != null && uniqueID != null && uniqueID.length() > 0) {
                    cachedToken = null;
                    cachedToken = tokenMgr.getCachedToken(uniqueID);
                    if (cachedToken != null) {
                        token = cachedToken.getToken();
                        currentTime = System.currentTimeMillis();
                        if (cachedToken.getExpiration() - currentTime > 0L) {
                            if (LTPATokenCallbackHandler.tc.isDebugEnabled()) {
                                Tr.debug(LTPATokenCallbackHandler.tc, "Found cached token based on unique ID.");
                            }
                        } else {
                            if (LTPATokenCallbackHandler.tc.isDebugEnabled()) {
                                Tr.debug(LTPATokenCallbackHandler.tc, "Found cached token, but it is expired.");
                            }
                            token = null;
                        }
                    } else if (LTPATokenCallbackHandler.tc.isDebugEnabled()) {
                        Tr.debug(LTPATokenCallbackHandler.tc, "Did not find cached token based on unique ID.");
                    }
                }
                if (token != null) ** GOTO lbl191
                if (LTPATokenCallbackHandler.tc.isDebugEnabled()) {
                    Tr.debug(LTPATokenCallbackHandler.tc, "Performing login to obtain token.");
                }
                subject = SubjectHelper.createNewSubjectFromExisting(WSSubject.getRunAsSubject());
                configProps = this._config.getProperties();
                jaasConfig = "system.WSS_OUTBOUND";
                if (configProps != null && (obj = configProps.get("com.ibm.ws.webservices.wssecurity.constants.jaasConfig")) != null && obj instanceof String && (tmp = (String)obj).length() > 0) {
                    jaasConfig = tmp;
                }
                if (LTPATokenCallbackHandler.tc.isDebugEnabled()) {
                    Tr.debug(LTPATokenCallbackHandler.tc, "Using JAAS config: " + jaasConfig);
                }
                marker = new WSSMarkerObject(Boolean.TRUE);
                this.addToSubject(subject, marker);
                csiv2PerformPolicy = new CSIv2PerformPolicy((CSIv2EffectivePerformPolicy)null);
                cbh = new TokenPropagationCallbackHandler(context, csiv2PerformPolicy);
                if (cbh == null) {
                    throw new IOException("Unable to get instance of TokenPropagationCallbackHandler");
                }
                lc = new LoginContext(jaasConfig, subject, cbh);
                lc.login();
                newSubject = lc.getSubject();
                tokenHolder = (TokenHolder)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Iterator<TokenHolder> privateCreds = newSubject.getPrivateCredentials(TokenHolder.class).iterator();
                        while (privateCreds != null && privateCreds.hasNext()) {
                            TokenHolder cred = privateCreds.next();
                            if (!(cred instanceof TokenHolder) || !cred.getName().equals(WSOpaqueTokenHelper.getInstance().getOpaqueTokenName()) || cred.getVersion() != WSOpaqueTokenHelper.getInstance().getOpaqueTokenVersion()) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found TokenHolder containing opaque authz token");
                            }
                            return cred;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Did not find TokenHolder containing opaque authz token");
                        }
                        return null;
                    }
                });
                if (tokenHolder != null) {
                    token = tokenHolder.getBytes();
                    if (tokenMgr == null) ** GOTO lbl191
                    expiration = 0L;
                    authn = SubjectHelper.getDefaultAuthTokenFromSubject(newSubject);
                    expiration = authn.getExpiration();
                    cushion = tokenMgr.getCushion();
                    currentTime = System.currentTimeMillis();
                    remaining = expiration - currentTime - cushion;
                    if (remaining < 0L) {
                        if (!LTPATokenCallbackHandler.tc.isDebugEnabled()) ** GOTO lbl191
                        Tr.debug(LTPATokenCallbackHandler.tc, "Token has expired. Do not cache.");
                    }
                    propTok = new PropagationToken(token, expiration - cushion);
                    if (uniqueID == null || uniqueID.length() <= 0 || propTok == null) ** GOTO lbl191
                    if (LTPATokenCallbackHandler.tc.isDebugEnabled()) {
                        Tr.debug(LTPATokenCallbackHandler.tc, "Caching token.");
                    }
                    tokenMgr.cacheToken(uniqueID, propTok);
                }
                if (!LTPATokenCallbackHandler.tc.isDebugEnabled()) ** GOTO lbl191
                Tr.debug(LTPATokenCallbackHandler.tc, "Did not find WSCredential in new Subject.");
            }
            catch (WSSecurityException e) {
                FFDCFilter.processException((Throwable)e, LTPATokenCallbackHandler.class.getName() + ".handle()", "421", this);
                ioe = new IOException("Error doing token propagation processing: " + e.getClass().getName() + ": " + e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
            catch (LoginException e) {
                FFDCFilter.processException((Throwable)e, LTPATokenCallbackHandler.class.getName() + ".handle()", "427", this);
                ioe = new IOException("Error performing login for token propagation: " + e.getClass().getName() + ": " + e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, LTPATokenCallbackHandler.class.getName() + ".handle()", "433", this);
                ioe = new IOException("Error doing token propagation processing: " + e.getClass().getName() + ": " + e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        } else {
            try {
                if (this._username != null && this._username.length() > 0 && this._password != null && this._password.length > 0 && (subject = contextMgr.login(contextMgr.getDefaultRealm(), this._username, String.valueOf(this._password))) != null && (wsCred = SubjectHelper.getWSCredentialFromSubject(subject)) != null) {
                    token = wsCred.getCredentialToken();
                }
            }
            catch (WSLoginFailedException e) {
                FFDCFilter.processException((Throwable)e, LTPATokenCallbackHandler.class.getName() + ".handle()", "454", this);
                ioe = new IOException("Error logging in with userid/password: " + e.getClass().getName() + ": " + e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, LTPATokenCallbackHandler.class.getName() + ".handle()", "461", this);
                ioe = new IOException("Error logging in with userid/password: " + e.getClass().getName() + ": " + e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
            try {
                if (token == null && (subject = WSSubject.getRunAsSubject()) != null && (wsCred = SubjectHelper.getWSCredentialFromSubject(subject)) != null) {
                    token = wsCred.getCredentialToken();
                }
            }
            catch (WSSecurityException e) {
                FFDCFilter.processException((Throwable)e, LTPATokenCallbackHandler.class.getName() + ".handle()", "483", this);
                ioe = new IOException("Error getting runAs Subject: " + e.getClass().getName() + ": " + e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, LTPATokenCallbackHandler.class.getName() + ".handle()", "490", this);
                ioe = new IOException("Error getting runAs Subject: " + e.getClass().getName() + ": " + e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        }
lbl191:
        // 9 sources

        if (contextMgr.isCellSecurityEnabled() && (token == null || token.length == 0)) {
            Tr.warning(LTPATokenCallbackHandler.tc, "security.wssecurity.WSEC0128W");
        }
        if (btCallback != null) {
            btCallback.setCredToken(token);
        }
        if (LTPATokenCallbackHandler.tc.isEntryEnabled()) {
            Tr.exit(LTPATokenCallbackHandler.tc, "handle(Callback[] callbacks)");
        }
    }

    private void addToSubject(final Subject subject, final Object marker) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (!subject.getPrivateCredentials().contains(marker)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding marker to Subject: " + marker);
                    }
                    subject.getPrivateCredentials().add(marker);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Subject already contains marker: " + marker);
                }
                return null;
            }
        });
    }

    private static class _wsCredToken {
        static WSCredentialTokenMapperInterface _wsCredTokenMapper = null;

        private _wsCredToken() {
        }

        static {
            try {
                Class<?> wrapperClass = Class.forName("com.ibm.ws.security.token.WSCredentialTokenMapper");
                Object wrapperObj = wrapperClass.newInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got instance of WSCredTokenMapper.");
                }
                _wsCredTokenMapper = (WSCredentialTokenMapperInterface)wrapperObj;
            }
            catch (Exception ex) {
                FFDCFilter.processException(ex, clsName + "init", "543");
            }
        }
    }
}

