/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.callback;

import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.auth.callback.BinaryTokenCallback;
import com.ibm.wsspi.wssecurity.auth.callback.PropertyCallback;
import com.ibm.wsspi.wssecurity.auth.callback.X509BSCallback;
import com.ibm.wsspi.wssecurity.auth.callback.XMLTokenConsumerCallback;
import com.ibm.wsspi.wssecurity.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.config.KeyLocatorConfig;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public abstract class BSTokenCallbackHandler
implements CallbackHandler {
    private static final TraceComponent tc = Tr.register(BSTokenCallbackHandler.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = BSTokenCallbackHandler.class.getName();
    private final CallbackHandlerConfig _config;
    private final Set _keyInformationList;

    protected BSTokenCallbackHandler(Map properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BSTokenCallbackHandler(Map properties)");
        }
        if (properties == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WARNING: The properties parameter is null.");
            }
            this._config = null;
            this._keyInformationList = null;
        } else {
            this._config = (CallbackHandlerConfig)properties.get("com.ibm.wsspi.wssecurity.config.callbackHandler.configKey");
            if (this._config == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WARNING: The configuration of callback handler is null.");
                }
                this._keyInformationList = null;
            } else {
                this._keyInformationList = this._config.getKeyInformationList();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CallbackHandlerConfig [" + this._config + "]."));
            Tr.debug((TraceComponent)tc, (String)("KeyInformationList is [" + this._keyInformationList + "]."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"BSTokenCallbackHandler(Map properties)");
        }
    }

    public TokenInformation _handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        TokenInformation tinfo;
        String alias;
        SOAPMessageContext messageContext;
        Map properties;
        X509BSCallback bsCallback;
        block17: {
            Iterator it;
            String keyName;
            block16: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"handle(Callback[] callbacks)");
                }
                if (callbacks == null || callbacks.length == 0) {
                    throw new UnsupportedCallbackException(null, "There is no callback.");
                }
                bsCallback = null;
                properties = null;
                messageContext = null;
                alias = null;
                keyName = null;
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof X509BSCallback) {
                        bsCallback = (X509BSCallback)callbacks[i];
                        continue;
                    }
                    if (callbacks[i] instanceof PropertyCallback) {
                        if (properties == null) {
                            properties = ((PropertyCallback)callbacks[i]).getProperties();
                        }
                        if (properties == null) continue;
                        messageContext = (SOAPMessageContext)properties.get("com.ibm.wsspi.wssecurity.core.messageContext");
                        keyName = (String)properties.get(Constants.WSSECURITY_KEY_NAMEREF);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("KeyName is [" + keyName + "]."));
                        continue;
                    }
                    if (callbacks[i] instanceof BinaryTokenCallback || callbacks[i] instanceof XMLTokenConsumerCallback) continue;
                    throw new UnsupportedCallbackException(callbacks[i], "Unsupported callback");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Succeeded to get necessary information through the callbacks.");
                }
                tinfo = null;
                if (this._keyInformationList == null) {
                    throw new IOException(ConfigUtil.getMessage((String)"security.wssecurity.BSTokenCallbackHandler.s01"));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Configuration of the this callback handler found.");
                }
                it = this._keyInformationList.iterator();
                if (!"com.ibm.wsspi.wssecurity.token.standAlone".equals(keyName)) break block16;
                if (!it.hasNext()) break block17;
                KeyLocatorConfig.KeyInformationConfig ki = (KeyLocatorConfig.KeyInformationConfig)it.next();
                if (it.hasNext() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Multiple key information are found.  But since there is no way to select one of them, the first one is used.");
                }
                alias = ki.getAlias();
                break block17;
            }
            while (it.hasNext()) {
                KeyLocatorConfig.KeyInformationConfig ki = (KeyLocatorConfig.KeyInformationConfig)it.next();
                String kn = KeyInfo.X509Data.encodeDName((String)ki.getName());
                if (kn == null || kn.length() == 0) {
                    kn = ki.getName();
                }
                if (!kn.equals(keyName)) continue;
                alias = ki.getAlias();
                break;
            }
        }
        if (tc.isDebugEnabled()) {
            if (alias == null) {
                Tr.debug((TraceComponent)tc, (String)"Alias not found.");
            } else {
                Tr.debug((TraceComponent)tc, (String)("Alias is [" + alias + "]."));
            }
        }
        tinfo = new TokenInformation();
        tinfo._config = this._config;
        tinfo._messageContext = messageContext;
        tinfo._properties = properties;
        tinfo._alias = alias;
        tinfo._bsCallback = bsCallback;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("handle(Callback[] callbacks) returns TokenInformation[" + tinfo + "]"));
        }
        return tinfo;
    }

    IOException processError(TokenInformation tinfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processError(TokenInformation tinfo)");
        }
        IOException exception = null;
        String keyName = null;
        if (tinfo._properties != null && !tinfo._properties.isEmpty()) {
            keyName = (String)tinfo._properties.get(Constants.WSSECURITY_KEY_NAMEREF);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyName is [" + keyName + "]."));
        }
        if (keyName != null && keyName.length() != 0) {
            StringBuffer strBuf = new StringBuffer();
            if (this._keyInformationList != null) {
                Iterator it = this._keyInformationList.iterator();
                if ("com.ibm.wsspi.wssecurity.token.standAlone".equals(keyName)) {
                    if (it.hasNext()) {
                        KeyLocatorConfig.KeyInformationConfig ki = (KeyLocatorConfig.KeyInformationConfig)it.next();
                        strBuf.append(KeyInfo.X509Data.encodeDName((String)ki.getName()));
                    }
                } else {
                    while (it.hasNext()) {
                        KeyLocatorConfig.KeyInformationConfig ki = (KeyLocatorConfig.KeyInformationConfig)it.next();
                        strBuf.append(KeyInfo.X509Data.encodeDName((String)ki.getName()));
                        if (!it.hasNext()) continue;
                        strBuf.append(", ");
                    }
                }
                exception = new IOException(ConfigUtil.getMessage((String)"security.wssecurity.WSEC6730E", (String[])new String[]{keyName, strBuf.toString(), tinfo._alias}));
            } else {
                exception = new IOException(ConfigUtil.getMessage((String)"security.wssecurity.WSEC6730E", (String[])new String[]{keyName, "", tinfo._alias}));
            }
        } else {
            exception = new IOException(ConfigUtil.getMessage((String)"security.wssecurity.KeyStoreKeyLocator.generateIdentifier04", (String[])new String[]{tinfo._alias}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processError(TokenInformation tinfo)", (Object)exception);
        }
        return exception;
    }

    protected static class TokenInformation {
        protected CallbackHandlerConfig _config = null;
        protected SOAPMessageContext _messageContext = null;
        protected Map _properties = null;
        protected String _alias = null;
        protected X509BSCallback _bsCallback = null;

        protected TokenInformation() {
        }
    }
}

