/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.auth.callback;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.security.token.TokenHolder;
import java.util.List;
import javax.security.auth.callback.Callback;

public class WSTokenHolderCallback
implements Callback {
    private List _list;
    private String prompt;
    private boolean _requiresLogin = true;
    private static final TraceComponent tc = Tr.register(WSTokenHolderCallback.class, null, "com.ibm.ejs.resources.security");

    public WSTokenHolderCallback(String prompt) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSTokenHolderCallback(prompt = \"" + prompt + "\")");
        }
        this.prompt = prompt;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSTokenHolderCallback(prompt)");
        }
    }

    public WSTokenHolderCallback(String prompt, List list, boolean requiresLogin) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSTokenHolderCallback(prompt = \"" + prompt + "\", list, requiresLogin = \"" + requiresLogin + "\")");
        }
        this.prompt = prompt;
        this._list = list;
        this._requiresLogin = requiresLogin;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSTokenHolderCallback(prompt, list)");
        }
    }

    public void setTokenHolderList(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenHolderList(list)");
        }
        this._list = list;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTokenHolderList(list)");
        }
    }

    public List getTokenHolderList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenHolderList()");
            Tr.exit(tc, "getTokenHolderList()");
        }
        return this._list;
    }

    public void setRequiresLogin(boolean requiresLogin) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRequiresLogin(boolean)");
        }
        this._requiresLogin = requiresLogin;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRequiresLogin(boolean)");
        }
    }

    public boolean getRequiresLogin() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRequiresLogin()");
            Tr.exit(tc, "getRequiresLogin()");
        }
        this.analyzeTokenListForRequiredLogin();
        return this._requiresLogin;
    }

    public String getPrompt() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrompt()");
            Tr.exit(tc, "getPrompt() -> " + this.prompt);
        }
        return this.prompt;
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString()");
            Tr.debug(tc, "Number of tokens: " + (this._list == null ? 0 : this._list.size()));
            Tr.debug(tc, "requiresLogin: " + this._requiresLogin);
            Tr.exit(tc, "toString() -> " + this.getClass().getName());
        }
        return this.getClass().getName();
    }

    private void analyzeTokenListForRequiredLogin() {
        Tr.entry(tc, "analyzeTokenListForRequiredLogin()");
        if (this._list != null) {
            for (TokenHolder token : this._list) {
                if (!token.getName().equalsIgnoreCase("com.ibm.ws.security.token.AuthorizationTokenImpl")) continue;
                this._requiresLogin = false;
                Tr.exit(tc, "analyzeTokenListForRequiredLogin() -> false");
                return;
            }
        }
        Tr.exit(tc, "analyzeTokenListForRequiredLogin() -> true");
        this._requiresLogin = true;
    }
}

