/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.http.channel.values;

import com.ibm.wsspi.genericbnf.GenericKeys;
import com.ibm.wsspi.genericbnf.KeyMatcher;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemeValues
extends GenericKeys {
    private static int NEXT_ORDINAL = 0;
    private static final List<SchemeValues> allKeys = new ArrayList<SchemeValues>();
    private static final KeyMatcher myMatcher = new KeyMatcher(false);
    public static final SchemeValues UNDEF = new SchemeValues("Undefined");
    public static final SchemeValues HTTP = new SchemeValues("http");
    public static final SchemeValues HTTPS = new SchemeValues("https");
    public static final SchemeValues FTP = new SchemeValues("ftp");
    private boolean undefined = false;

    public SchemeValues(String name) {
        super(name, SchemeValues.nextOrdinal());
        allKeys.add(this);
        myMatcher.add(this);
    }

    private static synchronized int nextOrdinal() {
        return NEXT_ORDINAL++;
    }

    public static SchemeValues makeUndefinedValue(byte[] value) {
        return SchemeValues.find(value);
    }

    public boolean isUndefined() {
        return this.undefined;
    }

    public static List<SchemeValues> getAllKeys() {
        return allKeys;
    }

    public static SchemeValues getByOrdinal(int i) {
        return allKeys.get(i);
    }

    public static SchemeValues match(String name, int offset, int length) {
        if (null == name) {
            return null;
        }
        return (SchemeValues)myMatcher.match(name, offset, length);
    }

    public static SchemeValues match(byte[] name, int offset, int length) {
        if (null == name) {
            return null;
        }
        return (SchemeValues)myMatcher.match(name, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SchemeValues find(byte[] name, int offset, int length) {
        SchemeValues key = (SchemeValues)myMatcher.match(name, offset, length);
        if (null != key) return key;
        Class<SchemeValues> clazz = SchemeValues.class;
        synchronized (SchemeValues.class) {
            key = (SchemeValues)myMatcher.match(name, offset, length);
            if (null != key) return key;
            key = new SchemeValues(new String(name, offset, length));
            key.undefined = true;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SchemeValues find(String name) {
        SchemeValues key = (SchemeValues)myMatcher.match(name, 0, name.length());
        if (null != key) return key;
        Class<SchemeValues> clazz = SchemeValues.class;
        synchronized (SchemeValues.class) {
            key = (SchemeValues)myMatcher.match(name, 0, name.length());
            if (null != key) return key;
            key = new SchemeValues(name);
            key.undefined = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return key;
        }
    }

    public static SchemeValues find(byte[] name) {
        return SchemeValues.find(name, 0, name.length);
    }
}

