/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.sm.smf;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.Traceable;
import com.ibm.ws390.sm.smf.SmfJActivity;
import com.ibm.ws390.sm.smf.SmfProperty;
import com.ibm.ws390.sm.smf.SmfPropertyVector;
import com.ibm.ws390.sm.smf.SmfServletData;
import java.util.Enumeration;
import java.util.Vector;

public final class SmfWebContainerCookie
implements Traceable {
    private String m_webAppName = "";
    private int m_httpSessionCreateCount = 0;
    private int m_httpSessionFinalizeCount = 0;
    private int m_httpSessionInvalidateCount = 0;
    private int m_httpSessionInvalidateTime = 0;
    private int m_httpSessionLifeTime = 0;
    private int m_servletLoadCount = 0;
    private Vector m_servletDataVector = new Vector();
    private static TraceComponent m_tc = Tr.register("com.ibm.ws390.sm.smf.SmfWebContainerCookie", null, "com.ibm.ws390.sm.smf.SmfWebContainer");
    private Vector m_properties = new Vector(10);
    private boolean m_propertiesInSync = false;
    private int m_propertiesByteSize = 0;

    public SmfWebContainerCookie() {
    }

    protected SmfWebContainerCookie(String aWebAppName) {
        this();
        this.setWebAppName(aWebAppName);
    }

    private void addProperty(SmfProperty aProperty) {
        this.m_properties.addElement(aProperty);
        this.m_propertiesByteSize += aProperty.getByteSize();
    }

    protected boolean addTo(SmfPropertyVector aVector) {
        boolean result = true;
        this.resyncProperties();
        if (aVector.getRemainingByteArraySize() >= this.m_propertiesByteSize) {
            int size = this.m_properties.size();
            for (int i = 0; i < size; ++i) {
                aVector.addElement(this.m_properties.elementAt(i));
            }
            SmfServletData servletData = null;
            while (this.m_servletDataVector.size() > 0) {
                servletData = (SmfServletData)this.m_servletDataVector.elementAt(0);
                if (servletData.addTo(aVector)) {
                    this.m_servletDataVector.removeElementAt(0);
                    continue;
                }
                result = false;
                break;
            }
            this.reset();
            return result;
        }
        return false;
    }

    private SmfServletData findOrCreateServlet(String aServletName) {
        Enumeration vEnum = null;
        SmfServletData servletData = null;
        String matcher = aServletName.length() > 128 ? aServletName.substring(0, 128) : aServletName;
        vEnum = this.m_servletDataVector.elements();
        while (vEnum.hasMoreElements()) {
            servletData = (SmfServletData)vEnum.nextElement();
            if (!servletData.getName().equals(matcher)) continue;
            return servletData;
        }
        servletData = new SmfServletData(aServletName);
        this.m_servletDataVector.add(servletData);
        return servletData;
    }

    protected int getHttpSessionCreateCount() {
        return this.m_httpSessionCreateCount;
    }

    protected int getHttpSessionFinalizeCount() {
        return this.m_httpSessionFinalizeCount;
    }

    protected int getHttpSessionInvalidateCount() {
        return this.m_httpSessionInvalidateCount;
    }

    protected int getHttpSessionInvalidateTime() {
        return this.m_httpSessionInvalidateTime;
    }

    protected int getHttpSessionLifeTime() {
        return this.m_httpSessionLifeTime;
    }

    protected int getServletLoadCount() {
        return this.m_servletLoadCount;
    }

    protected long getServletCpuEndTime(String aServletName) {
        SmfServletData sd = this.findOrCreateServlet(aServletName);
        return sd.getCpuEndTime();
    }

    protected long getServletCpuStartTime(String aServletName) {
        SmfServletData sd = this.findOrCreateServlet(aServletName);
        return sd.getCpuStartTime();
    }

    protected String getWebAppName() {
        return this.m_webAppName;
    }

    protected void incrementHttpSessionCreateCount() {
        ++this.m_httpSessionCreateCount;
        this.m_propertiesInSync = false;
    }

    protected void incrementHttpSessionFinalizeCount() {
        ++this.m_httpSessionFinalizeCount;
        this.m_propertiesInSync = false;
    }

    protected void incrementHttpSessionInvalidateCount() {
        ++this.m_httpSessionInvalidateCount;
        this.m_propertiesInSync = false;
    }

    protected void print() {
        System.out.println(this.getWebAppName() + " cookie: print entered");
        System.out.println("  m_httpSessionCreateCount     " + this.m_httpSessionCreateCount);
        System.out.println("  m_httpSessionFinalizeCount   " + this.m_httpSessionFinalizeCount);
        System.out.println("  m_httpSessionInvalidateCount " + this.m_httpSessionInvalidateCount);
        System.out.println("  m_httpSessionInvalidateTime  " + this.m_httpSessionInvalidateTime);
        System.out.println("  m_httpSessionLifeTime        " + this.m_httpSessionLifeTime);
        System.out.println("  m_servletLoadCount           " + this.m_servletLoadCount);
        Enumeration vEnum = null;
        SmfServletData servletData = null;
        vEnum = this.m_servletDataVector.elements();
        while (vEnum.hasMoreElements()) {
            servletData = (SmfServletData)vEnum.nextElement();
            System.out.println(servletData.toString());
        }
    }

    protected void processServletError(String aWebAppName, String aServletName) {
        this.setWebAppName(aWebAppName);
        SmfServletData servletData = this.findOrCreateServlet(aServletName);
        if (servletData != null) {
            servletData.incrementErrorCount();
        } else {
            this.traceUnableToFindServlet("processServletError", aWebAppName, aServletName);
        }
    }

    protected void processServletLoaded(String aWebAppName, String aServletName, long aLoadedSince) {
        this.setWebAppName(aWebAppName);
        SmfServletData servletData = this.findOrCreateServlet(aServletName);
        if (servletData != null) {
            servletData.incrementLoadCount();
            servletData.setLoadedSince(aLoadedSince);
        } else {
            this.traceUnableToFindServlet("processServletLoaded", aWebAppName, aServletName);
        }
    }

    protected void processServletRequestEnds(String aWebAppName, String aServletName, long aLoadedSince, int aResponseElapsedTime) {
        this.setWebAppName(aWebAppName);
        SmfServletData servletData = this.findOrCreateServlet(aServletName);
        if (servletData != null) {
            servletData.setLoadedSince(aLoadedSince);
            servletData.setResponseTime(aResponseElapsedTime);
            servletData.calculateCpuTime(SmfJActivity.obtainTotalCpuTimeUsed());
        } else {
            this.traceUnableToFindServlet("processServletRequestEnds", aWebAppName, aServletName);
        }
    }

    protected void processServletRequestBegins(String aWebAppName, String aServletName) {
        this.setWebAppName(aWebAppName);
        SmfServletData servletData = this.findOrCreateServlet(aServletName);
        if (servletData != null) {
            servletData.setCpuStartTime(SmfJActivity.obtainTotalCpuTimeUsed());
        } else {
            this.traceUnableToFindServlet("processServletRequestBegins", aWebAppName, aServletName);
        }
    }

    private void reset() {
        this.m_httpSessionCreateCount = 0;
        this.m_httpSessionFinalizeCount = 0;
        this.m_httpSessionInvalidateCount = 0;
        this.m_httpSessionInvalidateTime = 0;
        this.m_httpSessionLifeTime = 0;
        this.m_servletLoadCount = 0;
        this.m_propertiesInSync = false;
        this.resyncProperties();
    }

    private void resyncProperties() {
        if (!this.m_propertiesInSync) {
            this.m_properties.clear();
            this.m_propertiesByteSize = 0;
            if (this.m_httpSessionCreateCount > 0) {
                this.addProperty(new SmfProperty(2, this.m_httpSessionCreateCount));
            }
            if (this.m_httpSessionFinalizeCount > 0) {
                this.addProperty(new SmfProperty(3, this.m_httpSessionFinalizeCount));
            }
            if (this.m_httpSessionInvalidateCount > 0) {
                this.addProperty(new SmfProperty(4, this.m_httpSessionInvalidateCount));
            }
            if (this.m_httpSessionInvalidateTime > 0) {
                this.addProperty(new SmfProperty(6, this.m_httpSessionInvalidateTime));
            }
            if (this.m_httpSessionLifeTime > 0) {
                this.addProperty(new SmfProperty(7, this.m_httpSessionLifeTime));
            }
            if (this.m_webAppName.length() > 0 && (this.m_servletLoadCount > 0 || this.m_servletDataVector.size() > 0)) {
                this.addProperty(new SmfProperty(13, this.m_webAppName, null));
                if (this.m_servletLoadCount > 0) {
                    this.addProperty(new SmfProperty(14, this.m_servletLoadCount));
                }
            }
            this.m_propertiesInSync = true;
        }
    }

    protected void setHttpSessionInvalidateTime(int aNewTime) {
        if (aNewTime >= 0) {
            this.m_httpSessionInvalidateTime = aNewTime;
            this.m_propertiesInSync = false;
        }
    }

    protected void setHttpSessionLifeTime(int aNewTime) {
        if (aNewTime >= 0) {
            this.m_httpSessionLifeTime = aNewTime;
            this.m_propertiesInSync = false;
        }
    }

    protected void setServletLoadCount(int aNewValue) {
        if (aNewValue >= 0) {
            this.m_servletLoadCount = aNewValue;
            this.m_propertiesInSync = false;
        }
    }

    protected void setWebAppName(String aName) {
        if (aName != null) {
            this.m_webAppName = aName.length() > 128 ? aName.substring(0, 128) : aName;
            this.m_propertiesInSync = false;
        }
    }

    public String toTraceString() {
        StringBuffer sb = new StringBuffer("SmfWebContainerCookie: ");
        sb.append("web app name: >").append(this.getWebAppName()).append("< ");
        sb.append("create/finalize/invalidate count: >").append(this.getHttpSessionCreateCount()).append("/").append(this.getHttpSessionFinalizeCount()).append("/").append(this.getHttpSessionInvalidateCount()).append("< ");
        sb.append("invalidate/life time: >").append(this.getHttpSessionInvalidateTime()).append("/").append(this.getHttpSessionLifeTime()).append("< ");
        return sb.toString();
    }

    private void traceUnableToFindServlet(String aMethodName, String aWebAppName, String aServletName) {
        if (m_tc.isEventEnabled()) {
            Object[] objs = new Object[]{aMethodName, aWebAppName, aServletName};
            StringBuffer sb = new StringBuffer("Method {0}");
            sb.append(" could not find or create SmfServletData object related to");
            sb.append(" web application {1} and servlet {2}.");
            Tr.event(m_tc, sb.toString(), objs);
        }
    }
}

