/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.sm.smf;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.ServletSessionsPerf;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.ws.pmi.server.PmiCallback;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.modules.ServletSessionsModule;
import com.ibm.ws390.sm.smf.SmfScheduledUpdate;
import com.ibm.ws390.sm.smf.SmfWebContainerDataCollector;
import com.ibm.ws390.sm.smf.SmfWebContainerDataCollectorFactory;
import com.ibm.ws390.sm.smf.SmfWebContainerDataCollectorIntervalManager;

public class SmfServletSessionsModule
implements SmfScheduledUpdate,
ServletSessionsPerf {
    private static SmfWebContainerDataCollectorIntervalManager _intervalManager = SmfWebContainerDataCollectorIntervalManager.getInstance();
    private static SmfWebContainerDataCollector _collector = SmfWebContainerDataCollectorFactory.getInstance();
    private int _activeSessionCount = 0;
    private int _liveSessionCount = 0;
    private long _totalInvalidationTime = 0L;
    private long _totalLifeTime = 0L;
    private int _numInvalidatedSessions = 0;
    private int _numFinalizedSessions = 0;
    private ServletSessionsPerf m_ServletSessionsModule = null;
    private static TraceComponent _tc = Tr.register(SmfServletSessionsModule.class.getName(), "SMF Servlet Sessions Module");

    public SmfServletSessionsModule(String webappName, PmiCallback callback) {
        if (!PmiRegistry.isDisabled()) {
            this.m_ServletSessionsModule = new ServletSessionsModule(webappName, callback);
        }
        _intervalManager.registerModule(this);
    }

    public void sessionCreated() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.sessionCreated();
            }
            ++this._liveSessionCount;
            _collector.httpSessionCreated();
        }
        catch (Throwable t) {
            t.printStackTrace();
            Tr.error(_tc, "sessionCreated error", t);
        }
    }

    public void sessionActivated() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.sessionActivated();
            }
            ++this._activeSessionCount;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void sessionActivated(long timeSinceLastActivated) {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.sessionActivated(timeSinceLastActivated);
            }
            ++this._activeSessionCount;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void sessionInactivated() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.sessionInactivated();
            }
            --this._activeSessionCount;
            if (this._activeSessionCount < 0) {
                this._activeSessionCount = 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void sessionInvalidated(long creationTime) {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.sessionInvalidated(creationTime);
            }
            ++this._numInvalidatedSessions;
            long lifeTime = System.currentTimeMillis() - creationTime;
            this._totalLifeTime += lifeTime;
            --this._liveSessionCount;
        }
        catch (Throwable t) {
            t.printStackTrace();
            Tr.error(_tc, "sessionInvalidated error", t);
        }
    }

    public synchronized void sessionFinalized(long invalidationTime) {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.sessionFinalized(invalidationTime);
            }
            ++this._numFinalizedSessions;
            long timeToFinalize = System.currentTimeMillis() - invalidationTime;
            this._totalInvalidationTime += timeToFinalize;
        }
        catch (Throwable t) {
            t.printStackTrace();
            Tr.error(_tc, "sessionFinalized error", t);
        }
    }

    public void noRoomForNewSession() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.noRoomForNewSession();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void discardCache() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.discardCache();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void readExternal(long timetaken, long sizeRead) {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.readExternal(timetaken, sizeRead);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public void writeExternal(long timeTaken, long writeSize) {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.writeExternal(timeTaken, writeSize);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public void affinityBreak() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.affinityBreak();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void invalidatedViaTimeout() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.invalidatedViaTimeout();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void attempToActiveNonExistSession() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.attempToActiveNonExistSession();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void sessionAdded() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.sessionAdded();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void sessionRemoved() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.sessionRemoved();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void unregister() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.unregister();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void flushScheduledData() {
        try {
            int i;
            _collector.activeSessionCount(this._activeSessionCount);
            _collector.liveSessionCount(this._liveSessionCount);
            if (this._numFinalizedSessions > 0) {
                long averageInvalidationTime = this._totalInvalidationTime / (long)this._numFinalizedSessions;
                for (i = 0; i < this._numFinalizedSessions; ++i) {
                    _collector.httpSessionFinalized();
                    _collector.httpSessionInvalidateTime((int)averageInvalidationTime);
                }
            }
            this._numFinalizedSessions = 0;
            this._totalInvalidationTime = 0L;
            if (this._numInvalidatedSessions > 0) {
                long averageLifeTime = this._totalLifeTime / (long)this._numInvalidatedSessions;
                for (i = 0; i < this._numInvalidatedSessions; ++i) {
                    _collector.httpSessionInvalidated();
                    _collector.httpSessionLifeTime((int)averageLifeTime);
                }
            }
            this._numInvalidatedSessions = 0;
            this._totalLifeTime = 0L;
        }
        catch (Throwable t) {
            t.printStackTrace();
            Tr.error(_tc, "flushScheduledData error", t);
        }
    }

    public PmiModule getPmiModule() {
        return (PmiModule)((Object)this.m_ServletSessionsModule);
    }
}

