/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.sm.smf;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class SmfRequestTracker {
    static TraceComponent tc = Tr.register(SmfRequestTracker.class, null, "com.ibm.ws390.sm.smf.Smf120St9");
    private static final int CPU_USAGE_FIXED_SIZE_VARS_TOTAL_LENGTH = 36;
    private static final int CPU_USAGE_VERSION = 1;
    private static final byte[] FOUR_NULL_BYTES = new byte[]{0, 0, 0, 0};
    private SmfRequestTracker _parent = null;
    private String _methodName = null;
    private String _amcOrWebAppName = null;
    private long _beginCpTime = 0L;
    private long _endCpTime = 0L;
    private long _methodCpTime = 0L;
    private long _beginTime = 0L;
    private long _endTime = 0L;
    private long _elapsedTime = 0L;
    private int _type = 0;
    private int _invocationCount = 1;

    public SmfRequestTracker(ArrayList smfRequestTrackers, String methodName, String amcOrWebAppName, long beginCpTime, int type) {
        this._amcOrWebAppName = amcOrWebAppName;
        this._methodName = methodName;
        this._beginCpTime = beginCpTime;
        this._beginTime = System.currentTimeMillis();
        this._type = type;
        this._parent = SmfRequestTracker.findCurrentParent(smfRequestTrackers);
        smfRequestTrackers.add(this);
    }

    private SmfRequestTracker getParent() {
        return this._parent;
    }

    private String getAmcOrWebAppName() {
        return this._amcOrWebAppName;
    }

    private String getMethodName() {
        return this._methodName;
    }

    private long getBeginTime() {
        return this._beginTime;
    }

    private long getMethodCpTime() {
        return this._methodCpTime;
    }

    private long getElapsedTime() {
        return this._elapsedTime;
    }

    private long getEndCpTime() {
        return this._endCpTime;
    }

    private int getType() {
        return this._type;
    }

    private int getInvocationCount() {
        return this._invocationCount;
    }

    private void setMethodCpTime(long methodCpTime) {
        this._methodCpTime = methodCpTime;
    }

    public void setEndCpTime(long endCpTime) {
        this._endCpTime = endCpTime;
        this._methodCpTime = endCpTime - this._beginCpTime;
    }

    public void setEndTime() {
        this._endTime = System.currentTimeMillis();
        this._elapsedTime = this._endTime - this._beginTime;
    }

    private void setElapsedTime(long elapsedTime) {
        this._elapsedTime = elapsedTime;
    }

    private void addElapsedTime(long adjustment) {
        this._elapsedTime += adjustment;
    }

    private void addMethodCpTime(long adjustment) {
        this._methodCpTime += adjustment;
    }

    private boolean isStillExecuting() {
        return this._endTime == 0L;
    }

    private void incrementInvocationCount() {
        ++this._invocationCount;
    }

    private static SmfRequestTracker findCurrentParent(ArrayList smfRequestTrackers) {
        SmfRequestTracker parent = null;
        if (smfRequestTrackers != null) {
            for (int i = smfRequestTrackers.size() - 1; i > -1; --i) {
                if (!((SmfRequestTracker)smfRequestTrackers.get(i)).isStillExecuting()) continue;
                parent = (SmfRequestTracker)smfRequestTrackers.get(i);
                break;
            }
        }
        return parent;
    }

    public static byte[] computeTotals(ArrayList smfRequestTrackers) {
        int i;
        int reqTrackersSize = smfRequestTrackers.size();
        HashMap<String, SmfRequestTracker> hm = new HashMap<String, SmfRequestTracker>();
        for (i = reqTrackersSize - 1; i > 0; --i) {
            SmfRequestTracker child = (SmfRequestTracker)smfRequestTrackers.get(i);
            for (SmfRequestTracker parent = child.getParent(); parent != null; parent = parent.getParent()) {
                parent.setMethodCpTime(parent.getMethodCpTime() - child.getMethodCpTime());
                parent.setElapsedTime(parent.getElapsedTime() - child.getElapsedTime());
            }
        }
        for (i = 0; i < reqTrackersSize; ++i) {
            SmfRequestTracker curTracker = (SmfRequestTracker)smfRequestTrackers.get(i);
            String key = curTracker.getMethodName().concat(curTracker._amcOrWebAppName);
            if (hm.containsKey(key)) {
                SmfRequestTracker tmpSmfReqTracker = (SmfRequestTracker)hm.get(key);
                tmpSmfReqTracker.addMethodCpTime(curTracker.getMethodCpTime());
                tmpSmfReqTracker.addElapsedTime(curTracker.getElapsedTime());
                tmpSmfReqTracker.incrementInvocationCount();
                hm.put(key, tmpSmfReqTracker);
                continue;
            }
            hm.put(key, curTracker);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(FOUR_NULL_BYTES);
            Iterator iter = hm.entrySet().iterator();
            int i2 = 0;
            while (iter.hasNext()) {
                Map.Entry nextEntry = iter.next();
                SmfRequestTracker tmpSmfReqTracker = (SmfRequestTracker)nextEntry.getValue();
                int type = tmpSmfReqTracker.getType();
                long methodCpTime = tmpSmfReqTracker.getMethodCpTime();
                long elapsedTime = tmpSmfReqTracker.getElapsedTime();
                int invocationCount = tmpSmfReqTracker.getInvocationCount();
                String str1 = tmpSmfReqTracker.getAmcOrWebAppName();
                String str2 = tmpSmfReqTracker.getMethodName();
                int byteBufferSize = 36 + str1.length() + str2.length();
                ByteBuffer bb = ByteBuffer.allocate(byteBufferSize);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Writing CPU Usage section to ByteBuffer\nVersion         : 1\nType            : " + type + "\nMethod CP Time  : " + methodCpTime + "\nElapsed Time    : " + elapsedTime + "\nInvocation Count: " + invocationCount + "\nString 1 Length : " + str1.length() + "\nString 1        : " + str1 + "\nString 2 Length : " + str2.length() + "\nString 2        : " + str2);
                }
                bb.putInt(1);
                bb.putInt(type);
                bb.putLong(methodCpTime);
                bb.putLong(elapsedTime);
                bb.putInt(invocationCount);
                bb.putInt(str1.length());
                bb.put(str1.getBytes());
                bb.putInt(str2.length());
                bb.put(str2.getBytes());
                if (bb.hasArray()) {
                    baos.write(bb.array());
                    bb.clear();
                }
                ++i2;
            }
        }
        catch (IOException ioe) {
            Tr.error(tc, "IOException while writing SMF120-9 CPU Usage Data object: " + ioe);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "computeTotals returning: " + baos.toString());
        }
        return baos.toByteArray();
    }

    public String toString() {
        String str = null;
        str = this._parent == null ? "Parent is NULL\n" : "Parent is not NULL\n";
        str = str + "Version         : 1\nType            : " + this._type + "\nBegin CP Time   : " + this._beginCpTime + "\nEnd CP Time     : " + this._endCpTime + "\nMethod CP Time  : " + this._methodCpTime + "\nBegin Time      : " + this._beginTime + "\nEnd Time        : " + this._endTime + "\nElapsed Time    : " + this._elapsedTime + "\nInvocation Count: " + this._invocationCount + "\nString 1 Length : " + this._amcOrWebAppName.length() + "\nAMC/WebApp Name : " + this._amcOrWebAppName + "\nString 2 Length : " + this._methodName.length() + "\nMethod Name     : " + this._methodName;
        return str;
    }
}

