/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.wsdl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.wsdl.JaxWSCatalogAccessor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseWSDLLocator
implements Constants {
    private static TraceComponent _tc = Tr.register(BaseWSDLLocator.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    protected String baseURI;
    protected String lastestImportURI;
    protected InputStream baseInputStream;
    protected JaxWSCatalogAccessor catalogAccessor;
    private List<String> resolvedImportLocations = new LinkedList<String>();
    private static final char WSDL_PATH_SEPERATOR_CHAR = '/';
    private static final String WSDL_PATH_SEPERATOR = new Character('/').toString();

    protected abstract InputStream getInputStream(String var1) throws IOException;

    public InputSource getBaseInputSource() {
        return new InputSource(this.baseInputStream);
    }

    public InputSource getImportInputSource(String parentLocation, String relativeLocation) {
        InputStream is;
        Object inputSource;
        block21: {
            URL absoluteURL;
            block20: {
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "getImportInputSource", new Object[]{parentLocation, relativeLocation, this});
                }
                inputSource = null;
                is = null;
                absoluteURL = null;
                try {
                    relativeLocation = this.catalogAccessor != null ? this.catalogAccessor.resolveLocation(relativeLocation) : relativeLocation;
                }
                catch (Throwable t) {
                    if (!_tc.isDebugEnabled()) break block20;
                    Tr.debug(_tc, "The wsdlLocation " + relativeLocation + " was not resolved via " + "the JAX-WS catalog because of the following error: " + t.toString() + ". Normal resolution will continue.");
                }
            }
            try {
                if (this.isAbsoluteImport(relativeLocation)) {
                    try {
                        absoluteURL = new URL(relativeLocation);
                        is = absoluteURL.openStream();
                        this.lastestImportURI = absoluteURL.toExternalForm();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (is == null) {
                        try {
                            URI fileURI = new URI(relativeLocation);
                            absoluteURL = fileURI.toURL();
                            is = absoluteURL.openStream();
                            this.lastestImportURI = absoluteURL.toExternalForm();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (is == null) {
                        try {
                            File file = new File(relativeLocation);
                            absoluteURL = file.toURL();
                            is = absoluteURL.openStream();
                            this.lastestImportURI = absoluteURL.toExternalForm();
                        }
                        catch (Throwable t) {}
                    }
                    break block21;
                }
                is = this.getInputStream(relativeLocation);
                if (is == null) {
                    String importPath = this.normalizePath(parentLocation, relativeLocation);
                    importPath = this.catalogAccessor != null ? this.catalogAccessor.resolveLocation(importPath) : importPath;
                    is = this.getInputStream(importPath);
                    this.lastestImportURI = importPath;
                } else {
                    this.lastestImportURI = relativeLocation;
                }
                if (!this.resolvedImportLocations.contains(this.lastestImportURI)) {
                    this.resolvedImportLocations.add(this.lastestImportURI);
                }
            }
            catch (IOException ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.wsdl.BaseWSDLLocator.getImportInputSource", "123", this);
                Object[] inserts = new Object[]{relativeLocation, ex};
                String msg = NLSProvider.getNLS().getFormattedMessage("resolveWsdlLocFail00", inserts, "Error occurred while attempting to resolve the WSDL file {0}: {1}");
                Tr.error(_tc, "resolveWsdlLocFail00", inserts);
                throw new RuntimeException(msg);
            }
        }
        if (is == null) {
            Object[] inserts = new Object[]{relativeLocation};
            String msg = NLSProvider.getNLS().getFormattedMessage("fileNotFound00", inserts, "File {0} could not be found.");
            throw new RuntimeException(msg);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Loaded file: " + relativeLocation);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getImportInputSource", inputSource);
        }
        return new InputSource(is);
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public String getLatestImportURI() {
        return this.lastestImportURI;
    }

    protected String convertURI(String rawURI) {
        int idx = rawURI.lastIndexOf(47);
        if (idx > 0) {
            rawURI = rawURI.substring(0, idx + 1);
            return rawURI;
        }
        idx = rawURI.lastIndexOf(92);
        if (idx > 0) {
            rawURI = rawURI.substring(0, idx + 1);
            return rawURI;
        }
        return "";
    }

    protected boolean isAbsoluteImport(String uri) {
        boolean absolute = false;
        if (uri != null) {
            if (uri.indexOf(":/") != -1) {
                absolute = true;
            } else if (uri.indexOf(":\\") != -1) {
                absolute = true;
            }
        }
        return absolute;
    }

    protected String normalizePath(String parentLocation, String relativeLocation) {
        String pathFromRoot;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "normalizePath");
        }
        if ((pathFromRoot = this.convertURI(parentLocation)) == null || "".equals(pathFromRoot)) {
            return relativeLocation;
        }
        StringBuffer pathToRelativeLocation = new StringBuffer(pathFromRoot);
        StringTokenizer tokenizedRelativeLocation = new StringTokenizer(relativeLocation, WSDL_PATH_SEPERATOR);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "pathFromRoot = " + pathFromRoot);
            Tr.debug(_tc, "relativeLocation = " + relativeLocation);
        }
        String previousPath = null;
        while (tokenizedRelativeLocation.hasMoreTokens()) {
            String nextToken = tokenizedRelativeLocation.nextToken();
            if (nextToken.equals("..")) {
                int charToDelete = pathToRelativeLocation.length() - 1;
                if (pathToRelativeLocation.charAt(charToDelete) == '/' || pathToRelativeLocation.charAt(charToDelete) == '\\') {
                    pathToRelativeLocation.deleteCharAt(charToDelete--);
                }
                while (charToDelete > -1 && pathToRelativeLocation.charAt(charToDelete) != '/' && pathToRelativeLocation.charAt(charToDelete) != '\\') {
                    pathToRelativeLocation.deleteCharAt(charToDelete);
                    --charToDelete;
                }
            } else if (!nextToken.equals(".")) {
                if (pathToRelativeLocation.indexOf(String.valueOf('/')) != -1 && pathToRelativeLocation.charAt(pathToRelativeLocation.length() - 1) != '/') {
                    pathToRelativeLocation.append('/');
                } else if (pathToRelativeLocation.indexOf("\\") != -1 && pathToRelativeLocation.charAt(pathToRelativeLocation.length() - 1) != '\\') {
                    pathToRelativeLocation.append('\\');
                }
                if ("".equals(previousPath)) {
                    nextToken = '/' + nextToken;
                }
                pathToRelativeLocation.append(nextToken);
            }
            previousPath = pathToRelativeLocation.toString();
        }
        String resultingPath = pathToRelativeLocation.toString();
        if (resultingPath != null && resultingPath.length() > 0 && resultingPath.startsWith(String.valueOf('/'))) {
            resultingPath = resultingPath.substring(1, resultingPath.length());
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Built path = " + resultingPath);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "normalizePath");
        }
        return resultingPath;
    }

    public List<String> getResolvedImportLocations() {
        return this.resolvedImportLocations;
    }
}

