/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ws.websvcs.desc.DBUtils;
import com.ibm.ws.websvcs.desc.ServiceRefInfoImpl;
import com.ibm.ws.websvcs.desc.WSClientEndpointDescriptorDBC;
import com.ibm.wsspi.websvcs.desc.ServiceRefInfo;
import com.ibm.wsspi.websvcs.desc.WSClientEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientServiceDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSClientServiceDescriptorDBC
implements WSClientServiceDescriptor {
    private List<WSClientEndpointDescriptor> endpointList;
    private DescriptionBuilderComposite dbc;
    private QName serviceQName;
    private Map<String, DescriptionBuilderComposite> dbcMap;
    private boolean qNameSet;
    private boolean endpointsBuilt;
    private ServiceRefInfo srInfo;

    WSClientServiceDescriptorDBC(DescriptionBuilderComposite dbc, Map<String, DescriptionBuilderComposite> dbcMap) {
        this.dbc = dbc;
        this.qNameSet = false;
        this.dbcMap = dbcMap;
        this.endpointList = new ArrayList<WSClientEndpointDescriptor>();
        this.endpointsBuilt = false;
        this.setQName(dbc.getWebServiceClientAnnot().name(), dbc.getWebServiceClientAnnot().targetNamespace());
        this.srInfo = new ServiceRefInfoImpl(dbc.getClassName(), null);
    }

    @Override
    public Iterator getEndpoints() {
        this.buildEndpoints();
        return this.endpointList.iterator();
    }

    @Override
    public QName getQName() {
        if (!this.qNameSet) {
            this.buildEndpoints();
        }
        return this.serviceQName;
    }

    private void setQName(String localName, String tns) {
        if (localName != null && tns != null) {
            this.serviceQName = new QName(tns, localName);
            this.qNameSet = true;
        }
    }

    private void buildEndpoints() {
        if (!this.endpointsBuilt) {
            List mdcList = this.dbc.getMethodDescriptionsList();
            if (mdcList != null) {
                for (MethodDescriptionComposite mdc : mdcList) {
                    String returnType = mdc.getReturnType();
                    DescriptionBuilderComposite seiDBC = this.dbcMap.get(returnType);
                    if (seiDBC == null || seiDBC.getWebServiceAnnot() == null || !seiDBC.isInterface()) continue;
                    String portName = mdc.getWebEndpointAnnot() != null ? mdc.getWebEndpointAnnot().name() : null;
                    WSClientEndpointDescriptorDBC clientDesc = new WSClientEndpointDescriptorDBC(seiDBC, portName);
                    this.endpointList.add(clientDesc);
                    if (this.qNameSet) continue;
                    this.setQName(seiDBC.getWebServiceAnnot().serviceName(), seiDBC.getWebServiceAnnot().targetNamespace());
                }
            }
            this.endpointsBuilt = true;
        }
    }

    @Override
    public WSClientType getClientType() {
        return WSClientType.JAX_WS;
    }

    @Override
    public boolean isServiceRef() {
        return false;
    }

    @Override
    public ServiceRefInfo getServiceRefInfo() {
        return this.srInfo;
    }

    public String toString() {
        return DBUtils.printDBObject(this);
    }
}

