/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ws.websvcs.desc.DBUtils;
import com.ibm.ws.websvcs.desc.WSClientOperationDescriptorImpl;
import com.ibm.wsspi.websvcs.desc.WSClientEndpointDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;

public class WSClientEndpointDescriptorImpl
implements WSClientEndpointDescriptor {
    private Port port;
    private ArrayList clientOperations;
    private boolean clientOperationsBuilt;

    WSClientEndpointDescriptorImpl(Port port) {
        this.port = port;
        this.clientOperations = new ArrayList();
        this.clientOperationsBuilt = false;
    }

    public String getName() {
        return this.port.getName();
    }

    public QName getBindingQName() {
        return this.port.getBinding() != null ? this.port.getBinding().getQName() : null;
    }

    public QName getPortTypeQName() {
        QName ptQName = null;
        if (this.port.getBinding() != null && this.port.getBinding().getPortType() != null) {
            ptQName = this.port.getBinding().getPortType().getQName();
        }
        return ptQName;
    }

    public Iterator getOperations() {
        this.buildOperations();
        return this.clientOperations.iterator();
    }

    private void buildOperations() {
        if (!this.clientOperationsBuilt) {
            List opList;
            PortType portType;
            Binding binding = this.port.getBinding();
            if (binding != null && (portType = binding.getPortType()) != null && !(opList = portType.getOperations()).isEmpty()) {
                for (Operation operation : opList) {
                    WSClientOperationDescriptorImpl opDesc = new WSClientOperationDescriptorImpl(operation.getName());
                    this.clientOperations.add(opDesc);
                }
            }
            this.clientOperationsBuilt = true;
        }
    }

    public String toString() {
        return DBUtils.printDBObject(this);
    }
}

