/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.desc.DBUtils;
import com.ibm.ws.websvcs.desc.MDQEndpointDescriptorImpl;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.websvcs.desc.WSEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSModuleDescriptor;
import com.ibm.wsspi.websvcs.desc.WSServiceDescriptor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;

public class MDQServiceDescriptorImpl
implements WSServiceDescriptor {
    private WSModuleDescriptor parent;
    private ServiceDescription serviceDescription;
    private List<WSEndpointDescriptor> endpointDescriptors;
    private boolean endpointsBuilt;
    private static final TraceComponent _tc = Tr.register(MDQServiceDescriptorImpl.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public MDQServiceDescriptorImpl(WSModuleDescriptor parent, ServiceDescription serviceDescription) {
        this.parent = parent;
        this.serviceDescription = serviceDescription;
        this.endpointsBuilt = false;
        this.endpointDescriptors = new ArrayList<WSEndpointDescriptor>();
    }

    public boolean deployedWithWSDL() {
        if (this.serviceDescription instanceof ServiceDescriptionWSDL) {
            ServiceDescriptionWSDL sdWSDL = (ServiceDescriptionWSDL)this.serviceDescription;
            return sdWSDL.getWSDLDefinition() != null;
        }
        return false;
    }

    public Iterator getEndpoints() {
        this.buildEndpoints();
        return this.endpointDescriptors.iterator();
    }

    public String getName() {
        return this.serviceDescription.getServiceQName() != null ? this.serviceDescription.getServiceQName().getLocalPart() : null;
    }

    public WSModuleDescriptor getParent() {
        return this.parent;
    }

    public QName getQName() {
        return this.serviceDescription.getServiceQName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition getWSDLDefinition() {
        block14: {
            block16: {
                ServiceDescriptionWSDL sdWSDL;
                block15: {
                    Definition definition;
                    if (_tc.isEntryEnabled()) {
                        Tr.entry(_tc, "getWSDLDefinition");
                    }
                    try {
                        if (!(this.serviceDescription instanceof ServiceDescriptionWSDL)) break block14;
                        sdWSDL = (ServiceDescriptionWSDL)this.serviceDescription;
                        if (sdWSDL.getWSDLDefinition() == null) break block15;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "getWSDLDefinition returning definition");
                        }
                        definition = sdWSDL.getWSDLDefinition();
                        Object var4_6 = null;
                    }
                    catch (Throwable throwable) {
                        block17: {
                            Object var4_10 = null;
                            if (!_tc.isEntryEnabled()) break block17;
                            Tr.exit(_tc, "getWSDLDefinition");
                        }
                        throw throwable;
                    }
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getWSDLDefinition");
                    }
                    return definition;
                }
                if (sdWSDL.getGeneratedWsdlWrapper() == null) break block16;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getWSDLDefinition returning generated definition");
                }
                Definition definition = sdWSDL.getGeneratedWsdlWrapper().getDefinition();
                Object var4_7 = null;
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getWSDLDefinition");
                }
                return definition;
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getWSDLDefinition returning null");
            }
            Definition definition = null;
            Object var4_8 = null;
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getWSDLDefinition");
            }
            return definition;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getWSDLDefinition not instance of ServiceDescriptionWSDL");
        }
        Definition definition = null;
        Object var4_9 = null;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getWSDLDefinition");
        }
        return definition;
    }

    public String getWSDLLocationBaseName() {
        if (this.serviceDescription instanceof ServiceDescriptionWSDL) {
            ServiceDescriptionWSDL sdWSDL = (ServiceDescriptionWSDL)this.serviceDescription;
            if (sdWSDL.getWSDLLocation() != null) {
                String path = sdWSDL.getWSDLLocation();
                if (path.indexOf("/") != -1) {
                    path = path.substring(path.lastIndexOf("/"), path.length());
                    return path;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public URI getWSDLLocationURI() {
        if (this.serviceDescription instanceof ServiceDescriptionWSDL) {
            ServiceDescriptionWSDL sdWSDL = (ServiceDescriptionWSDL)this.serviceDescription;
            if (sdWSDL.getWSDLLocation() != null) {
                try {
                    return new URI(sdWSDL.getWSDLLocation());
                }
                catch (Throwable t) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Could not get WSDL location URI due to the following error: " + t.toString());
                    }
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public boolean isJAXRPCService() {
        return false;
    }

    public boolean isJAXWSService() {
        return true;
    }

    private void buildEndpoints() {
        if (!this.endpointsBuilt) {
            for (EndpointDescription ed : this.serviceDescription.getEndpointDescriptions_AsCollection()) {
                if (_tc.isDebugEnabled()) {
                    String serviceImplClass = ed.getAxisService() != null ? Axis2Utils.getServiceImplClass((AxisService)ed.getAxisService()) : null;
                    Tr.debug(_tc, "Building MDQEndpointDescriptorImpl for port: " + ed.getPortQName() + " service impl class: " + serviceImplClass);
                }
                MDQEndpointDescriptorImpl endpointDescriptor = new MDQEndpointDescriptorImpl(this, ed);
                this.endpointDescriptors.add(endpointDescriptor);
            }
            this.endpointsBuilt = true;
        }
    }

    public String toString() {
        return DBUtils.printDBObject(this);
    }
}

