/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.desc.DBUtils;
import com.ibm.ws.websvcs.desc.JAXWSOperationDescriptorImpl;
import com.ibm.ws.websvcs.desc.ServiceBeanInfoImpl;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.websvcs.desc.ServiceBeanInfo;
import com.ibm.wsspi.websvcs.desc.WSEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSServiceDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisService;

public class JAXWSEndpointDescriptorImpl
implements WSEndpointDescriptor {
    private Port port;
    private WSServiceDescriptor parent;
    private ArrayList opList;
    private boolean opsBuilt;
    private String urlPattern;
    private Definition definition;
    private QName serviceQName;
    private String portComponentName;
    private ServiceBeanInfo beanInfo;
    private static final TraceComponent _tc = Tr.register(JAXWSEndpointDescriptorImpl.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    JAXWSEndpointDescriptorImpl(Port p, AxisService service, WSServiceDescriptor sDesc) {
        this.port = p;
        AxisService axisService = service;
        this.parent = sDesc;
        this.opsBuilt = false;
        this.opList = new ArrayList();
        this.setServiceQName(axisService);
        this.setDefinition(axisService);
        this.setURLPattern(axisService);
        this.portComponentName = Axis2Utils.getPortComponentName((AxisService)axisService);
        this.buildServiceBeanInfo(axisService);
    }

    public String getName() {
        return this.port.getName();
    }

    public QName getBindingQName() {
        return this.port.getBinding() != null ? this.port.getBinding().getQName() : null;
    }

    public QName getPortTypeQName() {
        QName ptQName = null;
        if (this.port.getBinding() != null && this.port.getBinding().getPortType() != null) {
            ptQName = this.port.getBinding().getPortType().getQName();
        }
        return ptQName;
    }

    public void setDefinition(AxisService axisService) {
        this.definition = Axis2Utils.getWSDLDefinition((AxisService)axisService);
    }

    public QName getQName() {
        QName qName = new QName(this.definition.getTargetNamespace(), this.getName());
        return qName;
    }

    public void setServiceQName(AxisService axisService) {
        this.serviceQName = Axis2Utils.getServiceQName((AxisService)axisService);
    }

    public QName getServiceQName() {
        return this.serviceQName;
    }

    public Iterator getOperations() {
        this.buildOperations();
        return this.opList.iterator();
    }

    public void setParent(WSServiceDescriptor serviceDesc) {
        this.parent = serviceDesc;
    }

    public WSServiceDescriptor getParent() {
        return this.parent;
    }

    public void setURLPattern(AxisService axisService) {
        this.urlPattern = Axis2Utils.getURLPattern((AxisService)axisService);
    }

    public String getURLPattern() {
        return this.urlPattern;
    }

    public String getPortComponentName() {
        return this.portComponentName;
    }

    public ServiceBeanInfo getServiceBeanInfo() {
        return this.beanInfo;
    }

    private void buildServiceBeanInfo(AxisService axisService) {
        String linkValue = null;
        String implClassName = Axis2Utils.getServiceImplClass((AxisService)axisService);
        linkValue = Axis2Utils.getLinkValue((AxisService)axisService);
        ServiceBeanInfo.BeanType beanType = Axis2Utils.getParameterValue((AxisDescription)axisService, (String)"EJB_J2EE_NAME") != null ? ServiceBeanInfo.BeanType.EJB : ServiceBeanInfo.BeanType.WEB;
        this.beanInfo = new ServiceBeanInfoImpl(implClassName, linkValue, beanType);
    }

    private void buildOperations() {
        if (!this.opsBuilt) {
            Binding binding = this.port.getBinding();
            PortType portType = binding.getPortType();
            List list = portType.getOperations();
            for (Operation op : list) {
                JAXWSOperationDescriptorImpl opDesc = new JAXWSOperationDescriptorImpl(op);
                this.opList.add(opDesc);
            }
            this.opsBuilt = true;
        }
    }

    public String toString() {
        return DBUtils.printDBObject(this);
    }
}

