/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.engine.utils.ModuleUtils;
import com.ibm.ws.websvcs.desc.DBUtils;
import com.ibm.ws.websvcs.desc.JAXRPCOperationDescriptorImpl;
import com.ibm.ws.websvcs.desc.ServiceBeanInfoImpl;
import com.ibm.ws.websvcs.desc.WSModuleDescriptorImpl;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.websvcs.desc.ServiceBeanInfo;
import com.ibm.wsspi.websvcs.desc.WSEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSOperationDescriptor;
import com.ibm.wsspi.websvcs.desc.WSServiceDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;

public class JAXRPCEndpointDescriptorImpl
implements WSEndpointDescriptor {
    private static final TraceComponent _tc = Tr.register(JAXRPCEndpointDescriptorImpl.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private WSServiceDescriptor parent;
    private Port wsdlPort;
    private List<WSOperationDescriptor> opDescList;
    private QName portQName;
    private String portComponentName;
    private boolean operationsBuilt;
    private ServiceBeanInfo beanInfo;
    private String urlPattern;

    public JAXRPCEndpointDescriptorImpl(Port wsdlPort, PortComponent portComponent, WSServiceDescriptor parent) {
        this.wsdlPort = wsdlPort;
        this.parent = parent;
        this.portQName = new QName(portComponent.getWsdlPort().getNamespaceURI(), wsdlPort.getName());
        this.operationsBuilt = false;
        this.portComponentName = portComponent.getPortComponentName();
        this.buildServiceBeanInfo(portComponent);
        this.setURLPattern(portComponent);
        this.opDescList = new ArrayList<WSOperationDescriptor>();
        this.buildOperations();
    }

    public String getName() {
        return this.portQName.getLocalPart();
    }

    public QName getBindingQName() {
        return this.wsdlPort.getBinding() != null ? this.wsdlPort.getBinding().getQName() : null;
    }

    public QName getPortTypeQName() {
        QName ptQName = null;
        if (this.wsdlPort.getBinding() != null && this.wsdlPort.getBinding().getPortType() != null) {
            ptQName = this.wsdlPort.getBinding().getPortType().getQName();
        }
        return ptQName;
    }

    public Iterator getOperations() {
        return this.opDescList.iterator();
    }

    private void buildOperations() {
        Binding binding = this.wsdlPort.getBinding();
        if (binding != null) {
            PortType portType;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found binding for port: " + this.wsdlPort.getName());
            }
            if ((portType = binding.getPortType()) != null && !portType.getOperations().isEmpty()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found portType and operations for binding: " + binding.getQName().toString());
                }
                for (Operation op : portType.getOperations()) {
                    JAXRPCOperationDescriptorImpl opDesc = new JAXRPCOperationDescriptorImpl(op.getName());
                    this.opDescList.add(opDesc);
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "Added JAXRPCOperationDescriptorImpl with name: " + op.getName());
                }
            } else if (portType == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Did not find portType for binding: " + binding.getQName().toString());
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found portType but no operations for binding: " + binding.getQName().toString());
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Did not find binding for port: " + this.wsdlPort.getName());
        }
    }

    protected void setParent(WSServiceDescriptor parent) {
        this.parent = parent;
    }

    public WSServiceDescriptor getParent() {
        return this.parent;
    }

    public QName getQName() {
        return this.portQName;
    }

    public String getURLPattern() {
        return this.urlPattern;
    }

    public String getPortComponentName() {
        return this.portComponentName;
    }

    public ServiceBeanInfo getServiceBeanInfo() {
        return this.beanInfo;
    }

    private void buildServiceBeanInfo(PortComponent portComponent) {
        ServiceBeanInfo.BeanType beanType = null;
        String linkValue = null;
        String implName = this.getImplName(portComponent);
        if (portComponent.getServiceImplBean() != null && portComponent.getServiceImplBean().getEEJBLink() != null) {
            linkValue = portComponent.getServiceImplBean().getEEJBLink().getEjbLink();
            beanType = ServiceBeanInfo.BeanType.EJB;
        } else if (portComponent.getServiceImplBean() != null && portComponent.getServiceImplBean().getEServletLink() != null) {
            linkValue = portComponent.getServiceImplBean().getEServletLink().getServletLink();
            beanType = ServiceBeanInfo.BeanType.WEB;
        }
        this.beanInfo = new ServiceBeanInfoImpl(implName, linkValue, beanType);
    }

    private void setURLPattern(PortComponent portComponent) {
        WSModuleDescriptorImpl grandParent = (WSModuleDescriptorImpl)this.parent.getParent();
        this.urlPattern = ModuleUtils.getURLPattern(grandParent.getModuleFile(), portComponent);
    }

    private String getImplName(PortComponent portComponent) {
        WSModuleDescriptorImpl grandParent = (WSModuleDescriptorImpl)this.parent.getParent();
        String implClassName = Axis2Utils.getWSImplementationClassName((PortComponent)portComponent, (ModuleFile)grandParent.getModuleFile());
        return implClassName;
    }

    public String toString() {
        return DBUtils.printDBObject(this);
    }
}

