/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.desc.DBUtils;
import com.ibm.ws.websvcs.desc.DDClientOperationDescriptorImpl;
import com.ibm.wsspi.websvcs.desc.WSClientEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientOperationDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.xml.namespace.QName;

public class DDClientEndpointDescriptorImpl
implements WSClientEndpointDescriptor {
    private static final TraceComponent _tc = Tr.register(DDClientEndpointDescriptorImpl.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private Port wsdlPort;
    private boolean operationsBuilt;
    private List<WSClientOperationDescriptor> opDescList;

    DDClientEndpointDescriptorImpl(Port wsdlPort) {
        this.wsdlPort = wsdlPort;
        this.operationsBuilt = false;
        this.opDescList = new ArrayList<WSClientOperationDescriptor>();
    }

    public String getName() {
        return this.wsdlPort.getName();
    }

    public QName getBindingQName() {
        return this.wsdlPort.getBinding() != null ? this.wsdlPort.getBinding().getQName() : null;
    }

    public QName getPortTypeQName() {
        QName ptQName = null;
        if (this.wsdlPort.getBinding() != null && this.wsdlPort.getBinding().getPortType() != null) {
            ptQName = this.wsdlPort.getBinding().getPortType().getQName();
        }
        return ptQName;
    }

    public Iterator getOperations() {
        this.buildOperations();
        return this.opDescList.iterator();
    }

    private void buildOperations() {
        if (!this.operationsBuilt) {
            Binding wsdlBinding = this.wsdlPort.getBinding();
            if (wsdlBinding != null && wsdlBinding.getPortType() != null) {
                for (Operation op : wsdlBinding.getPortType().getOperations()) {
                    DDClientOperationDescriptorImpl opDesc = new DDClientOperationDescriptorImpl(op.getName());
                    this.opDescList.add(opDesc);
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "Built DDClientOperationDescriptorImpl: " + op.getName());
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Client operation descriptors cannot be built for the service-ref endpoint descriptor: " + this.getName() + ". Either a " + "binding or port type could not be located for the " + "endpoint.");
            }
            this.operationsBuilt = true;
        }
    }

    public String toString() {
        return DBUtils.printDBObject(this);
    }
}

