/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class WebServicesSecurityAlgorithmHelper {
    private static final TraceComponent tc = Tr.register(WebServicesSecurityAlgorithmHelper.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String FFDC_SOURCE_ID = "com.ibm.ws.webservices.wssecurity.util.WebServicesSecurityAlgorithmHelper";
    private static final String clsName = WebServicesSecurityAlgorithmHelper.class.getName();
    private static final String comp = "security.wssecurity";
    protected static Set _transforms = new HashSet();
    protected static Set _canonicalizationMethods = new HashSet();
    protected static Set _signatureMethods = new HashSet();
    protected static Set _digestMethods = new HashSet();
    protected static Set _encryptionMethods = new HashSet();
    protected static Set _keyEncryptionMethods = new HashSet();
    protected static Set _fipsSignatureMethods = new HashSet();
    protected static Set _fipsDigestMethods = new HashSet();
    protected static Set _fipsEncryptionMethods = new HashSet();
    protected static Set _fipsKeyEncryptionMethods = new HashSet();
    protected static Set _canonicalizationMethods5 = new HashSet();
    protected static Set _signatureMethods5 = new HashSet();
    protected static Set _digestMethods5 = new HashSet();
    protected static Set _encryptionMethods5 = new HashSet();
    protected static Set _keyEncryptionMethods5 = new HashSet();
    protected static Set _fipsSignatureMethods5 = new HashSet();
    protected static Set _fipsDigestMethods5 = new HashSet();
    protected static Set _fipsEncryptionMethods5 = new HashSet();
    protected static Set _fipsKeyEncryptionMethods5 = new HashSet();
    protected static boolean _init_failed = false;
    protected static boolean _init_called = false;
    protected static SoapSecurityException _sse = null;

    public WebServicesSecurityAlgorithmHelper() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WebServicesSecurityAlgorithmHelper");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WebServicesSecurityAlgorithmHelper");
        }
    }

    private static synchronized void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        if (!_init_called) {
            try {
                Document doc = DOMUtil.getPrivateConfig();
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(doc, "Transform", "algorithm", _transforms);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(doc, "canonicalizationMethod", "algorithm", _canonicalizationMethods);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(doc, "signatureMethod", "algorithm", _signatureMethods);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(doc, "digestMethod", "algorithm", _digestMethods);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(doc, "encryptionMethod", "algorithm", _encryptionMethods);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(doc, "keyEncryptionMethod", "algorithm", _keyEncryptionMethods);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(doc, "fipsSignatureMethod", "algorithm", _fipsSignatureMethods);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(doc, "fipsDigestMethod", "algorithm", _fipsDigestMethods);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(doc, "fipsEncryptionMethod", "algorithm", _fipsEncryptionMethods);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(doc, "fipsKeyEncryptionMethod", "algorithm", _fipsKeyEncryptionMethods);
                Document doc5 = com.ibm.xml.soapsec.util.DOMUtil.getConfigValidation();
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(doc5, "canonicalizationMethod", "algorithm", _canonicalizationMethods5);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(doc5, "signatureMethod", "algorithm", _signatureMethods5);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(doc5, "digestMethod", "algorithm", _digestMethods5);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(doc5, "encryptionMethod", "algorithm", _encryptionMethods5);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(doc5, "keyEncryptionMethod", "algorithm", _keyEncryptionMethods5);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(doc5, "fipsSignatureMethod", "algorithm", _fipsSignatureMethods5);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(doc5, "fipsDigestMethod", "algorithm", _fipsDigestMethods5);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(doc5, "fipsEncryptionMethod", "algorithm", _fipsEncryptionMethods5);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(doc5, "fipsKeyEncryptionMethod", "algorithm", _fipsKeyEncryptionMethods5);
            }
            catch (SoapSecurityException e) {
                FFDCFilter.processException(e, clsName + ".init", "129");
                Tr.error(tc, "Exception while retrieving available algorithms: " + e);
                _init_failed = true;
                _sse = e;
            }
            _init_called = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    private static void addAlgorithmsToSet(Document doc, String tag, String attribute, Set set) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addAlgorithmsToSet(doc = " + doc + ", tag = " + tag + ", attribute = " + attribute + ", set = " + set + ")");
        }
        NodeList list = doc.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", tag);
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            String value = DOMUtil.getAttribute((Element)((Element)list.item(i)), (String)attribute);
            if (ConfigValidation.isAlgoSupportedByRuntime(value)) {
                set.add(value);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Algorithm " + value + " not supported by runtime.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Set of " + tag + " algorithms: " + set);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addAlgorithmsToSet");
        }
    }

    public Set getFipsDataEncryptionAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFipsDataEncryptionAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFipsDataEncryptionAlgorithms");
        }
        return _fipsEncryptionMethods;
    }

    public Set getFipsKeyEncryptionAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFipsKeyEncryptionAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFipsKeyEncryptionAlgorithms");
        }
        return _fipsKeyEncryptionMethods;
    }

    public Set getFipsSignatureAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFipsSignatureAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFipsSignatureAlgorithms");
        }
        return _fipsSignatureMethods;
    }

    public Set getFipsDigestAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFipsDigestAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFipsDigestAlgorithms");
        }
        return _fipsDigestMethods;
    }

    public Set getDataEncryptionAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDataEncryptionAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDataEncryptionAlgorithms");
        }
        return _encryptionMethods;
    }

    public Set getKeyEncryptionAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyEncryptionAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyEncryptionAlgorithms");
        }
        return _keyEncryptionMethods;
    }

    public Set getSignatureAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSignatureAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSignatureAlgorithms");
        }
        return _signatureMethods;
    }

    public Set getDigestAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDigestAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDigestAlgorithms");
        }
        return _digestMethods;
    }

    public Set getCanonicalizationAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCanonicalizationAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCanonicalizationAlgorithms");
        }
        return _canonicalizationMethods;
    }

    public Set getTransformAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransformAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTransformAlgorithms");
        }
        return _transforms;
    }

    public Set get5xFipsDataEncryptionAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get5xFipsDataEncryptionAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get5xFipsDataEncryptionAlgorithms");
        }
        return _fipsEncryptionMethods5;
    }

    public Set get5xFipsKeyEncryptionAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get5xFipsKeyEncryptionAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get5xFipsKeyEncryptionAlgorithms");
        }
        return _fipsKeyEncryptionMethods5;
    }

    public Set get5xFipsSignatureAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get5xFipsSignatureAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get5xFipsSignatureAlgorithms");
        }
        return _fipsSignatureMethods5;
    }

    public Set get5xFipsDigestAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get5xFipsDigestAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get5xFipsDigestAlgorithms");
        }
        return _fipsDigestMethods5;
    }

    public Set get5xDataEncryptionAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get5xDataEncryptionAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get5xDataEncryptionAlgorithms");
        }
        return _encryptionMethods5;
    }

    public Set get5xKeyEncryptionAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get5xKeyEncryptionAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get5xKeyEncryptionAlgorithms");
        }
        return _keyEncryptionMethods5;
    }

    public Set get5xSignatureAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get5xSignatureAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get5xSignatureAlgorithms");
        }
        return _signatureMethods5;
    }

    public Set get5xDigestAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get5xDigestAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get5xDigestAlgorithms");
        }
        return _digestMethods5;
    }

    public Set get5xCanonicalizationAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get5xCanonicalizationAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get5xCanonicalizationAlgorithms");
        }
        return _canonicalizationMethods5;
    }
}

