/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.XPathElementSelector;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSPFunctionElementSelector
extends XPathElementSelector {
    private static final TraceComponent tc = Tr.register(WSPFunctionElementSelector.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String WSP_BODY = "wsp:Body";
    private static final String WSP_HEADER = "wsp:Header";
    private static final String[] BODY_TEMPLATE = new String[]{"/*[namespace-uri()='", "' and local-name()='Envelope']/*[namespace-uri()='", "' and local-name()='Body']"};
    private static final String[] HEADER_TEMPLATE = new String[]{"/*[namespace-uri()='", "' and local-name()='Envelope']/*[namespace-uri()='", "' and local-name()='Header']/*[name()='", "']"};

    public void init(Map properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map properties)");
        }
        super.init(properties);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map properties)");
        }
    }

    public NodeList getElements(Node node, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getElements(Node node[" + DOMUtil.getDisplayName((Node)node) + "]," + "Map context)"));
        }
        String keyword = (String)context.get("com.ibm.ws.webservices.wssecurity.util.selector.keyword");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Expression [" + keyword + "]"));
        }
        int version = 0;
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.soapVersion");
        if (obj != null && obj instanceof Integer) {
            version = (Integer)obj;
        }
        String nsSoap = Constants.NAMESPACES[2][version];
        if (keyword != null) {
            keyword = WSPFunctionElementSelector.convert2XPath(nsSoap, keyword);
            context.put("com.ibm.ws.webservices.wssecurity.util.selector.keyword", keyword);
        }
        NodeList list = super.getElements(node, context);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getElements(Node node,Map context) returns NodeList[" + list + "]"));
        }
        return list;
    }

    protected static String convert2XPath(String nsSoap, String exp) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("convert2XPath(String nsSoap[" + nsSoap + "]," + "String exp[" + exp + "])"));
        }
        exp = exp.trim();
        StringBuffer buf = new StringBuffer();
        if (exp.startsWith(WSP_BODY)) {
            buf.append(BODY_TEMPLATE[0]).append(nsSoap);
            buf.append(BODY_TEMPLATE[1]).append(nsSoap);
            buf.append(BODY_TEMPLATE[2]);
            int start = exp.indexOf(41) + 1;
            if (start != exp.length()) {
                buf.append(exp.substring(start));
            }
        } else if (exp.startsWith(WSP_HEADER)) {
            buf.append(HEADER_TEMPLATE[0]).append(nsSoap);
            buf.append(HEADER_TEMPLATE[1]).append(nsSoap);
            buf.append(HEADER_TEMPLATE[2]);
            int start = exp.indexOf(40) + 1;
            int end = exp.indexOf(41);
            buf.append(exp.substring(start, end));
            buf.append(HEADER_TEMPLATE[3]);
            if (end != exp.length() - 1) {
                buf.append(exp.substring(end + 1));
            }
        }
        String ret = buf.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("convert2XPath(String nsSoap,String exp) returns String[" + ret + "]"));
        }
        return ret;
    }
}

