/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.ElementSelector;
import com.ibm.ws.webservices.wssecurity.core.WSSGenerator;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TimestampDialectElementSelector
implements ElementSelector {
    private static final TraceComponent tc = Tr.register(TimestampDialectElementSelector.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    public static final String MOVE_MODE = "move";
    public static final String CHECK_MODE = "check";
    public static final int SECURITYFIRST = 0;
    public static final int SECURITYLAST = 1;
    public static final int SOAPHEADERFIRST = 2;
    public static final int SOAPHEADERLAST = 3;
    public static final int SECURITY_GENERATOR_DEFAULT = 1;
    public static final int SOAPHEADER_GENERATOR_DEFAULT = 3;
    public static final int SECURITY_CONSUMER_DEFAULT = 4;
    public static final int SOAPHEADER_CONSUMER_DEFAULT = 5;
    public static final String[] WASDIALECTS = new String[]{"SecurityFirst".intern(), "SecurityLast".intern(), "SOAPHeaderFirst".intern(), "SOAPHeaderLast".intern(), "SecurityConsumerDefault".intern(), "SOAPHeaderConsumerDefault".intern()};

    public void init(Map properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map properties)");
        }
    }

    public NodeList getElements(Node node, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getElements(Node node[" + DOMUtil.getDisplayName((Node)node) + "]," + "Map context)"));
        }
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s02");
        }
        if (!(node instanceof Document)) {
            throw SoapSecurityException.format("security.wssecurity.IntegralDialectElementSelector.s01", node.getClass().getName(), "Document");
        }
        String keyword = (String)context.get("com.ibm.ws.webservices.wssecurity.util.selector.keyword");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Expression [" + keyword + "]"));
        }
        if (keyword == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s03");
        }
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.util.selector.operation");
        boolean move = MOVE_MODE.equals((String)obj);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Mode [" + obj + "]"));
        }
        obj = context.get("com.ibm.ws.webservices.wssecurity.constants.soapVersion");
        int soapVersion = 0;
        if (obj != null && obj instanceof Integer) {
            soapVersion = (Integer)obj;
        }
        obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsu = Constants.NAMESPACES[1][wssVersion];
        String actor = null;
        if (context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey") == null) {
            WSSConsumerConfig cconfig = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
            if (cconfig != null) {
                actor = cconfig.getMyActor();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got consumer actor " + actor));
            }
        } else {
            WSSGeneratorConfig gconfig = (WSSGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
            if (gconfig != null) {
                actor = gconfig.getTargetActor();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got generator actor " + actor));
            }
        }
        Document doc = (Document)node;
        Element header = WSSGenerator.getHeader(doc, false);
        Element security2 = WSSGenerator.getSecurityHeader(header, soapVersion, wssVersion, actor, false);
        NodeList list = null;
        list = move ? TimestampDialectElementSelector.moveTimestamp(header, security2, keyword, nsWsu, context) : TimestampDialectElementSelector.getElements(header, security2, keyword, nsWsu);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getElements(Node node,Map context)");
        }
        return list;
    }

    private static NodeList moveTimestamp(Element header, Element security2, String keyword, String nsWsu, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("moveTimestamp(Element header[" + DOMUtil.getDisplayName((Node)header) + "]," + "Element security[" + DOMUtil.getDisplayName((Node)security2) + "]," + "String keyword[" + keyword + "]," + "String nsWsu[" + nsWsu + "]," + "Map context)"));
        }
        Node timestamp = null;
        Object[] objs = (Object[])context.get("com.ibm.ws.webservices.wssecurity.util.selector.element");
        if (objs != null && objs.length > 0) {
            timestamp = (Node)objs[0];
        }
        if (timestamp == null) {
            throw SoapSecurityException.format("security.wssecurity.TimestampDialectElementSelector.s01");
        }
        timestamp.getParentNode().removeChild(timestamp);
        XPathCanonicalizer.NodeListImpl list = new XPathCanonicalizer.NodeListImpl();
        if (WASDIALECTS[0].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Moving to the first of the Security element.");
            }
            timestamp = security2.insertBefore(timestamp, security2.getFirstChild());
        } else if (WASDIALECTS[1].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Moving to the last of the Security element.");
            }
            timestamp = security2.appendChild(timestamp);
        } else if (WASDIALECTS[2].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Moving to the first of the SOAP header element.");
            }
            timestamp = header.insertBefore(timestamp, header.getFirstChild());
        } else if (WASDIALECTS[3].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Moving to the last of the Security element.");
            }
            timestamp = header.appendChild(timestamp);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unknown keyword[" + keyword + "], so applying the default."));
                Tr.debug((TraceComponent)tc, (String)"Moving to the last of the Security element.");
            }
            timestamp = security2.appendChild(timestamp);
        }
        objs[0] = timestamp;
        context.put("com.ibm.ws.webservices.wssecurity.util.selector.element", objs);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("moveTimestamp(Element header,Element security,String keyword,String nsWsu,Map context) returns NodeList[" + list + "]"));
        }
        return list;
    }

    private static NodeList getElements(Element header, Element security2, String keyword, String nsWsu) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getElements(Element header[" + DOMUtil.getDisplayName((Node)header) + "]," + "Element security[" + DOMUtil.getDisplayName((Node)security2) + "]," + "String keyword[" + keyword + "]," + "String nsWsu[" + nsWsu + "])"));
        }
        XPathCanonicalizer.NodeListImpl list = new XPathCanonicalizer.NodeListImpl();
        Element element = null;
        if (WASDIALECTS[0].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting the first child element in the Security element.");
            }
            element = DOMUtil.getFirstElement((Node)security2);
        } else if (WASDIALECTS[1].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting the last child element in the Security element.");
            }
            element = DOMUtil.getLastElement((Node)security2);
        } else if (WASDIALECTS[2].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting the first child element in the SOAP header element.");
            }
            element = DOMUtil.getFirstElement((Node)header);
        } else if (WASDIALECTS[3].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting the last child element in the SOAP header element.");
            }
            element = DOMUtil.getLastElement((Node)header);
        } else if (WASDIALECTS[4].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting the immediate child element in the Security element.");
            }
            element = DOMUtil.getFirstElement((Node)security2, (String)nsWsu, (String)"Timestamp");
        } else if (WASDIALECTS[5].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting the immediate child element in the SOAP header element.");
            }
            element = DOMUtil.getFirstElement((Node)header, (String)nsWsu, (String)"Timestamp");
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unknown keyword[" + keyword + "], so applying the default."));
                Tr.debug((TraceComponent)tc, (String)"Getting the last child element in the Security element.");
            }
            element = DOMUtil.getLastElement((Node)security2);
        }
        list.add((Node)element);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getElements(Element header,Element security,String keyword,String nsWsu, returns NodeList[" + list + "]"));
        }
        return list;
    }
}

