/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.Tr;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NamespaceUtil {
    private static final String comp = "security.wssecurity";
    private static final String clsName = NamespaceUtil.class.getName();

    public static int checkSoapVersion(Node node, int soapVersion, String localName) {
        return NamespaceUtil.checkVersion(node.getNamespaceURI(), node.getLocalName(), 2, soapVersion, localName);
    }

    public static int checkWsseVersion(Node node, int wssVersion, String localName) {
        return NamespaceUtil.checkVersion(node.getNamespaceURI(), node.getLocalName(), 0, wssVersion, localName);
    }

    public static int checkWsuVersion(Node node, int wssVersion, String localName) {
        return NamespaceUtil.checkVersion(node.getNamespaceURI(), node.getLocalName(), 1, wssVersion, localName);
    }

    public static int checkWsseVersion(QName qname, int wssVersion, String localName) {
        return NamespaceUtil.checkVersion(qname.getNamespaceURI(), qname.getLocalPart(), 0, wssVersion, localName);
    }

    public static int checkWsuVersion(QName qname, int wssVersion, String localName) {
        return NamespaceUtil.checkVersion(qname.getNamespaceURI(), qname.getLocalPart(), 1, wssVersion, localName);
    }

    private static int checkVersion(String namespaceURI, String localName, int index, int version, String ln) {
        if (localName == null || ln == null) {
            return -1;
        }
        if (!localName.equals(ln)) {
            return -1;
        }
        int getVersion = NamespaceUtil.compareNS(namespaceURI, index);
        if (version >= 0) {
            if (getVersion == version) {
                return version;
            }
        } else if (getVersion >= 0) {
            return getVersion;
        }
        return -1;
    }

    public static int isSoap(String namespace) {
        if (namespace == null) {
            return -1;
        }
        if (namespace.equals(Constants.NS_SOAP)) {
            return 0;
        }
        return namespace.equals(Constants.NS_SOAP12) ? 1 : -1;
    }

    public static int isWsse(String namespace) {
        if (namespace == null) {
            return -1;
        }
        return namespace.equals(Constants.NS_WSSE) ? 0 : -1;
    }

    public static int isWsu(String namespace) {
        if (namespace == null) {
            return -1;
        }
        return namespace.equals(Constants.NS_WSU) ? 0 : -1;
    }

    private static final int compareNS(String namespace, int idx) {
        for (int i = 0; i < Constants.NAMESPACES[idx].length; ++i) {
            if (namespace != Constants.NAMESPACES[idx][i]) continue;
            return i;
        }
        return -1;
    }

    public static NodeList getWsseElementsByTagName(Element elem, String local) {
        return NamespaceUtil.getXElementsByTagName(elem, local, 0);
    }

    private static NodeList getXElementsByTagName(Element elem, String local, int index) {
        NodeList list = null;
        for (int i = 0; i < Constants.NAMESPACES[index].length; ++i) {
            list = elem.getElementsByTagNameNS(Constants.NAMESPACES[index][i], local);
            if (list == null || list.getLength() <= 0) continue;
            return list;
        }
        return list;
    }

    public static NodeList getWsuElementsByTagName(Element elem, String local) {
        return NamespaceUtil.getXElementsByTagName(elem, local, 1);
    }

    public static Element getFirstWsseElement(Element elem, String local) {
        Element child = null;
        for (int i = 0; i < Constants.NAMESPACES[0].length; ++i) {
            child = DOMUtil.getFirstElement((Node)elem, (String)Constants.NAMESPACES[0][i], (String)local);
            if (child == null) continue;
            return child;
        }
        return child;
    }

    public static Element getFirstWsuElement(Element elem, String local) {
        Element child = null;
        for (int i = 0; i < Constants.NAMESPACES[1].length; ++i) {
            child = DOMUtil.getFirstElement((Node)elem, (String)Constants.NAMESPACES[1][i], (String)local);
            if (child == null) continue;
            return child;
        }
        return child;
    }

    public static SOAPHeaderElement getWsseHeaderByName(SOAPEnvelope env, String local) throws SoapSecurityException {
        return NamespaceUtil.getHeaderByName(env, local, 0);
    }

    public static SOAPHeaderElement getWsuHeaderByName(SOAPEnvelope env, String local) throws SoapSecurityException {
        return NamespaceUtil.getHeaderByName(env, local, 1);
    }

    private static SOAPHeaderElement getHeaderByName(SOAPEnvelope env, String local, int idx) throws SoapSecurityException {
        SOAPHeaderElement element = null;
        try {
            for (int i = 0; i < Constants.NAMESPACES[idx].length; ++i) {
                SOAPHeaderElement e = NamespaceUtil.getHeaderByName(env, Constants.NAMESPACES[idx][i], local);
                if (e == null) continue;
                element = e;
                break;
            }
        }
        catch (SOAPException e) {
            Tr.processException((Throwable)e, (String)(clsName + ".invoke"), (String)"333");
            String prefix = idx == 0 ? "wsse:" : "wsu:";
            throw SoapSecurityException.format("security.wssecurity.NamespaceUtil.s01", prefix + local, e.getMessage());
        }
        return element;
    }

    private static SOAPHeaderElement getHeaderByName(SOAPEnvelope env, String namespace, String localPart) throws SOAPException {
        SOAPHeader header = env.getHeader();
        Element obj = DOMUtil.getChildElement((Element)header, (String)namespace, (String)localPart);
        if (obj == null) {
            return null;
        }
        return (SOAPHeaderElement)((Object)obj);
    }

    public static String getWsuAttribute(Element elem, String name) {
        String value = null;
        for (int i = 0; i < Constants.NAMESPACES[1].length; ++i) {
            value = elem.getAttributeNS(Constants.NAMESPACES[1][i], name);
            if (value.length() == 0) continue;
            return value;
        }
        return value;
    }

    public static int checkVersion(QName received, QName inConstants) {
        String inConstLocal;
        if (received == null || inConstants == null) {
            return -1;
        }
        String receivedLocal = received.getLocalPart();
        if (receivedLocal != (inConstLocal = inConstants.getLocalPart())) {
            return -1;
        }
        String receivedNS = received.getNamespaceURI();
        String inConstNS = inConstants.getNamespaceURI();
        if (inConstNS == Constants.NAMESPACES[0][0]) {
            return NamespaceUtil.compareNS(receivedNS, 0);
        }
        if (inConstNS == Constants.NAMESPACES[1][0]) {
            return NamespaceUtil.compareNS(receivedNS, 1);
        }
        return -1;
    }

    public static boolean equals(QName received, QName inConstants) {
        if (received == null || inConstants == null) {
            return false;
        }
        if (received.equals(inConstants)) {
            return true;
        }
        return NamespaceUtil.checkVersion(received, inConstants) > 0;
    }
}

