/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.jgss.TokenHeader;
import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.krb5.Credentials;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.internal.APReq;
import com.ibm.security.krb5.internal.EncTicketPart;
import com.ibm.security.krb5.internal.Ticket;
import com.ibm.security.krb5.wss.KerberosTokenConsumer;
import com.ibm.security.krb5.wss.KerberosTokenGenerator;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.util.UUID;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.wssecurity.KRBConstants;
import com.ibm.ws.webservices.wssecurity.config.KRBSPN;
import com.ibm.ws.webservices.wssecurity.config.KRBSPNList;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.token.KRBDerivedKeyToken;
import com.ibm.wsspi.wssecurity.token.KRBTokenInfo;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class KRB5Util {
    private static Object _lock = new Object();
    private static TraceComponent tc;
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final char NEWLINE = '\n';
    private static final char TILDA = '~';
    private static final char DOT = '.';
    public static final int TOK_ID_LEN = 2;
    public static final byte[] AP_REQ_TOK_ID;
    public static final int Des3EType_KD_KDC_REP_TICKET = 2;
    public static final int AES128_KD_KDC_REP_TICKET = 2;
    public static final int AES256_KD_KDC_REP_TICKET = 2;
    public static final int Rc4HMac_KD_AS_REP_SERV = 2;
    public static final int Rc4HMac_KD_AP_REQ_AUTHN = 11;
    public static final int Des3EType_KD_AP_REQ_AUTH = 11;
    public static final int AES128_KD_AP_REQ_AUTH = 11;
    public static final int AES256_KD_AP_REQ_AUTH = 11;
    public static final int Rc4HMac_KD_TGS_REP = 8;
    public static final int WRAPPED = 1;
    public static final int NOT_WRAPPED = 0;
    private static boolean _debug;
    public static final int JAAS_LOGIN_CONFIG = 0;
    public static final int TOKEN_CONSUMER_CONFIG = 1;
    public static final int TOKEN_GENERATOR_CONFIG = 2;
    public static final String JAAS_LOGIN_CONFIG_LABEL = "JAAS Login Module";
    public static final String TOKEN_CONSUMER_CONFIG_LABEL = "Token Consumer";
    public static final String TOKEN_GENERATOR_CONFIG_LABEL = "Token Generator";
    public static final String DEFAULT_JAAS_LOGIN_CONFIG = "JAASClient";
    private static KRBSPNList servicePrincipalNameList;
    private static ResourceBundle nls;
    public static final String XMLDSIG_NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    public static final String XMLENC_NS = "http://www.w3.org/2001/04/xmlenc#";
    public static final String TRIPLEDES_CBC = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    public static final String AES128_CBC = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    public static final String AES192_CBC = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    public static final String AES256_CBC = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    public static final String HMAC = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    public static final String DSA = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";

    public static ResourceBundle getNLS() {
        if (nls == null) {
            try {
                nls = ResourceBundle.getBundle("com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
            }
            catch (MissingResourceException ex) {
                FFDCFilter.processException(ex, "com.ibm.ws.webservices.wssecurity.util.KRB5Util", "1");
            }
        }
        return nls;
    }

    public static String showHex(byte[] buffer) {
        int i;
        if (buffer == null || buffer.length == 0) {
            return "";
        }
        int nBytes = buffer.length;
        StringBuffer sb = new StringBuffer(nBytes);
        StringBuffer pb = new StringBuffer(nBytes << 1);
        StringBuffer hb = new StringBuffer(nBytes << 1);
        StringBuffer tb = new StringBuffer(nBytes << 1);
        int j = 0;
        int k = 0;
        float f = 0.0f;
        for (i = 0; i < nBytes; ++i) {
            int value = buffer[i] & 0xFF;
            if (value == 13 || value == 10 || value == 9 || value >= 32 && value <= 126) {
                sb.append((char)value);
            } else {
                sb.append('[' + KRB5Util.hexPad(Integer.toHexString(value), 2) + ']');
                f += 1.0f;
            }
            if (value >= 32 && value <= 126) {
                tb.append((char)value);
            } else {
                tb.append('.');
            }
            hb.append(KRB5Util.hexPad(Integer.toHexString(value), 2));
            if (j == 3 || j == 7 || j == 11) {
                hb.append(' ');
                tb.append(' ');
            }
            if (j == 15) {
                pb.append(KRB5Util.hexPad(Integer.toHexString(k), 4)).append(":  ").append(hb).append("    ").append(tb).append("\n");
                j = 0;
                k += 16;
                hb.setLength(0);
                tb.setLength(0);
                continue;
            }
            ++j;
        }
        for (i = hb.length(); i < 35; ++i) {
            hb.append(' ');
        }
        pb.append(KRB5Util.hexPad(Integer.toHexString(k), 4)).append(":  ").append(hb).append("    ").append(tb).append("\n");
        return pb.toString();
    }

    private static String hexPad(String aString, int aPadLength) {
        if (aString == null || aString.length() == 0) {
            return "";
        }
        int stringSize = aString.length();
        StringBuffer buffer = new StringBuffer(stringSize + aPadLength);
        for (int i = stringSize; i < aPadLength; ++i) {
            buffer.append('0');
        }
        buffer.append(aString);
        return buffer.toString();
    }

    public static boolean isTGTInSubject(Subject subject) {
        Iterator credIt;
        boolean tgtExists = false;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isTGTInSubject()");
        }
        if (subject != null && (credIt = KRB5Util.getTokens(subject, KerberosTicket.class).iterator()) != null && credIt.hasNext()) {
            tgtExists = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Kerberor Ticket Exists In Subject [" + tgtExists + "]"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isTGTInSubject()");
        }
        return tgtExists;
    }

    public static KerberosTicket getTGTInSubject(Subject subject) {
        Iterator credIt;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTGTInSubject()");
        }
        KerberosTicket cred = null;
        if (subject != null && (credIt = KRB5Util.getTokens(subject, KerberosTicket.class).iterator()) != null && credIt.hasNext()) {
            cred = (KerberosTicket)credIt.next();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Kerberor Ticket Exists In Subject [" + (cred != null) + "]"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTGTInSubject()");
        }
        return cred;
    }

    public static boolean isTokenInSubject(Subject subject, Class tokenClass) {
        boolean tokenExists = false;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isTokenInSubject()");
        }
        if (subject != null && KRB5Util.getTokens(subject, tokenClass).size() > 0) {
            tokenExists = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Token Exists In Subject [" + tokenExists + "]"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isTokenInSubject()");
        }
        return tokenExists;
    }

    public static String getKerberosPrincipalFromSubject(Subject subject) {
        Object principalObj;
        Iterator principalIt;
        String was_principal = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPrincipalFromSubject()");
        }
        if (subject != null && (principalIt = KRB5Util.getPrincipals(subject, KerberosPrincipal.class).iterator()) != null && principalIt.hasNext() && (was_principal = ((KerberosPrincipal)(principalObj = principalIt.next())).getName()) != null) {
            int idx = was_principal.indexOf(64);
            if (idx > 0) {
                was_principal = was_principal.substring(0, idx);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Kerberos Principal (realm stripped): " + was_principal));
            }
        }
        if (was_principal == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No Kerberos Principal Found In Subject");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPrincipalFromSubject()");
        }
        return was_principal;
    }

    private static Set getTokens(Subject subject, Class tokenClass) {
        boolean bGetCreds = true;
        return KRB5Util.getSubjectObjects(subject, tokenClass, bGetCreds);
    }

    private static Set getPrincipals(Subject subject, Class principalClass) {
        boolean bGetCreds = false;
        return KRB5Util.getSubjectObjects(subject, principalClass, bGetCreds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getSubjectObjects(final Subject subject, final Class objectClass, final boolean bGetCreds) {
        String methodName = "getSubjectObjects";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName);
        }
        Set set = new HashSet();
        if (subject == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"subject", methodName});
            return set;
        }
        if (objectClass == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"objectClass", methodName});
            return set;
        }
        Object object = _lock;
        synchronized (object) {
            set = (Set)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Set<Object> result = new HashSet();
                    try {
                        result = bGetCreds ? subject.getPrivateCredentials(objectClass) : subject.getPrincipals(objectClass);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Number of subject objects retrived = " + result.size()));
                        }
                    }
                    catch (Throwable t) {
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.unexpected.exception", (Object)KRB5Util.stackToString(t));
                    }
                    return result;
                }
            });
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addCredentialToSubject(final Subject subject, final Object obj) {
        Boolean addedCredentials = Boolean.FALSE;
        String methodName = "addCredentialToSubject";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName);
        }
        if (subject == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"subject", methodName});
            return addedCredentials;
        }
        if (obj == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"crendential", methodName});
            return addedCredentials;
        }
        Object object = _lock;
        synchronized (object) {
            addedCredentials = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Boolean bResult;
                    block4: {
                        bResult = Boolean.FALSE;
                        try {
                            if (subject != null) {
                                subject.getPrivateCredentials().add(obj);
                                bResult = Boolean.TRUE;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Credential added successfully to the subject. ");
                                }
                            }
                        }
                        catch (Throwable t) {
                            if (!tc.isDebugEnabled()) break block4;
                            Tr.debug((TraceComponent)tc, (String)"Credential is NOT added to the subject. ");
                        }
                    }
                    return bResult;
                }
            });
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
        return addedCredentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addPrincipalToSubject(final Subject subject, final Principal principal) {
        Boolean addedCredentials = Boolean.FALSE;
        String methodName = "addPrincipalToSubject";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName);
        }
        if (subject == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"subject", methodName});
            return addedCredentials;
        }
        if (principal == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"principal", methodName});
            return addedCredentials;
        }
        Object object = _lock;
        synchronized (object) {
            addedCredentials = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Boolean bResult;
                    block4: {
                        bResult = Boolean.FALSE;
                        try {
                            if (subject != null) {
                                subject.getPrincipals().add(principal);
                                bResult = Boolean.TRUE;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Principal added successfully to the subject. ");
                                }
                            }
                        }
                        catch (Throwable t) {
                            if (!tc.isDebugEnabled()) break block4;
                            Tr.debug((TraceComponent)tc, (String)"Principal is NOT added to the subject. ");
                        }
                    }
                    return bResult;
                }
            });
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
        return addedCredentials;
    }

    public static HashMap consumeBinarySecurityToken(Element target) {
        String methodName = "consumeBinarySecurityToken";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (target == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"target", methodName});
            return properties;
        }
        try {
            String token = DOMUtil.getStringValue((Node)target);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("token = " + token));
            }
            if (token == null) {
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.token.unavailable", (Object)target);
                return properties;
            }
            String encodingType = DOMUtil.getAttribute((Element)target, (String)"EncodingType");
            String valueType = DOMUtil.getAttribute((Element)target, (String)"ValueType");
            Boolean base64Binary = Boolean.FALSE;
            if (encodingType.endsWith("#Base64Binary")) {
                base64Binary = Boolean.TRUE;
            }
            String tokenID = IdUtil.getInstance().getId(target);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Encoding type = " + encodingType));
                Tr.debug((TraceComponent)tc, (String)("base64Binary = " + base64Binary));
                Tr.debug((TraceComponent)tc, (String)("tokenID = " + tokenID));
                Tr.debug((TraceComponent)tc, (String)("valueType = " + valueType));
            }
            byte[] krbTokenBytes = null;
            krbTokenBytes = base64Binary == true ? Base64Coder.base64Decode(token.getBytes()) : token.getBytes();
            properties.put("KRBToken", krbTokenBytes);
            properties.put("tokenID", tokenID);
            properties.put("ValueType", valueType);
        }
        catch (Throwable t) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.unexpected.exception", (Object)KRB5Util.stackToString(t));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
        return properties;
    }

    public static HashMap consumeDerivedKeyToken(Element target) throws SoapSecurityException {
        String methodName = "consumeDerivedKeyToken";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (target == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"target", methodName});
            return properties;
        }
        try {
            String tokenID = IdUtil.getInstance().getId(target);
            String algorithm = DOMUtil.getAttribute((Element)target, (String)"Algorithm");
            Element generationElement = DOMUtil.getOneChildElement((Element)target, (String)"http://schemas.xmlsoap.org/ws/2005/02/sc", (String)"Generation");
            String generation = DOMUtil.getStringValue((Node)generationElement);
            Element lengthElement = DOMUtil.getOneChildElement((Element)target, (String)"http://schemas.xmlsoap.org/ws/2005/02/sc", (String)"Length");
            String length = DOMUtil.getStringValue((Node)lengthElement);
            Element labelElement = DOMUtil.getOneChildElement((Element)target, (String)"http://schemas.xmlsoap.org/ws/2005/02/sc", (String)"Label");
            String label = DOMUtil.getStringValue((Node)labelElement);
            Element nonceElement = DOMUtil.getOneChildElement((Element)target, (String)"http://schemas.xmlsoap.org/ws/2005/02/sc", (String)"Nonce");
            String nonce = DOMUtil.getStringValue((Node)nonceElement);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("tokenID = " + tokenID));
                Tr.debug((TraceComponent)tc, (String)("algorithm = " + algorithm));
                Tr.debug((TraceComponent)tc, (String)("generation = " + generation));
                Tr.debug((TraceComponent)tc, (String)("length = " + length));
                Tr.debug((TraceComponent)tc, (String)("label = " + label));
                Tr.debug((TraceComponent)tc, (String)("nonce = " + nonce));
            }
            Element securityTokenReferenceElement = DOMUtil.getOneChildElement((Element)target, (String)KRBConstants.STR_WSSE_NS, (String)"SecurityTokenReference");
            Element referenceElement = DOMUtil.getZeroOrOneElement((Element)securityTokenReferenceElement, (String)KRBConstants.STR_WSSE_NS, (String)"Reference");
            String valueType = null;
            String referenceURI = null;
            String keyBytes = null;
            if (referenceElement != null) {
                referenceURI = DOMUtil.getAttribute((Element)referenceElement, (String)"URI");
                valueType = DOMUtil.getAttribute((Element)referenceElement, (String)"ValueType");
            } else {
                Element identifierElement = DOMUtil.getOneElement((Element)securityTokenReferenceElement, (String)KRBConstants.STR_WSSE_NS, (String)"KeyIdentifier");
                valueType = DOMUtil.getAttribute((Element)identifierElement, (String)"ValueType");
                keyBytes = DOMUtil.getStringValue((Node)identifierElement);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ReferenceURI = " + referenceURI));
                Tr.debug((TraceComponent)tc, (String)("ReferenceValueType = " + valueType));
                Tr.debug((TraceComponent)tc, (String)("keyBytes = " + keyBytes));
            }
            HashMap<String, String> tokenReference = new HashMap<String, String>();
            tokenReference.put("URI", referenceURI);
            tokenReference.put("ValueType", valueType);
            tokenReference.put("KeyBytes", keyBytes);
            String keyType = null;
            keyType = KRB5Util.isDerivedKeyReferecedInSignature(target.getParentNode(), tokenID) ? "VerifyingKey" : "DecryptingKey";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("keyType = " + keyType));
            }
            properties.put("tokenID", tokenID);
            properties.put("Algorithm", algorithm);
            properties.put("Generation", generation);
            properties.put("Length", length);
            properties.put("Label", label);
            properties.put("Nonce", nonce);
            properties.put("KeyType", keyType);
            properties.put("SecurityTokenReference", tokenReference);
        }
        catch (Throwable t) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.unexpected.exception", (Object)KRB5Util.stackToString(t));
            throw new SoapSecurityException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
        return properties;
    }

    private static boolean isDerivedKeyReferecedInSignature(Node securityNode, String tokenID) {
        String methodName = "isDerivedKeyReferecedInSignature";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName);
        }
        boolean usedInSignature = false;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"tokenID of the derived key token : ", (Object)tokenID);
            }
            Element signatureElement = DOMUtil.getOneChildElement((Element)((Element)securityNode), (String)KRBConstants.STR_SIGNATURE_NS, (String)"Signature");
            Element keyInfoElement = DOMUtil.getOneChildElement((Element)signatureElement, (String)KRBConstants.STR_SIGNATURE_NS, (String)"KeyInfo");
            Element securityTokenReferenceElement = DOMUtil.getOneChildElement((Element)keyInfoElement, (String)KRBConstants.STR_WSSE_NS, (String)"SecurityTokenReference");
            Element referenceElement = DOMUtil.getOneChildElement((Element)securityTokenReferenceElement, (String)KRBConstants.STR_WSSE_NS, (String)"Reference");
            String URIValue = DOMUtil.getAttribute((Element)referenceElement, (String)"URI");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("URI used in signature :" + URIValue));
            }
            if (URIValue.equalsIgnoreCase("#" + tokenID)) {
                usedInSignature = true;
            }
        }
        catch (Throwable t) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.unexpected.exception", (Object)KRB5Util.stackToString(t));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Derived key use in signature : " + usedInSignature));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
        return usedInSignature;
    }

    public static boolean addDerivedkeyTokenToContext(MessageContext messageContext, KRBDerivedKeyToken derivedKeyToken) throws Throwable {
        boolean bContextUpdated = true;
        String methodName = "addDerivedkeyTokenToContext";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName);
        }
        if (messageContext == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"messageContext", methodName});
            return false;
        }
        if (derivedKeyToken == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"derivedKeyToken", methodName});
            return false;
        }
        String keyType = derivedKeyToken.getKeyType();
        if (keyType != null) {
            if ("SigningKey".equals(keyType)) {
                messageContext.setProperty("com.ibm.wsspi.wssecurity.derivedKeyToken.SigningKey", derivedKeyToken);
            } else if ("VerifyingKey".equals(keyType)) {
                messageContext.setProperty("com.ibm.wsspi.wssecurity.derivedKeyToken.VerifyingKey", derivedKeyToken);
            } else if ("EncryptingKey".equals(keyType)) {
                messageContext.setProperty("com.ibm.wsspi.wssecurity.derivedKeyToken.EncryptingKey", derivedKeyToken);
            } else if ("DecryptingKey".equals(keyType)) {
                messageContext.setProperty("com.ibm.wsspi.wssecurity.derivedKeyToken.DecryptingKey", derivedKeyToken);
            } else {
                bContextUpdated = false;
            }
        }
        if (bContextUpdated) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Message context is updated with derivedKeyToken.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Message context is not updated with derivedKeyToken.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
        return bContextUpdated;
    }

    private static byte[] getRandomKey(int byteLength) {
        String methodName = "getRandomKey";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName);
        }
        if (byteLength > 32 || byteLength < 0) {
            byteLength = 32;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Length can't be more than 32. It is set to 32.");
            }
        }
        byte[] randomKey = new byte[byteLength];
        try {
            UUID uuid1 = new UUID();
            UUID uuid2 = new UUID();
            int tempRandomkeyLength = uuid1.toByteArray().length + uuid2.toByteArray().length;
            byte[] tempRandomKey = new byte[tempRandomkeyLength];
            System.arraycopy(uuid1.toByteArray(), 0, tempRandomKey, 0, uuid1.toByteArray().length);
            System.arraycopy(uuid2.toByteArray(), 0, tempRandomKey, uuid1.toByteArray().length, uuid2.toByteArray().length);
            System.arraycopy(tempRandomKey, 0, randomKey, 0, byteLength);
        }
        catch (Throwable t) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.unexpected.exception", (Object)KRB5Util.stackToString(t));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
        return randomKey;
    }

    public static KRBDerivedKeyToken generateDerivedKeyTokenForResponse(KRBDerivedKeyToken derivedKeyTokenFromRequest) {
        String methodName = "generateDerivedKeyTokenForResponse";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName);
        }
        KRBDerivedKeyToken derivedKeyTokenForResponse = null;
        if (derivedKeyTokenFromRequest == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"derivedKeyTokenFromRequest", methodName});
            return derivedKeyTokenForResponse;
        }
        try {
            UUID uuid = new UUID();
            StringBuffer tokenID = new StringBuffer();
            tokenID.append("SecurityToken");
            tokenID.append("-" + uuid.toString());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Token Id for response : " + tokenID.toString()));
            }
            byte[] encodedNounce = Base64Coder.base64Encode(KRB5Util.getRandomKey(derivedKeyTokenFromRequest.getLength()));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Encoded nonce for response : " + KRB5Util.showHex(encodedNounce)));
            }
            HashMap<String, String> securityTokenReference = new HashMap<String, String>();
            securityTokenReference.put("EncodingType", KRBConstants.STR_BASE64_ENCODING);
            securityTokenReference.put("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1");
            String keyType = null;
            keyType = derivedKeyTokenFromRequest.getKeyType().equalsIgnoreCase("DecryptingKey") ? "EncryptingKey" : "SigningKey";
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("tokenID", tokenID.toString());
            properties.put("Algorithm", derivedKeyTokenFromRequest.getAlgorithm());
            properties.put("Generation", Integer.toString(derivedKeyTokenFromRequest.getGeneration()));
            properties.put("Length", Integer.toString(derivedKeyTokenFromRequest.getLength()));
            properties.put("Label", derivedKeyTokenFromRequest.getLabel());
            properties.put("Nonce", new String(encodedNounce));
            properties.put("KeyType", keyType);
            properties.put("SecurityTokenReference", securityTokenReference);
            properties.put("ValueType", derivedKeyTokenFromRequest.getType().toString());
            derivedKeyTokenForResponse = new KRBDerivedKeyToken(properties);
        }
        catch (Throwable t) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.unexpected.exception", (Object)KRB5Util.stackToString(t));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
        return derivedKeyTokenForResponse;
    }

    public static KRBDerivedKeyToken generateDerivedKeyTokenForRequest(String keyType, String valueType, String algorithm) {
        String methodName = "generateDerivedKeyTokenForRequest";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName);
        }
        if (keyType == null || keyType.length() == 0) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"keyType", methodName});
            return null;
        }
        KRBDerivedKeyToken derivedKeyTokenForRequest = null;
        int lengthForDerivedKeyToken = 0;
        String labelForDerivedKeyToken = "WS-SecureConversationWS-SecureConversation";
        String generationForDerivedKeyToken = Integer.toString(0);
        boolean isSig = false;
        try {
            if (keyType.equalsIgnoreCase("EncryptingKey")) {
                if (algorithm != null) {
                    lengthForDerivedKeyToken = KRB5Util.getMinimumSymmetricKeyLength(isSig, algorithm);
                }
            } else {
                lengthForDerivedKeyToken = 24;
            }
            UUID uuid = new UUID();
            StringBuffer tokenID = new StringBuffer();
            tokenID.append("SecurityToken");
            tokenID.append("-" + uuid.toString());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Token Id for request : " + tokenID.toString()));
            }
            byte[] encodedNounce = Base64Coder.base64Encode(KRB5Util.getRandomKey(lengthForDerivedKeyToken));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Encoded nonce for request : " + KRB5Util.showHex(encodedNounce)));
            }
            HashMap<String, String> securityTokenReference = new HashMap<String, String>();
            securityTokenReference.put("EncodingType", KRBConstants.STR_BASE64_ENCODING);
            securityTokenReference.put("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1");
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("tokenID", tokenID.toString());
            properties.put("Algorithm", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1");
            properties.put("Generation", generationForDerivedKeyToken);
            properties.put("Length", Integer.toString(lengthForDerivedKeyToken));
            properties.put("Label", labelForDerivedKeyToken);
            properties.put("Nonce", new String(encodedNounce));
            properties.put("KeyType", keyType);
            properties.put("SecurityTokenReference", securityTokenReference);
            properties.put("ValueType", valueType);
            derivedKeyTokenForRequest = new KRBDerivedKeyToken(properties);
        }
        catch (Throwable t) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.unexpected.exception", (Object)KRB5Util.stackToString(t));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
        return derivedKeyTokenForRequest;
    }

    public static HashMap consumeKerberosToken(Subject subject, byte[] krbTokenBytes, String valueType, KRBSPN spnObj) throws SoapSecurityException {
        String methodName = "consumeKerberosToken";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName);
        }
        HashMap<String, Object> krbTokenProperties = new HashMap<String, Object>();
        if (spnObj == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"spnObj", methodName});
            return krbTokenProperties;
        }
        String serviceName = spnObj.getServicePrincipalName();
        String kerberosRealm = spnObj.getKerberosRealm();
        if (subject == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"subject", methodName});
            return krbTokenProperties;
        }
        if (krbTokenBytes == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"krbTokenBytes", methodName});
            return krbTokenProperties;
        }
        if (valueType == null || valueType.equals("")) {
            valueType = "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ";
        }
        if (serviceName == null || serviceName.length() == 0) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"serviceName", methodName});
            return krbTokenProperties;
        }
        if (kerberosRealm == null || kerberosRealm.length() == 0) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"kerberosRealm", methodName});
            return krbTokenProperties;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("krbTokenBytes is [" + krbTokenBytes + "]."));
            Tr.debug((TraceComponent)tc, (String)("valueType is [" + valueType + "]."));
            Tr.debug((TraceComponent)tc, (String)("serviceName is [" + serviceName + "]."));
            Tr.debug((TraceComponent)tc, (String)("kerberosRealm is [" + kerberosRealm + "]."));
        }
        try {
            Credentials serverCreds = KRB5Util.getSPNList().getSPNCreds(spnObj);
            KerberosKey kerberosKey = KRB5Util.getServiceKerberosKey(serverCreds.getServiceKey(), serviceName);
            if (KRB5Util.addCredentialToSubject(subject, kerberosKey)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Subject is updated with kerberos key.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Subject is not updated with kerberos key.");
            }
            HashMap<String, Object> initMap = new HashMap<String, Object>();
            Integer wrapped = null;
            wrapped = valueType.equalsIgnoreCase("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ") || valueType.equalsIgnoreCase("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ@1510") || valueType.equalsIgnoreCase("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ@4120") ? new Integer(1) : new Integer(0);
            initMap.put("clientRealmName", kerberosRealm);
            initMap.put("serviceName", serviceName);
            initMap.put("serviceRealmName", kerberosRealm);
            initMap.put("wrapped", wrapped);
            initMap.put("subject", subject);
            initMap.put("decodedToken", krbTokenBytes);
            KerberosTokenConsumer ktc = new KerberosTokenConsumer();
            ktc.init(initMap);
            HashMap contextMap = new HashMap();
            ktc.invoke(contextMap);
            byte[] sessionSubKey = (byte[])contextMap.get("contextSubKeyBytes");
            HashMap ticketProperties = KRB5Util.getKerberosTicketProperties(krbTokenBytes, serverCreds);
            String clientName = (String)ticketProperties.get("WASPrincipal");
            String tokenExpiryTime = (String)ticketProperties.get("ExpiryTime");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The Raw SubKey Bytes =\n " + new HexDumpEncoder().encodeBuffer(sessionSubKey)));
                Tr.debug((TraceComponent)tc, (String)("The Client name = " + clientName));
                Tr.debug((TraceComponent)tc, (String)("The token expiry = " + tokenExpiryTime));
            }
            krbTokenProperties.put("KRBToken", krbTokenBytes);
            krbTokenProperties.put("WASPrincipal", clientName);
            krbTokenProperties.put("uniqueID", KRB5Util.getUniqueID(clientName, true));
            krbTokenProperties.put("KRBSubsessionKey", contextMap.get("contextSubKeyBytes"));
            krbTokenProperties.put("ExpiryTime", tokenExpiryTime);
            krbTokenProperties.put("ValueType", valueType);
            krbTokenProperties.put("com.ibm.wsspi.wssecurity.auth.SPNObj", spnObj);
        }
        catch (Throwable t) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.unexpected.exception", (Object)KRB5Util.stackToString(t));
            throw new SoapSecurityException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"consumeKerberosToken()");
        }
        return krbTokenProperties;
    }

    private static HashMap getKerberosTicketProperties(byte[] token, Credentials serverCreds) {
        String methodName = "getKerberosTokenExpiryTime";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName);
        }
        if (token == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"token", methodName});
            return null;
        }
        if (serverCreds == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"serverCreds", methodName});
            return null;
        }
        HashMap<String, String> ticketProperties = new HashMap<String, String>();
        try {
            byte[] temp1;
            APReq apreq = KRB5Util.getAPReq(token);
            Ticket ticket = apreq.getTicket();
            EncryptedData encPart = ticket.getEncryptedPart();
            boolean desKey = encPart.isDesEncType();
            int encodingType = encPart.getEType();
            byte[] temp = null;
            if (desKey) {
                temp1 = encPart.decrypt(serverCreds.getServiceKey(), 2);
                temp = encPart.reset(temp1, true);
            } else if (encodingType == 17) {
                temp1 = encPart.decrypt(serverCreds.getServiceKey(), 2);
                temp = encPart.reset(temp1, true);
            } else if (encodingType == 18) {
                temp1 = encPart.decrypt(serverCreds.getServiceKey(), 2);
                temp = encPart.reset(temp1, true);
            } else {
                try {
                    temp = encPart.decrypt(serverCreds.getServiceKey(), 2);
                }
                catch (KrbException exc) {
                    temp = encPart.decrypt(serverCreds.getServiceKey(), 8);
                }
            }
            EncTicketPart decTicket = new EncTicketPart(temp);
            ticketProperties.put("ExpiryTime", Long.toString(decTicket.getEndTime().getTime()));
            ticketProperties.put("WASPrincipal", decTicket.getClient().getName());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The kerberos ticket properties  = " + ticketProperties.toString()));
            }
        }
        catch (Throwable t) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.unexpected.exception", (Object)KRB5Util.stackToString(t));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
        return ticketProperties;
    }

    private static APReq getAPReq(byte[] token) {
        APReq apreq;
        String methodName;
        block12: {
            methodName = "getAPReq";
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getAPReq");
            }
            if (token == null) {
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"token", methodName});
                return null;
            }
            apreq = null;
            try {
                if (token[0] == 110) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Decoded an AP_REQ input token");
                    }
                    apreq = new APReq(token);
                    break block12;
                }
                if (token[0] == 96) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Decoded a GSS Wrapped input token");
                    }
                    ByteArrayInputStream inStream = new ByteArrayInputStream(token);
                    TokenHeader header = new TokenHeader((InputStream)inStream);
                    Oid mechOid = header.getMechanism();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("The Mechanism OID =\n" + mechOid.toString()));
                    }
                    if (!mechOid.equals(KerberosTokenConsumer.MECH_TYPE_KRB5) && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Kerberos mechanics not passed" + mechOid.toString()));
                    }
                    int mechTokenSize = header.getMechTokenLen();
                    byte[] buff = KRB5Util.stream2Bytes(inStream, mechTokenSize);
                    byte[] innerToken = new byte[mechTokenSize];
                    System.arraycopy(buff, 0, innerToken, 0, mechTokenSize);
                    byte[] tokenId = new byte[2];
                    System.arraycopy(innerToken, 0, tokenId, 0, 2);
                    int krbMsgLen = innerToken.length - 2;
                    byte[] krbMsg = new byte[krbMsgLen];
                    System.arraycopy(innerToken, 2, krbMsg, 0, krbMsgLen);
                    if (Arrays.equals(tokenId, AP_REQ_TOK_ID)) {
                        apreq = new APReq(krbMsg);
                        break block12;
                    }
                    throw new RuntimeException("GSS Token was not an APReq message");
                }
                throw new RuntimeException("Input Token not of type GSS_Kerberosv5_AP_REQ or Kerberosv5_AP_REQ");
            }
            catch (Throwable t) {
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.unexpected.exception", (Object)KRB5Util.stackToString(t));
                FFDCFilter.processException(t, KRB5Util.class.getName(), "1");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
        return apreq;
    }

    private static KerberosKey getServiceKerberosKey(EncryptionKey serviceKey, String servicePrincipal) {
        String methodName = "getServiceKerberosKey";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName);
        }
        KerberosKey kkey = null;
        try {
            if (serviceKey != null) {
                Integer kvno = serviceKey.getKeyVersionNumber();
                kkey = new KerberosKey(new KerberosPrincipal(servicePrincipal), serviceKey.getBytes(), serviceKey.getEType(), kvno != null ? kvno : 0);
            }
        }
        catch (Exception exc) {
            FFDCFilter.processException(exc, KRB5Util.class.getName(), "2");
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
        return kkey;
    }

    public static HashMap generateKerberosToken(Subject subject, String valueType, KRBSPN spnObj, String clientName, char[] clientPassword) {
        String methodName = "generateKerberosToken";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName);
        }
        HashMap<String, Object> krbTokenProperties = new HashMap<String, Object>();
        if (spnObj == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"spnObj", methodName});
            return krbTokenProperties;
        }
        String serviceName = spnObj.getServicePrincipalName();
        String kerberosRealm = spnObj.getKerberosRealm();
        if (valueType == null || valueType.equals("")) {
            valueType = "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ";
        }
        if (serviceName == null || serviceName.length() == 0) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"serviceName", methodName});
            return krbTokenProperties;
        }
        if (kerberosRealm == null || kerberosRealm.length() == 0) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"kerberosRealm", methodName});
            return krbTokenProperties;
        }
        if (clientName == null || clientName.length() == 0) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"clientName", methodName});
            return krbTokenProperties;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("valueType is [" + valueType + "]."));
            Tr.debug((TraceComponent)tc, (String)("serviceName is [" + serviceName + "]."));
            Tr.debug((TraceComponent)tc, (String)("kerberosRealm is [" + kerberosRealm + "]."));
            Tr.debug((TraceComponent)tc, (String)("clientName is [" + clientName + "]."));
            Tr.debug((TraceComponent)tc, (String)("Default password is [" + (clientPassword == null ? "null" : "XXXXXXXX") + "]."));
        }
        try {
            HashMap<String, Object> initMap = new HashMap<String, Object>();
            Integer wrapped = null;
            wrapped = valueType.equalsIgnoreCase("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ") || valueType.equalsIgnoreCase("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ@1510") || valueType.equalsIgnoreCase("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ@4120") ? new Integer(1) : new Integer(0);
            initMap.put("serviceRealmName", kerberosRealm);
            initMap.put("serviceName", serviceName);
            initMap.put("clientRealmName", kerberosRealm);
            initMap.put("clientName", clientName);
            boolean subjectHasPrincipal = true;
            if (subject != null && KRB5Util.isTGTInSubject(subject)) {
                initMap.put("subject", subject);
            } else {
                subjectHasPrincipal = false;
                initMap.put("clientLoginConfig", DEFAULT_JAAS_LOGIN_CONFIG);
                if (clientPassword != null) {
                    initMap.put("clientPassword", new String(clientPassword));
                }
            }
            initMap.put("wrapped", wrapped);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invoke Kerberos Token Generator");
            }
            final KerberosTokenGenerator ktg = new KerberosTokenGenerator();
            HashMap contextMap = new HashMap();
            if (ktg != null) {
                ktg.init(initMap);
                contextMap = (HashMap)AccessController.doPrivileged(new PrivilegedAction(){
                    HashMap contextMap = new HashMap();

                    public Object run() {
                        try {
                            ktg.invoke((Map)this.contextMap);
                        }
                        catch (Exception exc) {
                            FFDCFilter.processException(exc, KRB5Util.class.getName(), "3");
                        }
                        return this.contextMap;
                    }
                });
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Called KerberosTokenGenerator.invoke");
            }
            byte[] krbTokenBytes = null;
            krbTokenBytes = wrapped == 1 ? (byte[])contextMap.get("contextGSSToken") : (byte[])contextMap.get("contextAPReq");
            KerberosTicket creds = KRB5Util.getTGTInSubject(subject);
            String tokenExpiryTime = "";
            if (creds != null) {
                tokenExpiryTime = Long.toString(creds.getEndTime().getTime());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Client Generated Ticket Expiration Time [" + creds.getEndTime() + "]  [" + tokenExpiryTime + "]"));
                }
            }
            UUID uuid = new UUID();
            StringBuffer tokenID = new StringBuffer();
            tokenID.append("SecurityToken");
            tokenID.append("-" + uuid.toString());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Token Id for Kerberos token request : " + tokenID.toString()));
            }
            krbTokenProperties.put("tokenID", tokenID.toString());
            krbTokenProperties.put("KRBToken", krbTokenBytes);
            krbTokenProperties.put("WASPrincipal", clientName);
            krbTokenProperties.put("uniqueID", KRB5Util.getUniqueID(clientName, subjectHasPrincipal));
            krbTokenProperties.put("KRBSubsessionKey", contextMap.get("contextSubKeyBytes"));
            krbTokenProperties.put("ExpiryTime", tokenExpiryTime);
            krbTokenProperties.put("ValueType", valueType);
            krbTokenProperties.put("com.ibm.wsspi.wssecurity.auth.SPNObj", spnObj);
            if (_debug && tc.isDebugEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("J2EE Client Generated Token-localSubKey" + new HexDumpEncoder().encodeBuffer((byte[])contextMap.get("contextSubKeyBytes"))));
                }
                byte[] localSessionKey = (byte[])contextMap.get("contextSessionKeyBytes");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("J2EE Client Generated Token-localSessionKey" + new HexDumpEncoder().encodeBuffer(localSessionKey)));
                }
                Subject sub = (Subject)contextMap.get("contextSubject");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("J2EE Client Generated Token-Subject" + sub.toString()));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("KerberosTokenGenerator Token(Base64):" + new String(Base64Coder.base64Encode(krbTokenBytes))));
                }
            }
        }
        catch (Exception exc) {
            FFDCFilter.processException(exc, KRB5Util.class.getName(), "3");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
        return krbTokenProperties;
    }

    public static boolean addKerberosTokenInfoToContext(MessageContext messageContext, Element xmlSecurityElement, Subject subject, KRBSPN spnObj) throws SoapSecurityException {
        String methodName = "addKerberosTokenInfoToContext";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName);
        }
        boolean bContextUpdated = false;
        try {
            HashMap bstProperties = KRB5Util.consumeBinarySecurityToken(xmlSecurityElement);
            byte[] krbTokenBytes = (byte[])bstProperties.get("KRBToken");
            String tokenID = (String)bstProperties.get("tokenID");
            String valueType = (String)bstProperties.get("ValueType");
            HashMap krbTokenInfoProperties = KRB5Util.consumeKerberosToken(subject, krbTokenBytes, valueType, spnObj);
            krbTokenInfoProperties.put("tokenID", tokenID);
            KRBTokenInfo krbTokenInfo = new KRBTokenInfo(krbTokenInfoProperties);
            messageContext.setProperty("com.ibm.wsspi.wssecurity.kerberosTokenInfo", krbTokenInfo);
            bContextUpdated = true;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Message context is updated with kerberos token.");
            }
        }
        catch (SoapSecurityException sse) {
            throw sse;
        }
        catch (Throwable exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Message context is not updated with kerberos token.");
            }
            throw new SoapSecurityException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
        return bContextUpdated;
    }

    private static byte[] stream2Bytes(InputStream in, int len) throws GSSException {
        String methodName = "stream2Bytes";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName);
        }
        if (in == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"InputStream", methodName});
            return null;
        }
        byte[] buffer = new byte[len];
        int readLen = 0;
        try {
            readLen = in.read(buffer, 0, len);
        }
        catch (Exception exc) {
            I18NException.throwGSSException((int)10, (int)0, (String)"StreamReadError", (Object[])new String[]{exc.toString()});
        }
        if (readLen != len) {
            I18NException.throwGSSException((int)10, (int)0, (String)"StreamDataLenMismatch", (Object[])new Integer[]{new Integer(len), new Integer(readLen)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
        return buffer;
    }

    public static String getFormattedMessage(ResourceBundle nls, String key, Object[] args) {
        String message = null;
        try {
            message = nls.getString(key);
            if (message != null) {
                message = MessageFormat.format(message, args);
            }
        }
        catch (MissingResourceException e) {
            Tr.debug((TraceComponent)tc, (String)("Cannot find message key in resource bundle " + nls.toString()));
        }
        catch (NullPointerException npe) {
            Tr.debug((TraceComponent)tc, (String)("Null pointer exception caught trying to find message key " + key + " in resource bundle " + nls.toString()));
        }
        return message;
    }

    public static KRBSPNList getSPNList() {
        return servicePrincipalNameList;
    }

    public static String stripOutPrincipalName(String principalNameFQ) {
        int idx;
        String strippedPrincipal = principalNameFQ;
        if (principalNameFQ != null && (idx = principalNameFQ.indexOf(64)) > 0) {
            strippedPrincipal = principalNameFQ.substring(0, idx);
        }
        return strippedPrincipal;
    }

    public static String stripOutRealmName(String principalNameFQ) {
        int idx0;
        String kerberosRealm = "";
        if (principalNameFQ != null && (idx0 = principalNameFQ.indexOf(64)) > 0) {
            kerberosRealm = principalNameFQ.substring(idx0 + 1);
        }
        return kerberosRealm;
    }

    public static String getUniqueID(String was_principal, boolean subjectHasPrincipal) {
        String methodName = "getUniqueID";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName);
        }
        String uniqueID = "";
        if (was_principal == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.kerberos.invalid.parm", (Object)new Object[]{"was_principal", methodName});
            return "";
        }
        if (subjectHasPrincipal) {
            try {
                ContextManager manager = ContextManagerFactory.getInstance();
                UserRegistry reg = manager.getRegistry(manager.getDefaultRealm());
                if (reg != null) {
                    uniqueID = reg.getUniqueUserId(was_principal);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (uniqueID.equals("")) {
            uniqueID = String.valueOf(was_principal.hashCode());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("uniqueID: " + uniqueID));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueID()");
        }
        return uniqueID;
    }

    public static String getCurrentLoggedOnUser() {
        String userID;
        String methodName = "getCurrentLoggedOnUser";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName);
        }
        if ((userID = System.getProperty("user.name")) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to get the logged on userID.");
            }
            userID = "";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Logged on userID-" + userID));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
        return userID;
    }

    public static final int getMinimumSymmetricKeyLength(boolean sig, String algorithm) {
        int iKeyLeng;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getMinimumSymmetricKeyLength(boolean sig [");
            buf.append(sig).append("], String algorithm [").append(algorithm).append("])");
            Tr.entry((TraceComponent)tc, (String)buf.toString());
        }
        int iMinLeng = KRB5Util.getKeyLength(algorithm);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Minimum Dervived Key Length for " + algorithm + " is " + iMinLeng));
        }
        if ((iKeyLeng = iMinLeng) == 16 && sig) {
            iKeyLeng = 20;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("The resulted Derived Key Length is " + iKeyLeng));
        }
        return iKeyLeng;
    }

    public static final int getKeyLength(String algorithm) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getKeyLength(String) " + algorithm));
        }
        int keylength = 0;
        if (TRIPLEDES_CBC.equals(algorithm)) {
            keylength = 24;
        } else if (AES128_CBC.equals(algorithm)) {
            keylength = 16;
        } else if (AES192_CBC.equals(algorithm)) {
            keylength = 24;
        } else if (AES256_CBC.equals(algorithm)) {
            keylength = 32;
        } else if (HMAC.equals(algorithm)) {
            keylength = 20;
        } else if (DSA.equals(algorithm)) {
            keylength = 20;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKeyLength(String) returns " + keylength));
        }
        return keylength;
    }

    public static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        return sw.getBuffer().toString();
    }

    static {
        AP_REQ_TOK_ID = new byte[]{1, 0};
        _debug = false;
        servicePrincipalNameList = new KRBSPNList();
        nls = null;
        tc = Tr.register(KRB5Util.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    }
}

