/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.ElementSelector;
import com.ibm.ws.webservices.wssecurity.core.RequestMessagePool;
import com.ibm.ws.webservices.wssecurity.core.WSSGenerator;
import com.ibm.ws.webservices.wssecurity.enc.PartList;
import com.ibm.ws.webservices.wssecurity.time.TimestampRequest;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import com.ibm.xml.soapsec.Request;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Duration;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Map;
import java.util.Set;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IntegralDialectElementSelector
implements ElementSelector {
    private static final TraceComponent tc = Tr.register(IntegralDialectElementSelector.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = IntegralDialectElementSelector.class.getName();
    public static final String TIMESTAMP_DURATION = "security.wssecurity.integraldialectelementselector.duration";
    public static final String KEYSIGN_TYPE = "security.wssecurity.integraldialectelementselector.keysigntype";
    public static final String EXIST_STRTRANSFORM = "security.wssecurity.integraldialectelementselector.existstrtransform";
    public static final int BODY = 0;
    public static final int TIMESTAMP = 1;
    public static final int SECURITYTOKEN = 2;
    public static final int DSIGKEY = 3;
    public static final int ENCKEY = 4;
    public static final int MESSAGEID = 5;
    public static final int TO = 6;
    public static final int ACTION = 7;
    public static final int RELATESTO = 8;
    public static final int WSCONTEXT = 9;
    public static final int WSA_FROM = 10;
    public static final int WSA_REPLYTO = 11;
    public static final int WSA_FAULTTO = 12;
    public static final int WSA_ALL = 13;
    public static final String[] WASDIALECTS = new String[]{"body".intern(), "timestamp".intern(), "securitytoken".intern(), "dsigkey".intern(), "enckey".intern(), "messageid".intern(), "to".intern(), "action".intern(), "relatesto".intern(), "wscontext".intern(), "wsafrom".intern(), "wsareplyto".intern(), "wsafaultto".intern(), "wsaall".intern()};
    private static final String[] WSAELEMENTS = new String[]{"MessageID".intern(), "To".intern(), "Action".intern(), "RelatesTo".intern(), "From".intern(), "ReplyTo".intern(), "FaultTo".intern()};
    public static final int KS_KEYINFO = 0;
    public static final int KS_CHILDELEMENT = 1;
    public static final String[] KEYSIGNMETHOD = new String[]{"keyinfo", "keyinfochildelements"};

    public void init(Map properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map properties)");
        }
    }

    public NodeList getElements(Node node, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getElements(Node node[" + DOMUtil.getDisplayName((Node)node) + "]," + "Map context)"));
        }
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s02");
        }
        if (!(node instanceof Document)) {
            throw SoapSecurityException.format("security.wssecurity.IntegralDialectElementSelector.s01", node.getClass().getName(), Document.class.getName());
        }
        String dialect = (String)context.get("com.ibm.ws.webservices.wssecurity.util.selector.dialect");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Dialect [" + dialect + "]"));
        }
        if (dialect == null) {
            throw SoapSecurityException.format("Null is not allowed as the WAS dialect");
        }
        if (!Constants.DIALECT_WAS.equals(dialect)) {
            throw SoapSecurityException.format(clsName + " does not allow the dialect: " + dialect + ".");
        }
        String keyword = (String)context.get("com.ibm.ws.webservices.wssecurity.util.selector.keyword");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Keyword [" + keyword + "]"));
        }
        if (keyword == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s03");
        }
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.util.selector.operation");
        boolean signature = "signature_mode".equals((String)obj);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Mode [" + obj + "]"));
        }
        String processType = (String)context.get("com.ibm.ws.webservices.wssecurity.util.selector.processType");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Process type [" + processType + "]"));
        }
        Object[] elements = (Object[])context.get("com.ibm.ws.webservices.wssecurity.util.selector.element");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Elements [" + elements + "]"));
        }
        Set configs = (Set)context.get("com.ibm.ws.webservices.wssecurity.util.selector.config");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Token generator configs [" + configs + "]"));
        }
        String keySignType = (String)context.get(KEYSIGN_TYPE);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The type of signing key [" + keySignType + "]"));
        }
        boolean existSTRTransform = ConfigUtil.isTrue((String)((String)context.get(EXIST_STRTRANSFORM)));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("STR-Transform exists [" + existSTRTransform + "]"));
        }
        IDResolver idResolver = (IDResolver)context.get("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ID resolver [" + idResolver + "]"));
        }
        Duration duration = (Duration)context.get(TIMESTAMP_DURATION);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Duration [" + duration + "]"));
        }
        NonceManager nonceManager = (NonceManager)context.get(NonceManager.class);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Nonce manager [" + nonceManager + "]"));
        }
        obj = context.get("com.ibm.ws.webservices.wssecurity.constants.soapVersion");
        int version = 0;
        if (obj != null && obj instanceof Integer) {
            version = (Integer)obj;
        }
        String nsSoap = Constants.NAMESPACES[2][version];
        obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        version = 0;
        if (obj != null && obj instanceof Integer) {
            version = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][version];
        String nsWsu = Constants.NAMESPACES[1][version];
        Document doc = (Document)node;
        Element el = doc.getDocumentElement();
        Object list = null;
        if (WASDIALECTS[0].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[0] + "]"));
            }
            list = new XPathCanonicalizer.NodeListImpl();
            Object body = null;
            try {
                body = el instanceof SOAPEnvelope ? ((SOAPEnvelope)el).getBody() : DOMUtil.getOneChildElement((Element)el, (String)nsSoap, (String)"Body");
            }
            catch (SOAPException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception from SOAPEnvelope.getBody()" + (Object)((Object)e)));
                }
                FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".getElements", "273", this);
                throw new SoapSecurityException(e);
            }
            list.add((Node)body);
        } else if (WASDIALECTS[1].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[1] + "]"));
            }
            list = signature ? IntegralDialectElementSelector.getTimestampForSignature(context) : IntegralDialectElementSelector.getTimestampForVerification(el, nsWsu, context);
        } else if (WASDIALECTS[2].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[2] + "]"));
            }
            list = null;
            list = signature ? IntegralDialectElementSelector.getTokensForSignature(configs, context) : IntegralDialectElementSelector.getTokensForVerification(configs, context);
        } else if (WASDIALECTS[3].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[3] + "]"));
            }
            list = IntegralDialectElementSelector.getDsigKeyObjects(doc, context, keySignType, existSTRTransform, idResolver, nsWsse);
        } else if (WASDIALECTS[4].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[4] + "]"));
            }
            list = IntegralDialectElementSelector.getEncKeyObjects(doc, context, keySignType, existSTRTransform, idResolver, nsWsse);
        } else if (WASDIALECTS[5].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[5] + "]"));
            }
            list = this.getWSAElement(context, doc, "MessageID");
        } else if (WASDIALECTS[6].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[6] + "]"));
            }
            list = this.getWSAElement(context, doc, "To");
        } else if (WASDIALECTS[7].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[7] + "]"));
            }
            list = this.getWSAElement(context, doc, "Action");
        } else if (WASDIALECTS[8].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[8] + "]"));
            }
            list = this.getWSAElement(context, doc, "RelatesTo");
        } else if (WASDIALECTS[9].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[9] + "]"));
            }
            list = IntegralDialectElementSelector.getWSContextHeaderElement(doc);
        } else if (WASDIALECTS[10].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[10] + "]"));
            }
            list = this.getWSAElement(context, doc, "From");
        } else if (WASDIALECTS[11].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[11] + "]"));
            }
            list = this.getWSAElement(context, doc, "ReplyTo");
        } else if (WASDIALECTS[12].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[12] + "]"));
            }
            list = this.getWSAElement(context, doc, "FaultTo");
        } else if (WASDIALECTS[13].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[13] + "]"));
            }
            list = this.getWSAAllElements(context, doc);
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s03", keyword);
        }
        if (processType != null && signature) {
            list = IntegralDialectElementSelector.postprocess(doc, processType, (NodeList)list, elements, duration, nsWsse, nsWsu, nonceManager, signature, false, dialect, keyword);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getElements(Node node,Map context)");
        }
        return list;
    }

    public static NodeList postprocess(Document doc, String type, NodeList list, Object[] elements, Duration duration, String nsWsse, String nsWsu, NonceManager nmanager, boolean signature, boolean encryption, String dialect, String keyword) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("postprocess(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "String type[" + type + "]," + "NodeList list[" + list + "]," + "Object[] elements[" + elements + "]," + "Duration duration[" + duration + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "]," + "NoceManager nmanager[" + nmanager + "])," + "boolean signature[" + signature + "]," + "boolean encryption[" + encryption + "]," + "String dialect[" + dialect + "])," + "String keyword[" + keyword + "])"));
        }
        if (list.getLength() == 0) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s14", dialect, keyword);
        }
        Object rlist = new XPathCanonicalizer.NodeListImpl();
        String extType = encryption ? "weenc" : "wedsig";
        for (int i = 0; i < list.getLength(); ++i) {
            Element el1 = null;
            Element el2 = (Element)list.item(i);
            if ("timestamp".equals(type)) {
                el1 = NonceUtil.getTimestamp(el2, nsWsu);
                if (el1 == null) {
                    el1 = NonceUtil.createTimestamp(doc, el2, nsWsu, extType);
                    NonceUtil.addCreated(doc, el1, nsWsu);
                    if (duration != null) {
                        NonceUtil.addExpires(doc, el1, duration, nsWsu);
                    }
                }
            } else if ("nonce".equals(type) && (el1 = NonceUtil.getNonce(el2, nsWsse)) == null) {
                el1 = NonceUtil.createNonce(doc, el2, nsWsse, nmanager, extType);
            }
            if (elements == null) continue;
            boolean found = false;
            for (int j = 0; j < elements.length; ++j) {
                if (!DOMUtil.equals((Node)((Node)elements[j]), (Node)el2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Added the element [" + DOMUtil.getDisplayName((Node)el2) + "]"));
            }
            rlist.add((Node)el2);
        }
        if (encryption) {
            rlist = new PartList("http://www.w3.org/2001/04/xmlenc#Element", (NodeList)rlist);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("postprocess(Document doc,String type,NodeList list,Object[] elements,Duration duration,String nsWsse,String nsWsu,NoceManager nmanager,boolean signature,boolean encryption,String dialect,String keyword) returns NodeList[" + rlist + "]"));
        }
        return rlist;
    }

    private static NodeList getTimestampForSignature(Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTimestmapForSignature(Map context)");
        }
        XPathCanonicalizer.NodeListImpl list = new XPathCanonicalizer.NodeListImpl();
        Request[] requests = RequestPool.get((Map)context, TimestampRequest.class);
        if (requests != null && requests.length > 0) {
            for (int i = 0; i < requests.length; ++i) {
                RequestMessagePool.EncryptedObject eobj;
                TimestampRequest trequest = (TimestampRequest)requests[i];
                if (!trequest.isSigned()) continue;
                Element el = trequest.getElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Added the element [" + DOMUtil.getDisplayName((Node)el) + "]."));
                }
                if ((eobj = RequestMessagePool.convertElement(context, el, -1)) == null) {
                    list.add((Node)el);
                    continue;
                }
                if (eobj.getEncryptedData() != null) {
                    list.add((Node)eobj.getEncryptedData());
                }
                if (eobj.getHeaderInfo() == null) continue;
                list.add((Node)eobj.getHeaderInfo());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTimestmapForSignature(Map context)");
        }
        return list;
    }

    private static NodeList getTimestampForVerification(Element root, String nsWsu, Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getTimestmapForVerification(Element root[" + DOMUtil.getDisplayName((Node)root) + "]," + "String nsWsu[" + nsWsu + "]," + "Map context)"));
        }
        XPathCanonicalizer.NodeListImpl rlist = new XPathCanonicalizer.NodeListImpl();
        NodeList list = root.getElementsByTagNameNS(nsWsu, "Timestamp");
        if (list != null && list.getLength() > 0) {
            for (int i = 0; i < list.getLength(); ++i) {
                Element el = (Element)list.item(i);
                if (el.hasAttribute("wasextention")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Added the timestamp element without WAS extention [" + el + "]"));
                }
                rlist.add((Node)el);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTimestmapForVerification(Element root,String nsWsu,Map context) returns NodeList[" + rlist + "]"));
        }
        return rlist;
    }

    private static NodeList getTokensForSignature(Set configs, Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getTokensForSignature(Set configs[" + configs + "]," + "Map context)"));
        }
        XPathCanonicalizer.NodeListImpl list = new XPathCanonicalizer.NodeListImpl();
        Set tokens = TokenManager.getTokens(context);
        for (TokenGeneratorConfig config : configs) {
            if (!config.isStandAlone()) continue;
            for (Token token : tokens) {
                Element telem;
                RequestMessagePool.EncryptedObject eobj;
                if (!config.equals(token.getUsedTokenGenerator()) || token.isReferenced()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Added the token element [" + token.getElement() + "]"));
                }
                if ((eobj = RequestMessagePool.convertElement(context, telem = token.getElement(), -1)) == null) {
                    list.add((Node)telem);
                    continue;
                }
                if (eobj.getEncryptedData() != null) {
                    list.add((Node)eobj.getEncryptedData());
                }
                if (eobj.getHeaderInfo() == null) continue;
                list.add((Node)eobj.getHeaderInfo());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTokensForSignature(Set configs,Map context) returns NodeList[" + list + "]"));
        }
        return list;
    }

    private static NodeList getTokensForVerification(Set configs, Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getTokensForVerification(Set configs[" + configs + "]," + "Map context)"));
        }
        XPathCanonicalizer.NodeListImpl list = new XPathCanonicalizer.NodeListImpl();
        if (configs != null) {
            Set tokens = TokenManager.getTokens(context);
            for (TokenConsumerConfig config : configs) {
                if (config.isUsedForVerification() || config.isUsedForDecryption()) continue;
                for (Token token : tokens) {
                    if (!config.equals(token.getUsedTokenConsumer()) || token.isReferenced()) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Added the token element [" + token.getElement() + "]"));
                    }
                    list.add((Node)token.getElement());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTokensForVerification(Set configs,Map context) returns NodeList[" + list + "]"));
        }
        return list;
    }

    public static NodeList getHeaderElement(Document doc, String ns, String ln) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getHeaderElement(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "String ns[" + ns + "]," + "String ln[" + ln + "])"));
        }
        NodeList list = null;
        Element header = WSSGenerator.getHeader(doc, false);
        if (header != null) {
            list = header.getElementsByTagNameNS(ns, ln);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getHeaderElement(Document doc,String ns,String ln) returns NodeList[" + list + "]"));
        }
        return list;
    }

    private static NodeList getDsigKeyObjects(Document doc, Map context, String keyInfoType, boolean existSTRTransform, IDResolver idResolver, String nsWsse) throws SoapSecurityException {
        NodeList nl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getDsigKeyObjects(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Map context," + "String keyInfoType[" + keyInfoType + "]," + "boolean existSTRTransform[" + existSTRTransform + "]," + "IDResolver idResolver[" + idResolver + "]," + "String nsWsse[" + nsWsse + "])"));
        }
        XPathCanonicalizer.NodeListImpl list = new XPathCanonicalizer.NodeListImpl();
        Element security2 = IntegralDialectElementSelector.getSecurityHeader(context, doc);
        if (security2 != null && (nl = DOMUtil.getChildElements((Element)security2, (String)Constants.NS_DSIG, (String)"Signature")) != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                NodeList nl2 = IntegralDialectElementSelector.getKeyObjects(doc, (Element)nl.item(i), keyInfoType, existSTRTransform, idResolver, nsWsse);
                if (nl2.getLength() <= 0) continue;
                for (int j = 0; j < nl2.getLength(); ++j) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Added the key objects in the Signature element [" + DOMUtil.getDisplayName((Node)nl2.item(j)) + "]"));
                    }
                    list.add((Node)((Element)nl2.item(j)));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getDsigKeyObjects(Document doc,Map context,String keyInfoType,boolean existSTRTransform,IDResolver idResolver,String nsWsse) returns NodeList[" + list + "]"));
        }
        return list;
    }

    private static NodeList getEncKeyObjects(Document doc, Map context, String keyInfoType, boolean existSTRTransform, IDResolver idResolver, String nsWsse) throws SoapSecurityException {
        int j;
        NodeList nl2;
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEncKeyObjects(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Map context," + "String keyInfoType[" + keyInfoType + "]," + "boolean existSTRTransform[" + existSTRTransform + "]," + "IDResolver idResolver[" + idResolver + "]," + "String nsWsse[" + nsWsse + "])"));
        }
        XPathCanonicalizer.NodeListImpl list = new XPathCanonicalizer.NodeListImpl();
        Element security2 = IntegralDialectElementSelector.getSecurityHeader(context, doc);
        NodeList nl = null;
        if (security2 != null && (nl = DOMUtil.getChildElements((Element)security2, (String)Constants.NS_ENC, (String)"EncryptedKey")) != null && nl.getLength() > 0) {
            for (i = 0; i < nl.getLength(); ++i) {
                nl2 = IntegralDialectElementSelector.getKeyObjects(doc, (Element)nl.item(i), keyInfoType, existSTRTransform, idResolver, nsWsse);
                if (nl2.getLength() <= 0) continue;
                for (j = 0; j < nl2.getLength(); ++j) {
                    list.add((Node)((Element)nl2.item(j)));
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Added the key objects in the EncryptedKey element [" + DOMUtil.getDisplayName((Node)nl2.item(j)) + "]"));
                }
            }
        }
        if ((nl = doc.getElementsByTagNameNS(Constants.NS_ENC, "EncryptedData")) != null && nl.getLength() > 0) {
            for (i = 0; i < nl.getLength(); ++i) {
                nl2 = IntegralDialectElementSelector.getKeyObjects(doc, (Element)nl.item(i), keyInfoType, existSTRTransform, idResolver, nsWsse);
                if (nl2.getLength() <= 0) continue;
                for (j = 0; j < nl2.getLength(); ++j) {
                    list.add((Node)((Element)nl2.item(j)));
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Added the key objects in the EncryptedData element [" + DOMUtil.getDisplayName((Node)nl2.item(j)) + "]"));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEncKeyObjects(Document doc,Map context,String keyInfoType,boolean existSTRTransform,IDResolver idResolver,String nsWsse) returns NodeList[" + list + "]"));
        }
        return list;
    }

    private static NodeList getKeyObjects(Document doc, Element parent, String keyInfoType, boolean existSTRTransform, IDResolver idResolver, String nsWsse) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getKeyObjects(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "String keyInfoType[" + keyInfoType + "]," + "boolean existSTRTransform[" + existSTRTransform + "]," + "IDResolver idResolver[" + idResolver + "]," + "String nsWsse[" + nsWsse + "])"));
        }
        XPathCanonicalizer.NodeListImpl list = new XPathCanonicalizer.NodeListImpl();
        Element keyinfo = DOMUtil.getZeroOrOneElement((Element)parent, (String)Constants.NS_DSIG, (String)"KeyInfo");
        if (keyinfo != null) {
            String uri;
            Element el;
            if (KEYSIGNMETHOD[1].equals(keyInfoType)) {
                el = DOMUtil.getFirstElement((Node)keyinfo);
                while (el != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Added the element in the KeyInfo element [" + DOMUtil.getDisplayName((Node)el) + "]"));
                    }
                    list.add((Node)el);
                    el = DOMUtil.getNextElement((Node)el);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Added the element in the KeyInfo element [" + DOMUtil.getDisplayName((Node)keyinfo) + "]"));
                }
                list.add((Node)keyinfo);
            }
            if (!existSTRTransform && (el = DOMUtil.getFirstElement((Node)keyinfo, (String)nsWsse, (String)"SecurityTokenReference")) != null && (el = DOMUtil.getFirstElement((Node)el, (String)nsWsse, (String)"Reference")) != null && (uri = el.getAttribute("URI")) != null) {
                if (uri.length() < 2 || uri.charAt(0) != '#') {
                    throw new RuntimeException("Unsupported type of URI: " + uri);
                }
                el = idResolver.resolveID(doc, uri.substring(1));
                if (el != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Added the referenced element [" + DOMUtil.getDisplayName((Node)el) + "]"));
                    }
                    list.add((Node)el);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKeyObjects(Document doc,Element parent,String keyInfoType,boolean existSTRTransform,IDResolver idResolver,String nsWsse) returns NodeList[" + list + "]"));
        }
        return list;
    }

    static NodeList getWSContextHeaderElement(Document doc) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getWSContextHeaderElement(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "])"));
        }
        NodeList list = null;
        Element header = WSSGenerator.getHeader(doc, false);
        if (header != null) {
            list = DOMUtil.getChildElements((Element)header, (String)Constants.NS_WSCTX_V1, (String)"Context");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getWSContextHeaderElement(Document doc) returns NodeList[" + list + "]"));
        }
        return list;
    }

    private final NodeList getWSAElement(Map context, Document doc, String elementName) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getWSAElement(Map context, Node node[" + DOMUtil.getDisplayName((Node)doc) + "], String [" + elementName + "])"));
        }
        NodeList list = null;
        boolean bGenerator = IntegralDialectElementSelector.isGenerator(context);
        SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        if (messageContext == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
        }
        Element header = WSSGenerator.getHeader(doc, false);
        if (header != null) {
            if (bGenerator) {
                String ns;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getting the element for [" + elementName + "] for generator"));
                }
                if ((ns = (String)messageContext.getProperty("com.ibm.wsspi.wsaddressing.OutboundNamespace")) == null || ns.length() == 0) {
                    ns = Constants.NS_WSADDRS[0];
                    Tr.info((TraceComponent)tc, (String)"security.wssecurity.WSEC6732I", (Object)new String[]{ns});
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("No outbound namespace defined for WS-Address, default [" + ns + "] is used."));
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Namespace for WS-Addressing outbound request [" + ns + "]."));
                }
                list = DOMUtil.getChildElements((Element)header, (String)ns, (String)elementName);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getting the element for [" + elementName + "] for consumer"));
                }
                boolean found = false;
                String tmp = null;
                for (int i = 0; i < Constants.NS_WSADDRS.length; ++i) {
                    list = DOMUtil.getChildElements((Element)header, (String)Constants.NS_WSADDRS[i], (String)elementName);
                    if (list == null || list.getLength() == 0) continue;
                    tmp = Constants.NS_WSADDRS[i];
                    found = true;
                    break;
                }
                if (found) {
                    String ns = (String)messageContext.getProperty("com.ibm.ws.wsaddressing.InboundNamespace");
                    if (ns == null || ns.length() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("No inbound WS-Addressing namespace is set, setting it to [" + tmp + "]."));
                        }
                        messageContext.setProperty("com.ibm.ws.wsaddressing.InboundNamespace", tmp);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Inbound WS-Addressing namespace was set to [" + ns + "] and namespace found [" + tmp + "]."));
                        }
                        if (!ns.equals(tmp)) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"getWSAElement(Map context, Document doc, String elementName)");
                            }
                            throw SoapSecurityException.format("security.wssecurity.WSEC6733E");
                        }
                    }
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No SOAP header");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getWSAElement(Map context, Document doc, String elementName) returns " + this.toString(list)));
        }
        return list;
    }

    private final NodeList getWSAAllElements(Map context, Document doc) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getWSAAllElements(Map context, Node node[" + DOMUtil.getDisplayName((Node)doc) + "])"));
        }
        boolean bGenerator = IntegralDialectElementSelector.isGenerator(context);
        Object list = new XPathCanonicalizer.NodeListImpl();
        SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        if (messageContext == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
        }
        Element header = WSSGenerator.getHeader(doc, false);
        if (header != null) {
            if (bGenerator) {
                String ns;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getting all WSA elements for generator");
                }
                if ((ns = (String)messageContext.getProperty("com.ibm.wsspi.wsaddressing.OutboundNamespace")) == null || ns.length() == 0) {
                    ns = Constants.NS_WSADDRS[0];
                    Tr.info((TraceComponent)tc, (String)"security.wssecurity.WSEC6732I", (Object)new String[]{ns});
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("No outbound namespace defined for WS-Address, default [" + ns + "] is used."));
                    }
                }
                list = this.getWSAAllElements(header, ns, WSAELEMENTS);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getting all WSA elements for consumer");
                }
                boolean found = false;
                String tmp = null;
                for (int i = 0; i < Constants.NS_WSADDRS.length; ++i) {
                    list = this.getWSAAllElements(header, Constants.NS_WSADDRS[i], WSAELEMENTS);
                    if (list == null || list.getLength() == 0) continue;
                    tmp = Constants.NS_WSADDRS[i];
                    found = true;
                    break;
                }
                if (found) {
                    String ns = (String)messageContext.getProperty("com.ibm.ws.wsaddressing.InboundNamespace");
                    if (ns == null || ns.length() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("No inbound WS-Addressing namespace is set, setting it to [" + tmp + "]."));
                        }
                        messageContext.setProperty("com.ibm.ws.wsaddressing.InboundNamespace", tmp);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Inbound WS-Addressing namespace was set to [" + ns + "] and namespace found [" + tmp + "]."));
                        }
                        if (!ns.equals(tmp)) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"getWSAElement(Map context, Document doc, String elementName)");
                            }
                            throw SoapSecurityException.format("security.wssecurity.WSEC6733E");
                        }
                    }
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No SOAP header");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getWSAAllElements(Map context, Document doc) returns " + this.toString((NodeList)list)));
        }
        return list;
    }

    private final NodeList getWSAAllElements(Node parent, String ns, String[] elements) {
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getWSAAllElements(Node parent, String [" + ns + "], String[] [" + this.toString(elements) + "])"));
        }
        XPathCanonicalizer.NodeListImpl list = new XPathCanonicalizer.NodeListImpl();
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            for (int i = 0; i < elements.length; ++i) {
                if (node.getNodeType() != 1 || !DOMUtil.equals((Node)node, (String)ns, (String)elements[i])) continue;
                list.add(node);
            }
        }
        return list;
    }

    protected static final Element getSecurityHeader(Map context, Document doc) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getSecurityHeader(Map context, Document doc[" + DOMUtil.getDisplayName((Node)doc) + "])"));
        }
        boolean bGenerator = IntegralDialectElementSelector.isGenerator(context);
        String actor = null;
        if (bGenerator) {
            WSSGeneratorConfig gconfig = (WSSGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
            if (gconfig != null) {
                actor = gconfig.getTargetActor();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got generator actor " + actor));
            }
        } else {
            WSSConsumerConfig cconfig = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
            if (cconfig != null) {
                actor = cconfig.getMyActor();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got consumer actor " + actor));
            }
        }
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.soapVersion");
        int soapVersion = 0;
        if (obj != null && obj instanceof Integer) {
            soapVersion = (Integer)obj;
        }
        obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        Element header = WSSGenerator.getHeader(doc, false);
        Element security2 = WSSGenerator.getSecurityHeader(header, soapVersion, wssVersion, actor, false);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSecurityHeader(Map context, Document doc) returns " + security2));
        }
        return security2;
    }

    private final String toString(Object[] array) {
        if (array == null || array.length == 0) {
            return "{}";
        }
        StringBuffer buf = new StringBuffer("{");
        for (int i = 0; i < array.length; ++i) {
            buf.append(array[i]).append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    private static final boolean isGenerator(Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isGenerator(Map context)");
        }
        boolean bGenerator = false;
        boolean bConsumer = false;
        Object obj = context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        if (obj != null) {
            bGenerator = true;
        }
        if ((obj = context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey")) != null) {
            bConsumer = true;
        }
        if (bGenerator && bConsumer || !bGenerator && !bConsumer) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not determine generator or consumer");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isGenerator(Map context)");
            }
            throw SoapSecurityException.format("security.wssecurity.WSEC6734E");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isGenerator(Map context) returns " + bGenerator));
        }
        return bGenerator;
    }

    private final String toString(NodeList list) {
        if (list == null || list.getLength() == 0) {
            return "<empty>";
        }
        StringBuffer buf = new StringBuffer("[ ");
        for (int i = 0; i < list.getLength(); ++i) {
            buf.append(DOMUtil.toString((Node)list.item(i))).append(", ");
        }
        buf.append(" ]");
        return buf.toString();
    }
}

