/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.webservices.engine.MessageContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.GeneralSecurityException;
import java.security.Permission;
import java.util.HashMap;
import javax.security.auth.Subject;
import org.omg.Security.InvalidCredentialType;
import org.omg.SecurityLevel2.InvalidCredential;

public final class CORBAHelper {
    private static final HashMap originalCallerSubject = new HashMap();
    private static final HashMap originalInvocationSubject = new HashMap();
    private static final TraceComponent tc = Tr.register(CORBAHelper.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String FFDC_SOURCE_ID = "com.ibm.ws.webservices.wssecurity.util.CORBAHelper";
    private static final Permission MAP_CREDENTIAL = new WebSphereRuntimePermission("wssecurity.mapCredential");

    public static boolean isSecurityEnabled() {
        return ContextManagerFactory.getInstance().isCellSecurityEnabled();
    }

    public static synchronized void pushCredential(Subject subject, MessageContext ctx) throws InvalidCredentialType, InvalidCredential {
        ContextManager contextManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pushCredential(" + subject + ", " + ctx + ")");
        }
        if ((contextManager = ContextManagerFactory.getInstance()) != null && contextManager.isCellSecurityEnabled()) {
            try {
                Subject origInvocationSubj = contextManager.getInvocationSubject();
                Subject origCallerSubj = contextManager.getCallerSubject();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Original Caller Subject", origCallerSubj);
                    Tr.debug(tc, "Original Invocation Subject", origInvocationSubj);
                    Tr.debug(tc, "Replace Caller and Invocation Subjects with", subject);
                }
                contextManager.setInvocationSubject(subject);
                contextManager.setCallerSubject(subject);
                originalInvocationSubject.put(ctx, origInvocationSubj);
                originalCallerSubject.put(ctx, origCallerSubj);
            }
            catch (WSSecurityException e) {
                FFDCFilter.processException(e, CORBAHelper.class.getName() + ".pushCredential()", "143");
                if (tc.isDebugEnabled()) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    Tr.debug(tc, "Exception in set Caller/Invocation Subject" + sw.toString());
                }
                throw new InvalidCredential();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pushCredential()");
        }
    }

    public static synchronized void popCredential(MessageContext ctx) throws InvalidCredentialType, InvalidCredential {
        ContextManager contextManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "popCredential(" + ctx + ")");
        }
        if ((contextManager = ContextManagerFactory.getInstance()) != null && contextManager.isCellSecurityEnabled()) {
            Subject callerSubject = (Subject)originalCallerSubject.remove(ctx);
            Subject invocationSubject = (Subject)originalInvocationSubject.remove(ctx);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Original caller subject", callerSubject);
                Tr.debug(tc, "Original Invocation Subject", invocationSubject);
            }
            try {
                contextManager.setCallerSubject(callerSubject);
                contextManager.setInvocationSubject(invocationSubject);
            }
            catch (WSSecurityException e) {
                FFDCFilter.processException(e, CORBAHelper.class.getName() + ".pushCredential()", "176");
                if (tc.isDebugEnabled()) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    Tr.debug(tc, "Exception in set Caller/Invocation Subject" + sw.toString());
                }
                throw new InvalidCredential();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "popCredential()");
        }
    }

    public static String getSecurityName() {
        String securityName;
        block18: {
            ContextManager contextManager;
            WSCredential cred;
            block17: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getSecurityName()");
                }
                securityName = null;
                cred = null;
                contextManager = ContextManagerFactory.getInstance();
                try {
                    cred = contextManager.getInvocationCredential();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invocation creds = " + (cred == null ? "null" : cred.toString()));
                    }
                }
                catch (WSSecurityException e) {
                    securityName = null;
                    FFDCFilter.processException(e, FFDC_SOURCE_ID, "313");
                    if (!tc.isDebugEnabled()) break block17;
                    Tr.debug(tc, "Error in getting security name from credential " + e.toString());
                }
            }
            try {
                if (cred != null) {
                    securityName = cred.getRealmSecurityName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invocation creds securityName = " + securityName);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Try getting the principal from received creds");
                    }
                    WSCredential[] receivedCreds = contextManager.getCallerCredentials();
                    cred = null;
                    if (receivedCreds != null && receivedCreds.length != 0) {
                        cred = receivedCreds[0];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Received cred = " + cred);
                        }
                        if (cred != null) {
                            securityName = cred.getRealmSecurityName();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Received cred securityName = " + securityName);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Received creds = null");
                    }
                }
            }
            catch (GeneralSecurityException e) {
                securityName = null;
                FFDCFilter.processException(e, FFDC_SOURCE_ID, "351");
                if (!tc.isDebugEnabled()) break block18;
                Tr.debug(tc, "Error in getting security name from credential ", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityName() --> " + securityName);
        }
        return securityName;
    }
}

