/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.token;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.auth.token.TokenId;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

public class TokenManager {
    private static final String TOKENID_TABLE = "com.ibm.websphere.wssecurity.tokenIdTable";
    private static final TraceComponent tc = Tr.register(TokenManager.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";

    public static void initializeSubject(Map context) throws SoapSecurityException {
        Object obj;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeSubject(Map context)");
        }
        if ((obj = context.get("com.ibm.wsspi.wssecurity.core.subject")) == null || !(obj instanceof Subject)) {
            Subject subject = new Subject();
            context.put("com.ibm.wsspi.wssecurity.core.subject", subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeSubject(Map context)");
        }
    }

    public static void finalizeSubject(Map context) throws SoapSecurityException {
        boolean isServer;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finalizeSubject(Map context)");
        }
        if (isServer = WSSecurityPlatformContextFactory.getInstance().isServer()) {
            String str;
            SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
            Subject wssSubject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
            ContextManager contextManager = ContextManagerFactory.getInstance();
            if (contextManager == null) {
                throw SoapSecurityException.format("security.wssecurity.TokenManager.finalizeSubject01");
            }
            Subject caller = null;
            try {
                caller = contextManager.getCallerSubject();
            }
            catch (WSSecurityException e) {
                throw SoapSecurityException.format("security.wssecurity.TokenManager.finalizeSubject02", e);
            }
            if (caller == null) {
                messageContext.removeProperty("com.ibm.ws.webservices.wssecurity.constants.callerSubject");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The caller subject is null.");
                }
            } else {
                messageContext.setProperty("com.ibm.ws.webservices.wssecurity.constants.callerSubject", caller);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Stored the caller subject.");
                }
            }
            Subject invocation = null;
            try {
                invocation = contextManager.getInvocationSubject();
            }
            catch (WSSecurityException e) {
                throw SoapSecurityException.format("security.wssecurity.TokenManager.finalizeSubject03", e);
            }
            if (invocation == null) {
                messageContext.removeProperty("com.ibm.ws.webservices.wssecurity.constants.invocationSubject");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The invocation subject is null.");
                }
            } else {
                messageContext.setProperty("com.ibm.ws.webservices.wssecurity.constants.invocationSubject", invocation);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Stored the invocation subject.");
                }
            }
            try {
                contextManager.setCallerSubject(wssSubject);
            }
            catch (WSSecurityException e) {
                throw SoapSecurityException.format("security.wssecurity.TokenManager.finalizeSubject04", e);
            }
            if (tc.isDebugEnabled()) {
                str = wssSubject == null ? "null" : "not null";
                Tr.debug((TraceComponent)tc, (String)("Replaced the caller subject [" + str + "]"));
            }
            try {
                contextManager.setInvocationSubject(wssSubject);
            }
            catch (WSSecurityException e) {
                throw SoapSecurityException.format("security.wssecurity.TokenManager.finalizeSubject05", e);
            }
            if (tc.isDebugEnabled()) {
                str = wssSubject == null ? "null" : "not null";
                Tr.debug((TraceComponent)tc, (String)("Replaced the invocation subject [" + str + "]"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finalizeSubject(Map context)");
        }
    }

    public static void setToken(final Map context, final Token token) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setToken(Map context,Token token[" + token + "])"));
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Subject subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
                if (subject == null) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.TokenManager.subjectIsNull");
                } else {
                    subject.getPrivateCredentials().add(token);
                }
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setToken(Map context,Token token)");
        }
    }

    public static Token getToken(Map context, TokenConsumerConfig tconfig, String id) {
        Token token;
        block9: {
            block8: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)("getToken(Map context,TokenConsumerConfig tconfig[" + tconfig + "]," + "String id[" + id + "])"));
                }
                token = null;
                if (tconfig != null) break block8;
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug((TraceComponent)tc, (String)"Since TokenConsumerConfig is null, the runtime can't identify a token.");
                break block9;
            }
            for (Token t : TokenManager.getTokens(context)) {
                String tid = t.getId();
                if (tid == null || !tid.equals(id) || !tconfig.equals(t.getUsedTokenConsumer())) continue;
                token = t;
                break;
            }
            if (token == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Did not find exact token match with token consumer; try matching consumer class.");
                }
                Iterator tokens = TokenManager.getTokens(context).iterator();
                Class<?> tconfigClass = null;
                if (tconfig != null) {
                    tconfigClass = tconfig.getClass();
                }
                while (tokens.hasNext()) {
                    Token t = (Token)tokens.next();
                    String tid = t.getId();
                    if (tid == null || !tid.equals(id)) continue;
                    Class<?> tClass = null;
                    if (t.getUsedTokenConsumer() != null) {
                        tClass = t.getUsedTokenConsumer().getClass();
                    }
                    if (tconfigClass == null || tClass == null || !tconfigClass.equals(tClass)) continue;
                    token = t;
                    break;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getToken(Map context,TokenConsumerConfig tconfig,String id) returns Token[" + token + "]"));
        }
        return token;
    }

    public static Token getToken(Map context, TokenId tokenId) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getToken(Map context,TokenId tokenId[" + tokenId + "])"));
        }
        Token token = null;
        if (tokenId != null) {
            token = TokenManager.getToken(context, tokenId.getId());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getToken(Map context,TokenId tokenId) returns Token[" + token + "]"));
        }
        return token;
    }

    public static Token getToken(Map context, String id) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getToken(Map context,String id[" + id + "])"));
        }
        Token token = null;
        if (id != null) {
            for (Token t : TokenManager.getTokens(context)) {
                String tid = t.getId();
                if (tid == null || !tid.equals(id) || t.getError() != null) continue;
                token = t;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getToken(Map context,TokenId tokenId) returns Token[" + token + "]"));
        }
        return token;
    }

    public static Token getUnprocessedToken(Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUnprocessedToken(Map context");
        }
        Iterator tokens = TokenManager.getTokens(context).iterator();
        Token token = null;
        while (tokens.hasNext()) {
            Token t = (Token)tokens.next();
            if (t.isProcessed()) continue;
            token = t;
            break;
        }
        if (tc.isEntryEnabled()) {
            String str = token == null ? "null" : token.getClass().getName() + ":" + token.getUniqueID();
            Tr.exit((TraceComponent)tc, (String)("getUnprocessedToken(Map context) returns Token[" + str + "]"));
        }
        return token;
    }

    public static void setTokens(final Map context, final Collection tokens) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setTokens(Map context,Collection tokens[" + tokens + "])"));
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Subject subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
                if (subject == null) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.TokenManager.subjectIsNull");
                } else {
                    subject.getPrivateCredentials().addAll(tokens);
                }
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTokens(Map context,Collection tokens)");
        }
    }

    public static Set getTokens(final Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTokens(Map context)");
        }
        Set set = (Set)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Set<Token> result = null;
                Subject subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
                if (subject == null) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.TokenManager.subjectIsNull");
                } else {
                    result = subject.getPrivateCredentials(Token.class);
                }
                return result;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTokens(context) returns Set[" + set + "]"));
        }
        return set;
    }

    public static Set getTokens(Map context, String id) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getTokens(Map context,String id[" + id + "])"));
        }
        Set tokens = TokenManager.getTokens(context);
        HashSet<Token> ret = new HashSet<Token>();
        for (Token t : tokens) {
            String tid = t.getId();
            if (tid == null || !tid.equals(id)) continue;
            ret.add(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTokens(Map context,String id) returns Set[" + ret + "]"));
        }
        return ret;
    }

    public static void removeToken(final Map context, final Token token) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeToken(Map context,Token token[" + token + "])"));
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Subject subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
                if (subject == null) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.TokenManager.subjectIsNull");
                } else {
                    subject.getPrivateCredentials().remove(token);
                }
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeToken(Map context,Token token)");
        }
    }

    public static void removeTokens(final Map context, final Set tokens) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeTokens(Map context,Set tokens[" + tokens + "])"));
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Subject subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
                if (subject == null) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.TokenManager.subjectIsNull");
                } else {
                    subject.getPrivateCredentials().removeAll(tokens);
                }
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeTokens(Map context,Set tokens)");
        }
    }

    public static void removeAllTokens(final Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeAllTokens(Map context)");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Subject subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
                Set<Token> set = subject.getPrivateCredentials(Token.class);
                if (subject == null) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.TokenManager.subjectIsNull");
                } else {
                    subject.getPrivateCredentials().removeAll(set);
                }
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeAllTokens(Map context)");
        }
    }

    public static void setTokenId(TokenId tokenId) {
        MessageContext mcontext;
        Hashtable tokenIdTable;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setTokenId(Tokenid tokenId[" + tokenId + "])"));
        }
        if ((tokenIdTable = (Hashtable)(mcontext = MessageContext.getCurrentThreadsContext()).getProperty(TOKENID_TABLE)) == null) {
            TokenManager.initTokenIdTable(mcontext);
        }
        tokenIdTable.put(tokenId.getId(), tokenId);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTokenId(TokenId tokenId)");
        }
    }

    public static Hashtable getTokenIdsTable() {
        MessageContext mcontext;
        Hashtable tokenIdTable;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTokenIdsTable()");
        }
        if ((tokenIdTable = (Hashtable)(mcontext = MessageContext.getCurrentThreadsContext()).getProperty(TOKENID_TABLE)) == null) {
            TokenManager.initTokenIdTable(mcontext);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTokenIdsTable() returns Hashtable[" + tokenIdTable + "]"));
        }
        return tokenIdTable;
    }

    private static void initTokenIdTable(SOAPMessageContext mcontext) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initTokenIdTable(SOAPMessageContext mcontext)");
        }
        if (!mcontext.containsProperty(TOKENID_TABLE) || mcontext.getProperty(TOKENID_TABLE) == null) {
            mcontext.setProperty(TOKENID_TABLE, new Hashtable());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initTokenIdTable(SOAPMessageContext mcontext)");
        }
    }

    public static String getRunAsIdentity(final boolean sendRealm) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getRunAsIdentity(boolean sendRealm[" + sendRealm + "])"));
        }
        String identity = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Iterator<WSPrincipal> i;
                Set<WSPrincipal> set;
                Subject subject = null;
                String ret = null;
                ContextManager contextManager = ContextManagerFactory.getInstance();
                if (contextManager == null) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.TokenManager.finalizeSubject01");
                }
                try {
                    subject = contextManager.getInvocationSubject();
                    if (subject == null) {
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.TokenManager.finalizeSubject03");
                    }
                }
                catch (WSSecurityException e) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.TokenManager.finalizeSubject03", (Object)new Object[]{e});
                }
                if (subject != null && (set = subject.getPrincipals(WSPrincipal.class)) != null && (i = set.iterator()).hasNext()) {
                    WSPrincipal principal = i.next();
                    ret = sendRealm ? principal.getName() : RealmSecurityName.getSecurityName(principal.getName());
                }
                return ret;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRunAsIdentity(boolean sendRealm) returns String[" + identity + "]"));
        }
        return identity;
    }
}

