/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.time;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSConsumerComponent;
import com.ibm.ws.webservices.wssecurity.config.TimestampConsumerConfig;
import com.ibm.ws.webservices.wssecurity.time.TimestampResult;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.NonceUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TimestampConsumer
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(TimestampConsumer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = TimestampConsumer.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Node target, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Node target[" + DOMUtil.getDisplayName((Node)target) + "]," + "Map context)"));
        }
        if (target == null) {
            throw SoapSecurityException.format("security.wssecurity.TimestampConsumer.s01");
        }
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsu = Constants.NAMESPACES[1][wssVersion];
        TimestampConsumerConfig config = (TimestampConsumerConfig)context.remove("com.ibm.wsspi.wssecurity.config.timestampConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TimestampConsumerConfig [" + config + "]."));
        }
        SoapSecurityException sse = null;
        try {
            NonceUtil.checkTimestamp(target, nsWsu, config.getTimestampMaxAge(), config.getTimestampClockSkew(), true);
        }
        catch (SoapSecurityException e) {
            sse = e;
        }
        ResultPool.add((Map)context, (Result)new TimestampResult((Element)target, sse));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Element target,Map context)");
        }
    }
}

