/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.time;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSConsumerComponent;
import com.ibm.ws.webservices.wssecurity.config.TimestampConsumerConfig;
import com.ibm.ws.webservices.wssecurity.time.TimestampGenerator;
import com.ibm.ws.webservices.wssecurity.time.TimestampResult;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.TimestampDialectElementSelector;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TimestampChecker
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(TimestampChecker.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = TimestampChecker.class.getName();
    private Map _selectors = null;
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Node target, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Node target[" + DOMUtil.getDisplayName((Node)target) + "]," + "Map context)"));
        }
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsu = Constants.NAMESPACES[1][wssVersion];
        Document doc = null;
        doc = target.getNodeType() == 9 ? (Document)target : target.getOwnerDocument();
        TimestampConsumerConfig config = (TimestampConsumerConfig)context.remove("com.ibm.wsspi.wssecurity.config.timestampConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TimestampConsumerConfig [" + config + "]."));
        }
        Set requiredParts = TimestampChecker.preprocess(doc, config, this._selectors, nsWsu, context);
        Result[] results = ResultPool.get((Map)context, TimestampResult.class);
        if (results != null && results.length > 0) {
            ResultPool.remove((Map)context, (Result[])results);
            for (int i = 0; i < results.length; ++i) {
                TimestampResult result = (TimestampResult)results[i];
                RequiredPart rpart = TimestampChecker.getRelatedPart(result._element, requiredParts);
                if (rpart == null) continue;
                if (result._ex != null) {
                    throw result._ex;
                }
                rpart._processed = true;
            }
        }
        for (RequiredPart rpart : requiredParts) {
            if (rpart._processed) continue;
            throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.TimestampChecker.s01");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Node target,Map context)");
        }
    }

    private static Set preprocess(Document doc, TimestampConsumerConfig tconfig, Map selectors, String nsWsu, Map context) throws SoapSecurityException {
        NodeList list;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("preprocess(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "TimestampConsumerConfig tconfig," + "Set selectors[" + selectors + "]," + "String nsWsu[" + nsWsu + "]," + "Map context)"));
        }
        HashSet<RequiredPart> requiredParts = new HashSet<RequiredPart>();
        Map properties = tconfig.getProperties();
        String value = (String)properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TIMESTAMP_SOAPHEADER);
        boolean isSOAPHeaderElement = ConfigUtil.isTrue((String)value);
        String dialect = (String)properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TIMESTAMP_DIALECT);
        String keyword = (String)properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TIMESTAMP_KEYWORD);
        if (dialect == null) {
            dialect = Constants.DIALECT_WAS;
            keyword = isSOAPHeaderElement ? TimestampDialectElementSelector.WASDIALECTS[5] : TimestampDialectElementSelector.WASDIALECTS[4];
        }
        if ((list = TimestampGenerator.getTimestamp(doc, dialect, keyword, "check", null, null, null, selectors, context)) != null && list.getLength() > 0) {
            for (int j = 0; j < list.getLength(); ++j) {
                Element element = (Element)list.item(j);
                String ns = element.getNamespaceURI();
                String ln = element.getLocalName();
                if (!nsWsu.equals(ns) || !"Timestamp".equals(ln)) {
                    throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.TimestampChecker.s02", keyword);
                }
                RequiredPart rpart = new RequiredPart(element);
                requiredParts.add(rpart);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"preprocess(Document doc,TimestampConsumerConfig tconfig,Set selectors,String nsWsu,Map context)");
        }
        return requiredParts;
    }

    private static RequiredPart getRelatedPart(Element element, Set requiredParts) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getRelatedPart(Element element[" + DOMUtil.getDisplayName((Node)element) + "]," + "Set requiredParts[" + requiredParts + "])"));
        }
        RequiredPart rpart = null;
        for (RequiredPart part : requiredParts) {
            if (DOMUtil.equals((Node)part._element, (Node)element)) {
                rpart = part;
                break;
            }
            if (rpart == null) continue;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRelatedPart(Element element,Set requiredParts)");
        }
        return rpart;
    }

    private static class RequiredPart {
        private Element _element;
        private boolean _processed;

        RequiredPart(Element element) {
            this._element = element;
            this._processed = false;
        }
    }
}

