/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.keyinfo;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSGenerator;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.keyinfo.KeyLocator;
import com.ibm.wsspi.wssecurity.token.TokenGeneratorComponent;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class STRReferenceContentGenerator
implements KeyInfoContentGeneratorComponent {
    private static final TraceComponent tc = Tr.register(STRReferenceContentGenerator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = STRReferenceContentGenerator.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public Key getKey(Document doc, Element parent, Map type, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getKey(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "Map type," + "Map context)"));
        }
        KeyInfoContentGeneratorConfig config = (KeyInfoContentGeneratorConfig)context.remove("com.ibm.wsspi.wssecurity.config.keyinfoContentGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyInfoContentGeneratorConfig [" + config + "]."));
        }
        if (!ConfigUtil.isKeyInfoStrref((String)config.getKeyInfoType())) {
            String keyType = (String)type.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
            boolean isServer = WSSecurityPlatformContextFactory.getInstance().isServer();
            StringBuffer buf = new StringBuffer(clsName).append(" expects KeyInfo's type [STRREF],");
            buf.append(" but the type requested in the configuration is [").append(config.getKeyInfoType()).append("].");
            buf.append(" Please make sure the KeyInfo used for");
            if ("SigningKey".equals(keyType)) {
                buf.append(" siganture");
            } else {
                buf.append(" encryption");
            }
            buf.append(" in the");
            if (isServer) {
                buf.append(" response generator configuration.");
            } else {
                buf.append(" request generator configuration.");
            }
            throw new SoapSecurityException(buf.toString());
        }
        int wssVersion = 0;
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, config.getKeyInfoType());
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, config.getKeyInfoType());
        if (config.getKeyName() == null) {
            type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF);
            context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF);
        } else {
            type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF, config.getKeyName());
            context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF, config.getKeyName());
        }
        String reference = null;
        String tokenId = null;
        TokenGeneratorConfig tconfig = config.getTokenGenerator();
        if (tconfig != null) {
            TokenGeneratorComponent tgen = tconfig.getInstance();
            if (tgen == null) {
                throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey01");
            }
            context.put("com.ibm.wsspi.wssecurity.config.tokenGenerator.configKey", tconfig);
            Element security2 = STRReferenceContentGenerator.getSecurityElement(doc, parent, wssVersion, nsWsse, context);
            tgen.invoke(doc, security2, context);
            reference = (String)context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_REFERENCE);
            if (reference != null) {
                tokenId = reference.startsWith("#") ? reference.substring(1) : reference;
            }
        } else {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey01");
        }
        KeyLocator klocator = config.getKeyLocator();
        if (klocator == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey03");
        }
        if (tokenId != null) {
            type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_REFERENCE, tokenId);
        } else {
            type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_REFERENCE);
        }
        type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMBID);
        type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID);
        type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME);
        type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERNAME);
        type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERSERIAL);
        Key key = klocator.getKey(type, context);
        if (reference == null) {
            reference = (String)context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_REFERENCE);
        }
        String prefix = DOMUtil.getNamespacePrefix((Element)parent, (String)nsWsse);
        boolean nsDecl = false;
        if (prefix == null) {
            nsDecl = true;
            prefix = "wsse:";
        } else if (prefix.length() > 0) {
            prefix = prefix + ":";
        }
        Element strelem = doc.createElementNS(nsWsse, prefix + "SecurityTokenReference");
        if (nsDecl) {
            strelem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", nsWsse);
        }
        Element refelem = doc.createElementNS(nsWsse, prefix + "Reference");
        refelem.setAttribute("URI", reference);
        Map properties = config.getProperties();
        String ln = (String)properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_VALUETYPE_LN);
        String ns = (String)properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_VALUETYPE_NS);
        QName valueType = tconfig.getType();
        if (ln != null && ln.length() > 0) {
            valueType = ns == null ? new QName("", ln) : new QName(ns, ln);
        }
        DOMUtil.setQNameAttr(refelem, null, "ValueType", valueType, wssVersion);
        refelem = (Element)strelem.appendChild(refelem);
        strelem = (Element)parent.appendChild(strelem);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKey(Document doc,Element parent,Map type,Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    protected static Element getSecurityElement(Document doc, Element parent, int wssVersion, String nsWsse, Map context) throws SoapSecurityException {
        Element security2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getSecurityElement(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "int wssVersion[" + wssVersion + "]," + "String nsWsse[" + nsWsse + "]," + "Map context)"));
        }
        if ((security2 = DOMUtil.getAncestorElement((Element)parent, (String)nsWsse, (String)"Security")) == null) {
            WSSGeneratorConfig config = (WSSGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
            int soapVersion = 0;
            Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.soapVersion");
            if (obj != null && obj instanceof Integer) {
                soapVersion = (Integer)obj;
            }
            String nsSoap = Constants.NAMESPACES[2][soapVersion];
            Element header = WSSGenerator.getHeader(doc, false);
            security2 = WSSGenerator.getSecurityHeader(header, soapVersion, wssVersion, config.getTargetActor(), true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSecurityElement(Document doc,Element parent,int wssVersion,String nsWsse,Map context) returns Element[" + DOMUtil.getDisplayName((Node)security2) + "]"));
        }
        return security2;
    }
}

