/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.keyinfo;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.STRReferenceContentGenerator;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.keyinfo.KeyLocator;
import com.ibm.wsspi.wssecurity.token.TokenGeneratorComponent;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class KeyNameContentGenerator
implements KeyInfoContentGeneratorComponent {
    private static final TraceComponent tc = Tr.register(KeyNameContentGenerator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = KeyNameContentGenerator.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public Key getKey(Document doc, Element parent, Map type, Map context) throws SoapSecurityException {
        String prefix;
        KeyLocator klocator;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getKey(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "Map type," + "Map context)"));
        }
        KeyInfoContentGeneratorConfig config = (KeyInfoContentGeneratorConfig)context.remove("com.ibm.wsspi.wssecurity.config.keyinfoContentGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyInfoContentGeneratorConfig [" + config + "]."));
        }
        if (!ConfigUtil.isKeyInfoKeyname((String)config.getKeyInfoType())) {
            String keyType = (String)type.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
            boolean isServer = WSSecurityPlatformContextFactory.getInstance().isServer();
            StringBuffer buf = new StringBuffer(clsName).append(" expects KeyInfo's type [KEYNAME],");
            buf.append(" but the type requested in the configuration is [").append(config.getKeyInfoType()).append("].");
            buf.append(" Please make sure the KeyInfo used for");
            if ("SigningKey".equals(keyType)) {
                buf.append(" siganture");
            } else {
                buf.append(" encryption");
            }
            buf.append(" in the");
            if (isServer) {
                buf.append(" response generator configuration.");
            } else {
                buf.append(" request generator configuration.");
            }
            throw new SoapSecurityException(buf.toString());
        }
        int wssVersion = 0;
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, config.getKeyInfoType());
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, config.getKeyInfoType());
        if (config.getKeyName() == null) {
            type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF);
            context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF);
        } else {
            type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF, config.getKeyName());
            context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF, config.getKeyName());
        }
        String keyName = null;
        TokenGeneratorConfig tconfig = config.getTokenGenerator();
        if (tconfig != null) {
            TokenGeneratorComponent tgen = tconfig.getInstance();
            if (tgen == null) {
                throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey01");
            }
            context.put("com.ibm.wsspi.wssecurity.config.tokenGenerator.configKey", tconfig);
            Element security2 = STRReferenceContentGenerator.getSecurityElement(doc, parent, wssVersion, nsWsse, context);
            tgen.invoke(doc, security2, context);
            keyName = (String)context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME);
        }
        if ((klocator = config.getKeyLocator()) == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey03");
        }
        if (keyName != null) {
            type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME, keyName);
        } else {
            type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME);
        }
        type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMBID);
        type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_REFERENCE);
        type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID);
        type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERNAME);
        type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERSERIAL);
        Key key = klocator.getKey(type, context);
        if (keyName == null) {
            keyName = (String)context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME);
        }
        if ((prefix = DOMUtil.getNamespacePrefix((Element)parent, (String)Constants.NS_DSIG)) == null) {
            prefix = "ds:";
        } else if (prefix.length() > 0) {
            prefix = prefix + ":";
        }
        Element elem = doc.createElementNS(Constants.NS_DSIG, prefix + "KeyName");
        String kn = KeyInfo.X509Data.decodeDName((String)keyName);
        if (kn != null) {
            keyName = kn;
        }
        Text text = doc.createTextNode(keyName);
        text = (Text)elem.appendChild(text);
        elem = (Element)parent.appendChild(elem);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created the element [" + DOMUtil.getDisplayName((Node)elem) + "]."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKey(Document doc,Element parent,Map type,Map context) returns Key[" + key + "]"));
        }
        return key;
    }
}

