/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.keyinfo;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.WSSKeyInfoComponent;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KeyInfoGenerator
implements WSSKeyInfoComponent {
    private static final TraceComponent tc = Tr.register(KeyInfoGenerator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = KeyInfoGenerator.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public Key getKey(Document doc, Element parent, Map type, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getKey(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "Map type," + "Map context)"));
        }
        Key key = null;
        WSSGeneratorConfig gconfig = (WSSGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        KeyInfoGeneratorConfig config = (KeyInfoGeneratorConfig)context.remove("com.ibm.wsspi.wssecurity.config.keyinfoGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyInfoGeneratorConfig [" + config + "]."));
        }
        Element elem = null;
        elem = doc.createElementNS(Constants.NS_DSIG, "ds:KeyInfo");
        String ktype = (String)type.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
        boolean encrypt = false;
        if ("EncryptingKey".equals(ktype)) {
            encrypt = true;
            elem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", Constants.NS_DSIG);
        }
        if (gconfig.isUserDefinedComponentsUsed()) {
            Element old = DOMUtil.getOneChildElement((Element)parent, (String)Constants.NS_DSIG, (String)"KeyInfo");
            Node node = old.getNextSibling();
            parent.removeChild(old);
            elem = (Element)parent.insertBefore(elem, node);
        } else {
            elem = encrypt ? (Element)parent.insertBefore(elem, DOMUtil.getOneChildElement((Element)parent, (String)Constants.NS_ENC, (String)"CipherData")) : (Element)parent.appendChild(elem);
        }
        KeyInfoContentGeneratorComponent kgen = config.getContentGenerator().getInstance();
        if (kgen == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey01");
        }
        context.put("com.ibm.wsspi.wssecurity.config.keyinfoContentGenerator.configKey", config.getContentGenerator());
        key = kgen.getKey(doc, elem, type, context);
        if (key == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey02");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created the element [" + DOMUtil.getDisplayName((Node)elem) + "]."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getKey(Document doc,Element parent,Map type,Map context) returns Key[key]");
        }
        return key;
    }
}

