/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.keyinfo;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditEventGeneratorImpl;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditService;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditServiceImpl;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.keyinfo.KeyLocator;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KeyIdContentConsumer
implements KeyInfoContentConsumerComponent {
    private static final TraceComponent tc = Tr.register(KeyIdContentConsumer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = KeyIdContentConsumer.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public Key getKey(Element target, Map type, Map context) throws SoapSecurityException {
        KeyLocator klocator;
        Element kidelem;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getKey(Element target[" + DOMUtil.getDisplayName((Node)target) + "]," + "Map type," + "Map context)"));
        }
        KeyInfoContentConsumerConfig config = (KeyInfoContentConsumerConfig)context.remove("com.ibm.wsspi.wssecurity.config.keyinfoContentConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyInfoContentConsumerConfig [" + config + "]."));
        }
        KeyInfoResult result = new KeyInfoResult(config);
        ResultPool.add((Map)context, (Result)result);
        if (!ConfigUtil.isKeyInfoKeyid((String)config.getKeyInfoType())) {
            String keyType = (String)type.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
            boolean isServer = WSSecurityPlatformContextFactory.getInstance().isServer();
            StringBuffer buf = new StringBuffer(clsName).append(" expects KeyInfo's type [KEYID],");
            buf.append(" but the type requested in the configuration is [").append(config.getKeyInfoType()).append("].");
            buf.append(" Please make sure the KeyInfo used for");
            if ("VerifyingKey".equals(keyType)) {
                buf.append(" siganture verification");
            } else {
                buf.append(" decryption");
            }
            buf.append(" in the");
            if (isServer) {
                buf.append(" request consumer configuration.");
            } else {
                buf.append(" response consumer configuration.");
            }
            throw new SoapSecurityException(buf.toString());
        }
        int wssVersion = 0;
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, config.getKeyInfoType());
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, config.getKeyInfoType());
        String keyType = (String)type.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE, keyType);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The type of a key is [" + keyType + "]."));
        }
        if ((kidelem = DOMUtil.getZeroOrOneElement((Element)target, (String)nsWsse, (String)"KeyIdentifier")) == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyIdContentConsumer.getKey01");
        }
        String kid = this.getKeyIdentifier(kidelem);
        result.setIdInSubject(kid);
        type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID, kid);
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID, kid);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_REFERENCE);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMBID);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERNAME);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERSERIAL);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Key identifier is [" + kid + "]."));
        }
        QName vtype = this.getValueType(kidelem, wssVersion);
        QName etype = this.getEncodingType(kidelem, wssVersion);
        QName itype = this.getIdentifierType(kidelem, wssVersion);
        type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_VALUETYPE, vtype);
        type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ENCODING, etype);
        type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_IDTYPE, itype);
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_VALUETYPE, vtype);
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ENCODING, etype);
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_IDTYPE, itype);
        boolean isServer = WSSecurityPlatformContextFactory.getInstance().isServer();
        if (isServer && vtype != null && (vtype.equals(Constants.X509_SKI) || vtype.equals(Constants.X509_SKI_OLD))) {
            SOAPMessageContext messageContext;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The " + vtype + " key idendifier is found.  It is cached in order to use it for response generator."));
            }
            if ((messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext")) == null) {
                throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
            }
            messageContext.setProperty("com.ibm.ws.webservices.wssecurity.constants.consumedKeyidValuetype", vtype);
        }
        if ((klocator = config.getKeyLocator()) == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey03");
        }
        context.put("com.ibm.wsspi.wssecurity.token.x509.keyLocator", config.getKeyLocator());
        context.remove(klocator.getClass());
        if (config.getTokenConsumer() == null) {
            type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TOKEN_REFERENCE);
        } else {
            type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TOKEN_REFERENCE, config.getTokenConsumer());
        }
        TokenConsumerConfig tconfig = config.getTokenConsumer();
        if (tconfig != null) {
            TokenConsumerComponent tcon = tconfig.getInstance();
            if (tcon == null) {
                throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getKey01");
            }
            context.put("com.ibm.wsspi.wssecurity.config.tokenConsumer.configKey", tconfig);
            tcon.invoke(target.getOwnerDocument(), context);
        }
        context.remove("com.ibm.wsspi.wssecurity.token.x509.keyLocator");
        klocator = config.getKeyLocator();
        Key key = klocator.getKey(type, context);
        context.remove(klocator.getClass());
        context.remove("com.ibm.wsspi.wssecurity.token.x509.certificate");
        if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, WSSAuditService.WSSAuditOutcome.SUCCESS) || WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, WSSAuditService.WSSAuditOutcome.DENIED)) {
            Map<String, Object> auditContext = WSSAuditEventGeneratorImpl.getInstance().setExtendedAuditData(context, "TokenId", kid);
            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "KeyInfoType", type.toString());
            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "Algorithm", key.getAlgorithm());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKey(Element target,Map type,Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    private QName getValueType(Element elem, int wssVersion) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getValueType(Element elem[" + DOMUtil.getDisplayName((Node)elem) + "]," + "int wssVersion[" + wssVersion + "])"));
        }
        QName type = null;
        if (!elem.hasAttribute("ValueType")) {
            throw SoapSecurityException.format("security.wssecurity.BinaryTokenReceiver.token16");
        }
        String et = elem.getAttribute("ValueType");
        type = DOMUtil.getQName(elem, et, wssVersion);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getValueType(Element elem,int wssVersion) returns QName[" + type + "]"));
        }
        return type;
    }

    private QName getEncodingType(Element elem, int wssVersion) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEncodingType(Element elem[" + DOMUtil.getDisplayName((Node)elem) + "]," + "int wssVersion[" + wssVersion + "])"));
        }
        QName type = Constants.BASE64_BINARY;
        if (elem.hasAttribute("EncodingType")) {
            String et = elem.getAttribute("EncodingType");
            type = DOMUtil.getQName(elem, et, wssVersion);
        } else {
            Tr.debug((TraceComponent)tc, (String)ConfigUtil.getMessage((String)"security.wssecurity.KeyIdContentConsumer.getEncodingType02"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEncodingType(Element elem,int wssVersion) returns QName[" + type + "]"));
        }
        return type;
    }

    private QName getIdentifierType(Element elem, int wssVersion) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getIdentifierType(Element elem[" + DOMUtil.getDisplayName((Node)elem) + "]," + "int wssVersion[" + wssVersion + "])"));
        }
        QName type = Constants.ITSHA1;
        if (elem.hasAttribute("IdentifierType")) {
            String it = elem.getAttribute("IdentifierType");
            type = DOMUtil.getQName(elem, it, wssVersion);
        } else {
            Tr.debug((TraceComponent)tc, (String)ConfigUtil.getMessage((String)"security.wssecurity.KeyIdContentConsumer.getIdentifierType01"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getIdentifierType(Element elem,int wssVersion) returns QName[" + type + "]"));
        }
        return type;
    }

    private String getKeyIdentifier(Element elem) throws SoapSecurityException {
        String encoded;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getKeyIdentifier(Element elem[" + DOMUtil.getDisplayName((Node)elem) + "])"));
        }
        if ((encoded = DOMUtil.getStringValue((Node)elem)) != null && encoded.length() != 0) {
            encoded = encoded.trim();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKeyIdentifier(Element elem) returns String[" + encoded + "]"));
        }
        return encoded;
    }
}

