/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.keyinfo;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.keyinfo.KeyLocator;
import com.ibm.wsspi.wssecurity.token.TokenGeneratorComponent;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EmbeddedContentGenerator
implements KeyInfoContentGeneratorComponent {
    private static final TraceComponent tc = Tr.register(EmbeddedContentGenerator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = EmbeddedContentGenerator.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public Key getKey(Document doc, Element parent, Map type, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getKey(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "Map type," + "Map context)"));
        }
        KeyInfoContentGeneratorConfig config = (KeyInfoContentGeneratorConfig)context.remove("com.ibm.wsspi.wssecurity.config.keyinfoContentGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyInfoContentGeneratorConfig [" + config + "]."));
        }
        if (!ConfigUtil.isKeyInfoEmb((String)config.getKeyInfoType())) {
            String keyType = (String)type.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
            boolean isServer = WSSecurityPlatformContextFactory.getInstance().isServer();
            StringBuffer buf = new StringBuffer(clsName).append(" expects KeyInfo's type [EMB],");
            buf.append(" but the type requested in the configuration is [").append(config.getKeyInfoType()).append("].");
            buf.append(" Please make sure the KeyInfo used for");
            if ("SigningKey".equals(keyType)) {
                buf.append(" siganture");
            } else {
                buf.append(" encryption");
            }
            buf.append(" in the");
            if (isServer) {
                buf.append(" response generator configuration.");
            } else {
                buf.append(" request generator configuration.");
            }
            throw new SoapSecurityException(buf.toString());
        }
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        String nsWsu = Constants.NAMESPACES[1][wssVersion];
        type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, config.getKeyInfoType());
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, config.getKeyInfoType());
        if (config.getKeyName() == null) {
            type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF);
            context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF);
        } else {
            type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF, config.getKeyName());
            context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF, config.getKeyName());
        }
        String prefix = DOMUtil.getNamespacePrefix((Element)parent, (String)nsWsse);
        boolean nsDecl = false;
        if (prefix == null) {
            nsDecl = true;
            prefix = "wsse:";
        } else if (prefix.length() > 0) {
            prefix = prefix + ":";
        }
        Element strelem = doc.createElementNS(nsWsse, prefix + "SecurityTokenReference");
        if (nsDecl) {
            strelem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", nsWsse);
        }
        strelem = (Element)parent.appendChild(strelem);
        Element embelem = doc.createElementNS(nsWsse, prefix + "Embedded");
        embelem = (Element)strelem.appendChild(embelem);
        String embId = null;
        TokenGeneratorConfig tconfig = config.getTokenGenerator();
        if (tconfig == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey01");
        }
        TokenGeneratorComponent tgen = tconfig.getInstance();
        if (tgen == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey01");
        }
        context.put("com.ibm.wsspi.wssecurity.config.tokenGenerator.configKey", tconfig);
        tgen.invoke(doc, embelem, context);
        embId = (String)context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMBID);
        KeyLocator klocator = config.getKeyLocator();
        if (klocator == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey03");
        }
        if (embId != null) {
            type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMBID, embId);
        } else {
            type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMBID);
        }
        type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_REFERENCE);
        type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID);
        type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME);
        type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERNAME);
        type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERSERIAL);
        Key key = klocator.getKey(type, context);
        if (embId == null) {
            embId = (String)context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMBID);
        }
        embelem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", nsWsu);
        embelem.setAttribute("wsu:Id", embId);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKey(Document doc,Element parent,Map type,Map context) returns Key[" + key + "]"));
        }
        return key;
    }
}

