/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.keyinfo;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditEventGeneratorImpl;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditService;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditServiceImpl;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.keyinfo.KeyLocator;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EmbeddedContentConsumer
implements KeyInfoContentConsumerComponent {
    private static final TraceComponent tc = Tr.register(EmbeddedContentConsumer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = EmbeddedContentConsumer.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public Key getKey(Element target, Map type, Map context) throws SoapSecurityException {
        KeyLocator klocator;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getKey(Element target[" + DOMUtil.getDisplayName((Node)target) + "]," + "Map type," + "Map context)"));
        }
        KeyInfoContentConsumerConfig config = (KeyInfoContentConsumerConfig)context.remove("com.ibm.wsspi.wssecurity.config.keyinfoContentConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyInfoContentConsumerConfig [" + config + "]."));
        }
        KeyInfoResult result = new KeyInfoResult(config);
        ResultPool.add((Map)context, (Result)result);
        if (!ConfigUtil.isKeyInfoEmb((String)config.getKeyInfoType())) {
            String keyType = (String)type.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
            boolean isServer = WSSecurityPlatformContextFactory.getInstance().isServer();
            StringBuffer buf = new StringBuffer(clsName).append(" expects KeyInfo's type [EMB],");
            buf.append(" but the type requested in the configuration is [").append(config.getKeyInfoType()).append("].");
            buf.append(" Please make sure the KeyInfo used for");
            if ("VerifyingKey".equals(keyType)) {
                buf.append(" siganture verification");
            } else {
                buf.append(" decryption");
            }
            buf.append(" in the");
            if (isServer) {
                buf.append(" request consumer configuration.");
            } else {
                buf.append(" response consumer configuration.");
            }
            throw new SoapSecurityException(buf.toString());
        }
        int wssVersion = 0;
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, config.getKeyInfoType());
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, config.getKeyInfoType());
        String keyType = (String)type.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE, keyType);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The type of a key is [" + keyType + "]."));
        }
        String embId = this.getEmbeddedTokenId(target, nsWsse);
        result.setIdInSubject(embId);
        type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMBID, embId);
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMBID, embId);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_REFERENCE);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERNAME);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERSERIAL);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Embedded identifier of a token is [" + embId + "]."));
        }
        if ((klocator = config.getKeyLocator()) == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey03");
        }
        context.put("com.ibm.wsspi.wssecurity.token.x509.keyLocator", config.getKeyLocator());
        context.remove(klocator.getClass());
        if (config.getTokenConsumer() == null) {
            type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TOKEN_REFERENCE);
        } else {
            type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TOKEN_REFERENCE, config.getTokenConsumer());
        }
        Element token = this.getEmbeddedToken(target, nsWsse);
        TokenConsumerConfig tconfig = config.getTokenConsumer();
        if (tconfig == null) {
            throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getKey01");
        }
        TokenConsumerComponent tcon = tconfig.getInstance();
        if (tcon == null) {
            throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getKey01");
        }
        context.put("com.ibm.wsspi.wssecurity.config.tokenConsumer.configKey", tconfig);
        tcon.invoke(token, context);
        context.remove("com.ibm.wsspi.wssecurity.token.x509.keyLocator");
        klocator = config.getKeyLocator();
        Key key = klocator.getKey(type, context);
        context.remove(klocator.getClass());
        context.remove("com.ibm.wsspi.wssecurity.token.x509.certificate");
        if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, WSSAuditService.WSSAuditOutcome.SUCCESS) || WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, WSSAuditService.WSSAuditOutcome.DENIED)) {
            Map<String, Object> auditContext = WSSAuditEventGeneratorImpl.getInstance().setExtendedAuditData(context, "TokenId", embId);
            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "KeyInfoType", type.toString());
            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "Algorithm", key.getAlgorithm());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKey(Element target,Map type,Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    private Element getEmbeddedToken(Element elem, String nsWsse) throws SoapSecurityException {
        Element child;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEmbeddedToken(Element elem[" + DOMUtil.getDisplayName((Node)elem) + "]," + "String nsWsse[" + nsWsse + "])"));
        }
        if ((child = DOMUtil.getOneElement((Element)elem, (String)nsWsse, (String)"Embedded")) == null) {
            throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getEmbeddedToken01");
        }
        Element token = DOMUtil.getFirstElement((Node)child);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEmbeddedToken(Element elem,String nsWsse) returns Element[" + DOMUtil.getDisplayName((Node)token) + "]"));
        }
        return token;
    }

    private String getEmbeddedTokenId(Element elem, String nsWsse) throws SoapSecurityException {
        Element child;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEmbeddedTokenId(Element elem[" + DOMUtil.getDisplayName((Node)elem) + "]," + "String nsWsse[" + nsWsse + "])"));
        }
        if ((child = DOMUtil.getOneElement((Element)elem, (String)nsWsse, (String)"Embedded")) == null) {
            throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getEmbeddedToken01");
        }
        String id = child.getAttribute("wsu:Id");
        if (id == null) {
            throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getEmbeddedToken02");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEmbeddedTokenId(Element elem,String nsWsse) returns String[" + id + "]"));
        }
        return id;
    }
}

