/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler.token;

import com.ibm.websphere.security.UserMapping;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.xml.soapsec.token.UserRegistry;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Permission;
import java.security.cert.X509Certificate;
import javax.security.auth.login.LoginException;

public class WSUserRegistry
extends UserRegistry {
    private String realm = null;
    private static UserMapping _userMapping = null;
    private static final String USERMAPPING_IMPL = "com.ibm.ws.security.core.UserMappingImpl";
    private static final TraceComponent tc = Tr.register(WSUserRegistry.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSUserRegistry.class.getName();
    private static final Permission PERM = new WebSphereRuntimePermission("wssecurity.WSUserRegistry.mapCertificate");

    public String getRealm() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRealm");
        }
        if (this.realm == null) {
            com.ibm.websphere.security.UserRegistry ur = WSUserRegistry.getUserRegistry();
            if (ur != null) {
                try {
                    this.realm = ur.getRealm();
                }
                catch (Exception e) {
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSUserRegistry.token50", (Object)e);
                    Tr.processException((Throwable)e, (String)(clsName + ".getRealm"), (String)"60", (Object)((Object)this));
                }
            } else {
                ContextManager ctxMgr = ContextManagerFactory.getInstance();
                if (ctxMgr == null) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.ctxmgr.isnull");
                } else {
                    this.realm = ctxMgr.getDefaultRealm();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRealm", (Object)this.realm);
        }
        return this.realm;
    }

    public String mapCertificate(X509Certificate cert) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mapCertificate", (Object)new Object[]{cert});
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(PERM);
        }
        String securityName = null;
        UserMapping um = WSUserRegistry.getUserMapping();
        if (um != null) {
            try {
                securityName = um.mapCertificateToName(new X509Certificate[]{cert});
            }
            catch (Exception e) {
                Tr.processException((Throwable)e, (String)(clsName + ".mapCertificate"), (String)"95", (Object)((Object)this));
                Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5185W", (Object)new Object[]{cert.getSubjectDN().getName(), e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapCertificate", securityName);
        }
        return securityName;
    }

    public boolean checkUsername(String username) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkUsername");
        }
        com.ibm.websphere.security.UserRegistry ur = WSUserRegistry.getUserRegistry();
        boolean ret = false;
        try {
            if (ur != null) {
                ret = ur.isValidUser(username);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("registry.isValidUser() [" + username + "] = " + ret));
                }
                if (!ret) {
                    String userSecurityName = ur.getUserSecurityName(username);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("registry.getUserSecurityName()=" + userSecurityName));
                    }
                    ret = ur.isValidUser(userSecurityName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("registry.isValidUser() [" + userSecurityName + "] = " + ret));
                    }
                }
            }
        }
        catch (Exception e) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.checkUsername", (Object)e);
            Tr.processException((Throwable)e, (String)(clsName + ".checkUsername"), (String)"%C");
            throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurityWSUserRegistry.token48", (String[])new String[]{username, e.toString()}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkUsername(String username) returns boolean[" + ret + "]"));
        }
        return ret;
    }

    private static com.ibm.websphere.security.UserRegistry getUserRegistry() {
        com.ibm.websphere.security.UserRegistry _userRegistry;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserRegistry");
        }
        if ((_userRegistry = null) == null && ContextManagerFactory.getInstance().isServerSecurityEnabled() && WSSecurityPlatformContextFactory.getInstance().isServer()) {
            ContextManager manager = ContextManagerFactory.getInstance();
            _userRegistry = manager.getRegistry(manager.getDefaultRealm());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUserRegistry", _userRegistry);
        }
        return _userRegistry;
    }

    private static UserMapping getUserMapping() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserMapping");
        }
        if (_userMapping == null && ContextManagerFactory.getInstance().isServerSecurityEnabled() && WSSecurityPlatformContextFactory.getInstance().isServer()) {
            try {
                Class<?> clazz = Class.forName(USERMAPPING_IMPL);
                _userMapping = (UserMapping)clazz.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                Tr.processException((Throwable)cnfe, (String)(clsName + ".getUserMapping"), (String)"203");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5186E", (Object)new Object[]{USERMAPPING_IMPL, cnfe});
            }
            catch (IllegalAccessException iae) {
                Tr.processException((Throwable)iae, (String)(clsName + ".getUserMapping"), (String)"206");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5188E", (Object)new Object[]{USERMAPPING_IMPL, iae});
            }
            catch (Exception e) {
                Tr.processException((Throwable)e, (String)(clsName + ".getUserMapping"), (String)"209");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5187E", (Object)new Object[]{USERMAPPING_IMPL, e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUserMapping", (Object)_userMapping);
        }
        return _userMapping;
    }
}

