/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler.token;

import com.ibm.ISecurityL13SupportImpl.SecurityUIDGenerator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.handler.token.ByteArray;
import com.ibm.ws.webservices.wssecurity.handler.token.NonceCache;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.ByteArrayOutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;

public class WSNonceManagerImpl
implements NonceManager {
    private static final TraceComponent tc = Tr.register(WSNonceManagerImpl.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = WSNonceManagerImpl.class.getName();
    private static final String comp = "security.wssecurity";
    private static final String DEFAULT_JCE_PROVIDER = "DEFAULT_JCE_PROVIDER";
    private static final String IBMJCE = "IBMJCE";
    private static final String IBMSEC_RANDOM = "IBMSecureRandom";
    private static final String NONCE_CACHE_SIZE_KEY = "com.ibm.websphere.wssecurity.util.nonceCacheSize";
    private static final String NONCE_LENGTH_KEY = "com.ibm.websphere.wssecurity.util.nonceLength";
    private SecureRandom _random = null;
    private boolean _bServer = false;
    private NonceCache _cache = null;
    private int _nonceLength = 128;

    public WSNonceManagerImpl(String cacheName, int cacheSize, int cacheTimeout, int nonceLength, boolean cacheDistributed) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("WSNonceManagerImpl(String cacheName[" + cacheName + "]," + "int cacheSize[" + cacheSize + "]," + "int cacheTimeout[" + cacheTimeout + "]," + "int nonceLength[" + nonceLength + "]," + "boolean cacheDistributed[" + cacheDistributed + "])"));
        }
        this._bServer = WSSecurityPlatformContextFactory.getInstance().isServer();
        if (this._bServer) {
            String nonceCacheSize = System.getProperty(NONCE_CACHE_SIZE_KEY);
            int size = cacheSize;
            if (nonceCacheSize != null && (nonceCacheSize = nonceCacheSize.trim()).length() != 0) {
                try {
                    int i = Integer.parseInt(nonceCacheSize);
                    if (i <= 16) {
                        Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC0124W", (Object)new Object[]{nonceCacheSize, new Integer(16), new Integer(cacheSize)});
                        size = cacheSize;
                    } else {
                        size = i;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Nonce cache size from system property (com.ibm.websphere.wssecurity.util.nonceCacheSize) = " + size));
                        }
                    }
                }
                catch (NumberFormatException e) {
                    FFDCFilter.processException((Throwable)e, WSNonceManagerImpl.class.getName() + ".WSNonceManagerImpl", "89", this);
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5190W", (Object)new Object[]{NONCE_CACHE_SIZE_KEY, nonceCacheSize, new Integer(cacheSize)});
                    size = cacheSize;
                }
            }
            if (cacheName == null || cacheName.length() == 0) {
                cacheName = "NonceDistributionCacheMap";
            }
            this._cache = new NonceCache(cacheName, size, cacheTimeout, true, cacheDistributed);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Server process: enabled NonceCache");
            }
        }
        this._nonceLength = nonceLength;
        String nonceLengthStr = System.getProperty(NONCE_LENGTH_KEY);
        if (nonceLengthStr != null && (nonceLengthStr = nonceLengthStr.trim()).length() != 0) {
            try {
                int i = Integer.parseInt(nonceLengthStr);
                if (i <= 16) {
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC0127W", (Object)new Object[]{nonceLengthStr, new Integer(16), new Integer(nonceLength)});
                    this._nonceLength = nonceLength;
                } else {
                    this._nonceLength = i;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Nonce length from system property (com.ibm.websphere.wssecurity.util.nonceLength) = " + this._nonceLength));
                    }
                }
            }
            catch (NumberFormatException e) {
                FFDCFilter.processException((Throwable)e, WSNonceManagerImpl.class.getName() + ".WSNonceManagerImpl", "124", this);
                Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5190W", (Object)new Object[]{NONCE_LENGTH_KEY, nonceLengthStr, new Integer(nonceLength)});
                this._nonceLength = nonceLength;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Nonce length = " + this._nonceLength));
        }
        this.initSecureRandom();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"WSNonceManagerImpl(String cacheName, int cacheSize, int cacheTimeout,int nonceLength, boolean cacheDistributed)");
        }
    }

    public boolean validate(byte[] nonce) throws SoapSecurityException {
        ByteArray b;
        boolean retVal;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validate");
        }
        if (nonce == null || nonce.length == 0) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC0121E");
            throw SoapSecurityException.format("security.wssecurity.WSEC0121E");
        }
        if (this._cache == null) {
            String key = this._bServer ? ".WSEC0122E" : ".WSEC0123E";
            Tr.error((TraceComponent)tc, (String)(comp + key));
            throw SoapSecurityException.format(comp + key);
        }
        if (tc.isDebugEnabled()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(nonce, 0, nonce.length);
            Tr.debug((TraceComponent)tc, (String)"validating ", (Object)out.toString());
        }
        boolean bl = retVal = !this._cache.contains(b = new ByteArray(nonce));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("validate returns " + retVal));
        }
        return retVal;
    }

    public byte[] generate() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"generate()");
        }
        byte[] nonce = null;
        if (this._random != null) {
            nonce = new byte[this._nonceLength];
            this._random.nextBytes(nonce);
            if (tc.isEntryEnabled()) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                out.write(nonce, 0, nonce.length);
                Tr.exit((TraceComponent)tc, (String)"generate", (Object)out.toString());
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No random number generator");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"generate returns null");
            }
        }
        return nonce;
    }

    private void initSecureRandom() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initSecureRandom()");
        }
        String jceProvider = Security.getProperty(DEFAULT_JCE_PROVIDER);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JCE Default Provider is " + jceProvider));
        }
        if (jceProvider == null || jceProvider.length() == 0) {
            jceProvider = IBMJCE;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("JCE Default Provider is null, force to use: " + jceProvider));
            }
        }
        try {
            this._random = SecureRandom.getInstance(IBMSEC_RANDOM, jceProvider);
        }
        catch (NoSuchAlgorithmException e) {
            String msgKey = "security.wssecurity.WSEC5195E";
            Tr.warning((TraceComponent)tc, (String)msgKey, (Object)new Object[]{IBMSEC_RANDOM, jceProvider, e});
        }
        catch (NoSuchProviderException e) {
            String msgKey = "security.wssecurity.WSEC5195E";
            Tr.warning((TraceComponent)tc, (String)msgKey, (Object)new Object[]{IBMSEC_RANDOM, jceProvider, e});
        }
        byte[] genBytes = new byte[this._nonceLength];
        this._random.nextBytes(genBytes);
        this._random.setSeed(SecurityUIDGenerator.createUID().getBytes());
        this._random.nextBytes(genBytes);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initSecureRandom()");
        }
    }

    public String toString() {
        return clsName;
    }
}

