/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.wsspi.wssecurity.auth.callback.BinaryTokenCallback;
import com.ibm.wsspi.wssecurity.auth.callback.PropertyCallback;
import com.ibm.wsspi.wssecurity.auth.callback.XMLTokenReceiverCallback;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class WSDefaultTokenCallbackHandler
implements CallbackHandler {
    private String username = null;
    private char[] password = null;
    private byte[] tokenBytes = null;
    private Element xmlToken = null;
    private Document message = null;
    private Map properties = null;
    private static final TraceComponent tc = Tr.register(WSDefaultTokenCallbackHandler.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");

    public WSDefaultTokenCallbackHandler(String username, char[] password, byte[] tokenBytes, Element xmlToken, Document message, Map properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSDefaultTokenCallbackHandler");
        }
        this.username = username;
        this.password = password;
        this.tokenBytes = tokenBytes;
        this.xmlToken = xmlToken;
        this.message = message;
        this.properties = properties;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSDefaultTokenCallbackHandler");
        }
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handle");
        }
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                ((NameCallback)callbacks[i]).setName(this.username);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                ((PasswordCallback)callbacks[i]).setPassword(this.password);
                continue;
            }
            if (callbacks[i] instanceof BinaryTokenCallback) {
                ((BinaryTokenCallback)callbacks[i]).setCredToken(this.tokenBytes);
                continue;
            }
            if (callbacks[i] instanceof WSCredTokenCallbackImpl) {
                ((WSCredTokenCallbackImpl)callbacks[i]).setCredToken(this.tokenBytes);
                continue;
            }
            if (callbacks[i] instanceof XMLTokenReceiverCallback) {
                XMLTokenReceiverCallback callback = (XMLTokenReceiverCallback)callbacks[i];
                callback.setXMLToken(this.xmlToken);
                callback.setSOAPMessage(this.message);
                continue;
            }
            if (callbacks[i] instanceof PropertyCallback) {
                ((PropertyCallback)callbacks[i]).setProperties(this.properties);
                continue;
            }
            Tr.error(tc, "security.wssecurity.unsupport.callback", new Object[]{this.getClass().getName(), callbacks[i]});
            throw new UnsupportedCallbackException(callbacks[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exit");
        }
    }
}

