/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler.token;

import com.ibm.ws.webservices.wssecurity.handler.token.CertCache;
import com.ibm.ws.webservices.wssecurity.token.CertCacheManager;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.cert.Certificate;

public class WSCertCacheManagerImpl
implements CertCacheManager {
    private static final TraceComponent tc = Tr.register(WSCertCacheManagerImpl.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSCertCacheManagerImpl.class.getName();
    private CertCache _cache = null;

    public WSCertCacheManagerImpl(String cacheName, int cacheSize, int cacheTimeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("WSCertCacheManagerImpl(String cacheName[" + cacheName + "]," + "int cacheSize[" + cacheSize + "]," + "int cacheTimeout[" + cacheTimeout + "])"));
        }
        int size = ConfigConstants.validCertCacheSize(cacheSize);
        int timeout = ConfigConstants.validCertCacheTimeout(cacheTimeout);
        if (cacheName == null || cacheName.length() == 0) {
            cacheName = "WSSCertCache";
        }
        this._cache = new CertCache(cacheName, size, timeout * 1000, true, false);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"WSCertCacheManagerImpl(String cacheName, int cacheSize, int cacheTimeout)");
        }
    }

    public Certificate getCachedCert(String key) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCachedCert(String key[" + key + "])"));
        }
        Certificate cert = null;
        if (key == null || key.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The specified key is null or zero length.");
            }
        } else if (this._cache == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The certificate cache is null.");
            }
        } else {
            Object obj = this._cache.get(key);
            if (obj == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("There is no object linked with the specified key [" + key + "]."));
                }
            } else if (obj instanceof Certificate) {
                cert = (Certificate)obj;
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("There is an object linked with the specified key [" + key + "].  But it's not the Certificate object: " + obj.getClass().getName()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCachedCert(String key) returns Certificate[" + cert + "]"));
        }
        return cert;
    }

    public void cacheCert(String key, Certificate cert) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("cacheCert(String key[" + key + "]," + "Certificate cert[" + cert + "]"));
        }
        if (key == null || key.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The specified key is null or zero length.");
            }
        } else if (cert == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The specified certificate is null.");
            }
        } else if (this._cache == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The certificate cache is null.");
            }
        } else {
            this._cache.put(key, cert);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cacheCert(String key, Token token");
        }
    }
}

