/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler.token;

import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.webservices.wssecurity.handler.token.CacheEntry;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Hashtable;
import java.util.Vector;

class TokenCache
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(TokenCache.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = TokenCache.class.getName();
    private static final String comp = "security.wssecurity";
    private Hashtable _table;
    private Hashtable _secondaryTable;
    private Hashtable _tertiaryTable;
    private int _minSize = 0;
    private boolean _wipeCache;
    private Alarm _defaultAlarm;

    public TokenCache(String cacheName, int size, int timeout, boolean wipeCache, boolean cacheDistributed) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("TokenCache(String cacheName[" + cacheName + "]," + "int size[" + size + "]," + "int timeout[" + timeout + "]," + "boolean wipeCache[" + wipeCache + "]," + "boolean cacheDistributed[" + cacheDistributed + "]"));
        }
        this._defaultAlarm = new Alarm(timeout);
        this._table = new Hashtable(size);
        this._secondaryTable = new Hashtable(size);
        this._tertiaryTable = new Hashtable(size);
        this._minSize = size;
        this._wipeCache = wipeCache;
        this.addAlarmListener(this, timeout);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"TokenCache(String cacheName, int size, int timeout, boolean wipeCache, boolean cacheDistributed");
        }
    }

    public Object get(Object key) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("get(Object key[" + key + "]"));
            Tr.debug((TraceComponent)tc, (String)("key class is " + key.getClass().getName()));
        }
        Object retValue = null;
        Hashtable tableRef = null;
        CacheEntry curEntry = (CacheEntry)this._table.get(key);
        if (curEntry == null) {
            curEntry = (CacheEntry)this._secondaryTable.get(key);
            if (curEntry == null) {
                curEntry = (CacheEntry)this._tertiaryTable.get(key);
                if (curEntry != null) {
                    tableRef = this._tertiaryTable;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found cached token corresponding the key [" + key + "] in the tertiary table."));
                    }
                }
            } else {
                tableRef = this._secondaryTable;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found cached token corresponding the key [" + key + "] in the secondary table."));
                }
            }
            if (curEntry != null) {
                this._table.put(key, curEntry);
                tableRef.remove(key);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Found cached token corresponding the key [" + key + "] in the firs table."));
        }
        if (curEntry != null) {
            retValue = curEntry.getValue();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("get(Object key) returns Object[" + curEntry + "]"));
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, Object value) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("put(Object key[" + key + "], Object value[" + value + "]"));
            Tr.debug((TraceComponent)tc, (String)("key class is " + key.getClass().getName()));
        }
        if (key != null && value != null) {
            if (tc.isEntryEnabled() && (this._table.size() + this._secondaryTable.size() + this._tertiaryTable.size()) % 100 == 0) {
                StringBuffer sb = new StringBuffer(this.getClass().getName());
                sb.append(" number of entries: ");
                sb.append(this._table.size() + this._secondaryTable.size() + this._tertiaryTable.size());
                Tr.debug((TraceComponent)tc, (String)sb.toString());
            }
            Hashtable hashtable = this._table;
            synchronized (hashtable) {
                this._table.put(key, new CacheEntry(key, value));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Cached the specified token corresponding the key [" + key + "] in the secondary table."));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"put(Object key, Object value)");
        }
    }

    protected void mark() {
        if (this._wipeCache) {
            this._tertiaryTable.clear();
        } else {
            this._tertiaryTable.putAll(this._secondaryTable);
        }
        this._secondaryTable = this._table;
        this._table = new Hashtable(this._minSize > this._secondaryTable.size() ? this._minSize : this._secondaryTable.size() + 100);
    }

    public void alarm(Object alarmCtx) {
        long startTime = System.currentTimeMillis();
        this.mark();
        if (tc.isEntryEnabled()) {
            StringBuffer sb = new StringBuffer(this.getClass().getName());
            sb.append(" Time elapsed cleaning cache: ");
            sb.append(System.currentTimeMillis() - startTime);
            sb.append(" milliseconds, Primary cache size: ");
            sb.append(this._table.size());
            sb.append(", Secondary cache size: ");
            sb.append(this._secondaryTable.size());
            sb.append(", Tertiary cache size: ");
            sb.append(this._tertiaryTable.size());
            Tr.debug((TraceComponent)tc, (String)sb.toString());
        }
    }

    private void addAlarmListener(AlarmListener al, long to) {
        if (to == this._defaultAlarm.getTimeout()) {
            this._defaultAlarm.addAlarmListener(al);
        } else {
            Alarm alarm = new Alarm(to);
            alarm.addAlarmListener(al);
        }
    }

    private class Alarm
    implements AlarmListener {
        private Vector alarms = new Vector();
        private long timeout;

        public void addAlarmListener(AlarmListener al) {
            this.alarms.addElement(al);
        }

        public Alarm(long to) {
            this.timeout = to / 2L;
            this.alarm(null);
        }

        public void alarm(Object alarmCtx) {
            for (int i = 0; i < this.alarms.size(); ++i) {
                ((AlarmListener)this.alarms.elementAt(i)).alarm(alarmCtx);
            }
            AlarmManager.create(this.timeout, this);
        }

        public long getTimeout() {
            return this.timeout * 2L;
        }
    }
}

