/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler.token;

import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.ws.webservices.wssecurity.handler.token.CacheEntry;
import com.ibm.ws.webservices.wssecurity.util.DistributedMapFactory;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

class NonceCache
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(NonceCache.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = NonceCache.class.getName();
    private static final String comp = "security.wssecurity";
    private static final String DEFAULT_VALUE = "exist";
    private Hashtable _table;
    private Hashtable _secondaryTable;
    private Hashtable _tertiaryTable;
    private int _minSize = 0;
    private boolean _wipeCache;
    private Alarm _defaultAlarm;
    private String _cacheName;
    private DistributedMap _dm;
    private boolean _dmInitialized;
    private int _timeout;

    public NonceCache(String cacheName, int size, int timeout, boolean wipeCache, boolean cacheDistributed) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("NonceCache(String cacheName[" + cacheName + "]," + "int size[" + size + "]," + "int timeout[" + timeout + "]," + "boolean wipeCache[" + wipeCache + "]," + "boolean cacheDistributed[" + cacheDistributed + "]"));
        }
        this._defaultAlarm = new Alarm(timeout);
        this._table = new Hashtable(size);
        this._secondaryTable = new Hashtable(size);
        this._tertiaryTable = new Hashtable(size);
        this._minSize = size;
        this._wipeCache = wipeCache;
        this.addAlarmListener(this, timeout);
        this._dm = null;
        this._timeout = timeout;
        if (cacheDistributed && WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Initializing DistributedMap for nonce.");
            }
            if (cacheName == null || cacheName.length() == 0) {
                cacheName = "NonceDistributionCacheMap";
            }
            Properties p = new Properties();
            p.put("com.ibm.ws.cache.CacheConfig.cacheSize", Integer.toString(size));
            p.put("com.ibm.ws.cache.CacheConfig.enableDiskOffload", "false");
            p.put("com.ibm.ws.cache.CacheConfig.diskOffloadLocation", "");
            this._dm = DistributedMapFactory.getMap(cacheName, p);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"NonceCache(String cacheName, int size, int timeout, boolean wipeCache, boolean cacheDistributed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object key) {
        Object obj;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"contains");
            StringBuffer sb = new StringBuffer("Key = ");
            sb.append(key.toString());
            sb.append(", key class is ");
            sb.append(key.getClass().getName());
            Tr.debug((TraceComponent)tc, (String)sb.toString());
        }
        boolean retValue = true;
        Hashtable tableRef = null;
        CacheEntry curEntry = null;
        if (this._dm != null && (obj = this._dm.get(key)) instanceof CacheEntry) {
            curEntry = (CacheEntry)obj;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found distributed nonce corresponding the key [" + key + "]."));
            }
            if (curEntry != null) {
                this._table.put(key, curEntry);
            }
        }
        if (curEntry == null) {
            curEntry = (CacheEntry)this._table.get(key);
            if (curEntry == null) {
                curEntry = (CacheEntry)this._secondaryTable.get(key);
                if (curEntry == null) {
                    curEntry = (CacheEntry)this._tertiaryTable.get(key);
                    if (curEntry != null) {
                        tableRef = this._tertiaryTable;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Found cached nonce corresponding the key [" + key + "] in the tertiary table."));
                        }
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found cached nonce corresponding the key [" + key + "] in the secondary table."));
                    }
                    tableRef = this._secondaryTable;
                }
                if (curEntry == null) {
                    Hashtable hashtable = this._table;
                    synchronized (hashtable) {
                        if (tc.isEntryEnabled() && (this._table.size() + this._secondaryTable.size() + this._tertiaryTable.size()) % 100 == 0) {
                            StringBuffer sb = new StringBuffer(this.getClass().getName());
                            sb.append(" number of entries: ");
                            sb.append(this._table.size() + this._secondaryTable.size() + this._tertiaryTable.size());
                            Tr.debug((TraceComponent)tc, (String)sb.toString());
                        }
                        if ((curEntry = (CacheEntry)this._table.get(key)) == null) {
                            curEntry = new CacheEntry(key, new Date());
                            this._table.put(key, curEntry);
                            retValue = false;
                            if (this._dm != null) {
                                this._dm.put(key, (Object)curEntry, 1, this._timeout, 2, null);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Created a new cache corresponding the key [" + key + "]."));
                            }
                        }
                    }
                } else {
                    this._table.put(key, curEntry);
                    tableRef.remove(key);
                    if (this._dm != null) {
                        this._dm.put(key, (Object)curEntry, 1, this._timeout, 2, null);
                    }
                }
            } else {
                if (this._dm != null) {
                    this._dm.put(key, (Object)curEntry, 1, this._timeout, 2, null);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found cached nonce corresponding the key [" + key + "] in the firs table."));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("contains returns " + retValue));
        }
        return retValue;
    }

    protected void mark() {
        if (this._wipeCache) {
            this._tertiaryTable.clear();
        } else {
            this._tertiaryTable.putAll(this._secondaryTable);
        }
        this._secondaryTable = this._table;
        this._table = new Hashtable(this._minSize > this._secondaryTable.size() ? this._minSize : this._secondaryTable.size() + 100);
    }

    public void alarm(Object alarmCtx) {
        long startTime = System.currentTimeMillis();
        this.mark();
        if (tc.isEntryEnabled()) {
            StringBuffer sb = new StringBuffer(this.getClass().getName());
            sb.append(" Time elapsed cleaning cache: ");
            sb.append(System.currentTimeMillis() - startTime);
            sb.append(" milliseconds, Primary cache size: ");
            sb.append(this._table.size());
            sb.append(", Secondary cache size: ");
            sb.append(this._secondaryTable.size());
            sb.append(", Tertiary cache size: ");
            sb.append(this._tertiaryTable.size());
            Tr.debug((TraceComponent)tc, (String)sb.toString());
        }
    }

    private void addAlarmListener(AlarmListener al, long to) {
        if (to == this._defaultAlarm.getTimeout()) {
            this._defaultAlarm.addAlarmListener(al);
        } else {
            Alarm alarm = new Alarm(to);
            alarm.addAlarmListener(al);
        }
    }

    private class Alarm
    implements AlarmListener {
        private Vector alarms = new Vector();
        private long timeout;

        public void addAlarmListener(AlarmListener al) {
            this.alarms.addElement(al);
        }

        public Alarm(long to) {
            this.timeout = to / 2L;
            this.alarm(null);
        }

        public void alarm(Object alarmCtx) {
            for (int i = 0; i < this.alarms.size(); ++i) {
                ((AlarmListener)this.alarms.elementAt(i)).alarm(alarmCtx);
            }
            AlarmManager.create(this.timeout * 1000L, this);
        }

        public long getTimeout() {
            return this.timeout * 2L;
        }
    }
}

