/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.handler.WSSoapSecuritySenderBase;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.proxy.MessageContextProxy;
import com.ibm.xml.soapsec.token.SenderLogin;
import com.ibm.xml.soapsec.token.TokenRequest;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;

public class WSSenderLogin
extends SenderLogin {
    private static final TraceComponent tc = Tr.register(WSSenderLogin.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSenderLogin.class.getName();
    private String targetPort = null;
    private WSSoapSecuritySenderBase soapSecuritySender = null;
    private MessageContextProxy context = null;
    boolean isServer = true;

    public WSSenderLogin(WSSoapSecuritySenderBase _soapSecuritySender, MessageContextProxy _context, boolean _isServer) {
        this.soapSecuritySender = _soapSecuritySender;
        this.context = _context;
        this.isServer = _isServer;
    }

    protected void cacheUsernameTokenByTargetPort(TokenRequest.Username username_token) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cacheUsernameTokenByTargetPort", (Object)new Object[]{(String)this.soapSecuritySender.getMessageOption("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress"), username_token});
        }
        if (!this.isServer) {
            this.soapSecuritySender.saveTempObject("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.basicAuthToken", username_token);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cacheUsernameTokenByTargetPort");
        }
    }

    protected TokenRequest.Username retrieveUsernameTokenByTargetPort() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"retrieveUsernameTokenByTargetPort", (Object)new Object[]{(String)this.soapSecuritySender.getMessageOption("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress"), new Boolean(this.isServer)});
        }
        TokenRequest.Username token = null;
        if (!this.isServer) {
            token = (TokenRequest.Username)this.soapSecuritySender.getObject((String)this.soapSecuritySender.getMessageOption("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"retrieveUsernameTokenByTargetPort", (Object)new Object[]{token});
        }
        return token;
    }

    protected String getInitialSenderId() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInitialSenderId");
        }
        String id = null;
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        if (ctxMgr == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.ctxmgr.isnull");
            throw SoapSecurityException.format("security.wssecurity.ctxmgr.isnull");
        }
        final Subject s1 = (Subject)ctxMgr.get("wssecurity.initial.sender.id");
        if (tc.isDebugEnabled()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Tr.debug((TraceComponent)tc, (String)"Initial Sender", (Object)s1);
                    return null;
                }
            });
        }
        if (s1 != null) {
            WSCredential wscred = SubjectHelper.getWSCredentialFromSubject(s1);
            if (wscred != null) {
                try {
                    id = wscred.getSecurityName();
                }
                catch (Exception e) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.noprincipal.found");
                    throw SoapSecurityException.format("security.wssecurity.noprincipal.found");
                }
            } else {
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.nocred.found");
                throw SoapSecurityException.format("security.wssecurity.nocred.found");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInitialSenderId", id);
        }
        return id;
    }

    protected X509Certificate getInitialSenderCert() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInitialSenderCert");
        }
        X509Certificate cert = null;
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        if (ctxMgr == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.ctxmgr.isnull");
            throw SoapSecurityException.format("security.wssecurity.ctxmgr.isnull");
        }
        cert = (X509Certificate)ctxMgr.get("com.ibm.ws.wssecurity.OriginalCert");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Initial Sender Cert", (Object)cert);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInitialSenderCert", (Object)cert);
        }
        return cert;
    }
}

