/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSGenerator;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContext;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.WSSoapSecurityUtil;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.UsernameToken;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Node;

public class WSSecurityGeneratorBase
extends WSSGenerator {
    private static final TraceComponent tc = Tr.register(WSSecurityGeneratorBase.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityGeneratorBase.class.getName();
    public static final String OPTION = GlobalSecurityHandler.class.getName() + ".configPath";
    public static final String TARGET_PORT = GlobalSecurityHandler.class.getName() + ".targetPort";
    private final WSSecurityPlatformContext _contextManager = WSSecurityPlatformContextFactory.getInstance();
    private final ThreadLocal _threadStore = new ThreadLocal();
    private static Map _globalObjectCache = new HashMap();
    private boolean _initialized = false;

    public void init() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init()");
        }
        if (!this._initialized) {
            HashMap properties = new HashMap();
            super.init(properties);
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init()");
        }
    }

    public void invoke(SOAPMessageContext mcontext, WSSGeneratorConfig config) throws WebServicesFault {
        MessageContext wsmcontext;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(SOAPMessageContext mcontext[" + mcontext + "]," + "WSSGeneratorConfig config[" + config + "])"));
        }
        if (WSSoapSecurityUtil.getServiceHandler(wsmcontext = (MessageContext)mcontext) != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("com.ibm.wsspi.wssecurity.core.messageContext", mcontext);
            context.put("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey", config);
            try {
                super.invoke(null, null, context);
                if (tc.isDebugEnabled()) {
                    SOAPMessage message = wsmcontext.getMessage();
                    SOAPPart soapPart = message.getSOAPPart();
                    Tr.debug((TraceComponent)tc, (String)("The message processed by " + (this._contextManager.isServer() ? "server side" : "client side") + " " + this.getClass().getName() + " : " + DOMUtil.toString((Node)soapPart)));
                }
            }
            catch (SoapSecurityException e) {
                Tr.processException((Throwable)e, (String)(clsName + ".invoke"), (String)"111", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSSConsumer.s23", (Object)e);
                WebServicesFault fault = null;
                if (this._contextManager.isServer()) {
                    fault = e.getFaultCode() != null ? WebServicesFault.makeUserFault(e, e.getFaultCode()) : WebServicesFault.makeUserFault(e, new QName(Constants.NS_SOAP, "Server.securityException"));
                    wsmcontext.setCurrentMessage(new Message(fault));
                } else {
                    fault = WebServicesFault.makeUserFault(e, new QName(Constants.NS_SOAP, "Client.securityException"));
                }
                throw fault;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(SOAPMessageContext mcontext,WSSGeneratorConfig config)");
        }
    }

    public void retrieveCachedInformation(SOAPMessageContext context) throws SoapSecurityException {
        Object obj;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"retrieveCachedInformation(SOAPMessageContext context)");
        }
        if ((obj = this.getObject((String)this.getMessageOption("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress"))) != null && obj instanceof UsernameToken) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Retrieved username token found [" + obj + "]."));
            }
            context.setProperty("com.ibm.wsspi.wssecurity.username.basicAuthToken", obj);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Retrieved username token not found.");
            }
            context.removeProperty("com.ibm.wsspi.wssecurity.username.basicAuthToken");
        }
        String initialSenderId = this.getInitialSenderId();
        if (initialSenderId != null && initialSenderId.length() > 0) {
            UsernameToken unt = new UsernameToken(null, initialSenderId, null);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Retrieved identifier of initial sender found [" + unt + "]."));
            }
            context.setProperty("com.ibm.wsspi.wssecurity.username.initialSenderId", unt);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Retrieved identifier of initial sender not found.");
            }
            context.removeProperty("com.ibm.wsspi.wssecurity.username.initialSenderId");
        }
        X509Certificate initialCert = this.getInitialSenderCert();
        if (initialCert != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Retrieved cert of initial sender found [" + initialCert + "]."));
            }
            context.setProperty("com.ibm.wsspi.wssecurity.username.initialSenderCert", initialCert);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Retrieved cert of initial sender not found.");
            }
            context.removeProperty("com.ibm.wsspi.wssecurity.username.initialSenderCert");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"retrieveCachedInformation(SOAPMessageContext context)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObject(Object key) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getObject(Object key[" + key + "])"));
        }
        Object ret = null;
        if (key != null && (ret = this.getThreadStore().get(key)) == null) {
            Map map = _globalObjectCache;
            synchronized (map) {
                ret = _globalObjectCache.get(key);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getObject(Object key) " + (ret == null ? "not found" : "found")));
        }
        return ret;
    }

    protected void saveTempObject(String key, Object value) {
        SOAPMessageContext proxy;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("saveTempObject(String key[" + key + "], " + "Object value[XXXXXXXX])"));
        }
        if (!this._contextManager.isServer() && key != null && (proxy = (SOAPMessageContext)this.getMessageOption("A")) != null) {
            proxy.setProperty(key, value);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Data for " + key + " is saved to temporary store"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"saveTempObject(String key,Object value)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveObject(String key, Object value) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("saveObject(String key[" + key + "], " + "Object value[XXXXXXXX])"));
        }
        Object obj = null;
        Map map = _globalObjectCache;
        synchronized (map) {
            obj = _globalObjectCache.get(key);
            if (obj == null) {
                _globalObjectCache.put(key, value);
            }
        }
        this.getThreadStore().put(key, value);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Data for " + key + " is saved to global store"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"saveObject(String key,Object value)");
        }
    }

    private Map getThreadStore() {
        HashMap map = (HashMap)this._threadStore.get();
        if (map == null) {
            map = new HashMap();
            this._threadStore.set(map);
        }
        return map;
    }

    private String getInitialSenderId() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInitialSenderId()");
        }
        String id = null;
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        if (ctxMgr == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.ctxmgr.isnull");
            throw SoapSecurityException.format("security.wssecurity.ctxmgr.isnull");
        }
        Subject s1 = (Subject)ctxMgr.get("com.ibm.wsspi.wssecurity.username.initialSenderId");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Initial Sender is found.");
        }
        if (s1 != null) {
            WSCredential wscred = SubjectHelper.getWSCredentialFromSubject(s1);
            if (wscred != null) {
                try {
                    id = wscred.getSecurityName();
                }
                catch (Exception e) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.noprincipal.found");
                    throw SoapSecurityException.format("security.wssecurity.noprincipal.found");
                }
            } else {
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.nocred.found");
                throw SoapSecurityException.format("security.wssecurity.nocred.found");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInitialSenderId() returns String[" + id + "]"));
        }
        return id;
    }

    private X509Certificate getInitialSenderCert() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInitialSenderCert()");
        }
        X509Certificate cert = null;
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        if (ctxMgr == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.ctxmgr.isnull");
            throw SoapSecurityException.format("security.wssecurity.ctxmgr.isnull");
        }
        cert = (X509Certificate)ctxMgr.get("com.ibm.wsspi.wssecurity.username.initialSenderCert");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Initial Sender Cert", (Object)cert);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInitialSenderCert() returns X509Certificate[" + cert + "]"));
        }
        return cert;
    }
}

