/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSConsumer;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContext;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.WSSoapSecurityUtil;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Node;

public class WSSecurityConsumerBase
extends WSSConsumer {
    private static final TraceComponent tc = Tr.register(WSSecurityConsumerBase.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityConsumerBase.class.getName();
    public static final String OPTION = GlobalSecurityHandler.class.getName() + ".configPath";
    private final WSSecurityPlatformContext _contextManager = WSSecurityPlatformContextFactory.getInstance();
    private boolean _initialized = false;

    public void init() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init()");
        }
        if (!this._initialized) {
            HashMap properties = new HashMap();
            super.init(properties);
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init()");
        }
    }

    public void invoke(SOAPMessageContext mcontext, WSSConsumerConfig config) throws WebServicesFault {
        MessageContext wsmcontext;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(SOAPMessageContext mcontext[" + mcontext + "]," + "WSSConsumerConfig config[" + config + "])"));
        }
        if (WSSoapSecurityUtil.getServiceHandler(wsmcontext = (MessageContext)mcontext) != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("com.ibm.wsspi.wssecurity.core.messageContext", mcontext);
            context.put("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey", config);
            try {
                super.invoke(null, context);
                if (tc.isDebugEnabled()) {
                    SOAPMessage message = wsmcontext.getMessage();
                    SOAPPart soapPart = message.getSOAPPart();
                    Tr.debug((TraceComponent)tc, (String)("The message processed by " + (this._contextManager.isServer() ? "server side" : "client side") + " " + this.getClass().getName() + " : " + DOMUtil.toString((Node)soapPart)));
                }
            }
            catch (SoapSecurityException e) {
                Tr.processException((Throwable)e, (String)(clsName + ".invoke"), (String)"94", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSSConsumer.s23", (Object)e);
                if (this._contextManager.isServer()) {
                    if (e.getFaultCode() != null) {
                        throw WebServicesFault.makeUserFault(e, e.getFaultCode());
                    }
                    throw WebServicesFault.makeUserFault(e, new QName(Constants.NS_SOAP, "Server.securityException"));
                }
                throw WebServicesFault.makeUserFault(e, new QName(Constants.NS_SOAP, "Client.securityException"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(WSSMessageContext mcontext,WSSConsumerConfig config)");
        }
    }
}

