/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.SecurityResponseReceiverBindingConfig;
import com.ibm.etools.webservice.wscext.SecurityResponseReceiverServiceConfig;
import com.ibm.etools.webservice.wscommonbnd.CanonicalizationMethod;
import com.ibm.etools.webservice.wscommonbnd.CertPathSettings;
import com.ibm.etools.webservice.wscommonbnd.CertStoreList;
import com.ibm.etools.webservice.wscommonbnd.CertStoreRef;
import com.ibm.etools.webservice.wscommonbnd.CollectionCertStore;
import com.ibm.etools.webservice.wscommonbnd.DataEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.DigestMethod;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.EncryptionKey;
import com.ibm.etools.webservice.wscommonbnd.KeyEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.LDAPCertStore;
import com.ibm.etools.webservice.wscommonbnd.LDAPServer;
import com.ibm.etools.webservice.wscommonbnd.SignatureMethod;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchor;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchorRef;
import com.ibm.etools.webservice.wscommonbnd.TrustAnyCertificate;
import com.ibm.etools.webservice.wscommonbnd.X509Certificate;
import com.ibm.etools.webservice.wscommonext.AddReceivedTimestamp;
import com.ibm.etools.webservice.wscommonext.ConfidentialPart;
import com.ibm.etools.webservice.wscommonext.ConfidentialPartPart;
import com.ibm.etools.webservice.wscommonext.Reference;
import com.ibm.etools.webservice.wscommonext.ReferencePart;
import com.ibm.etools.webservice.wscommonext.RequiredConfidentiality;
import com.ibm.etools.webservice.wscommonext.RequiredIntegrity;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.util.ClientVariableMap;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.xml.soapsec.confimpl.PrivateReceiverConfig;
import com.ibm.xml.soapsec.dsig.VerificationSettings;
import com.ibm.xml.soapsec.enc.EncryptionSettings;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import java.io.File;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class WSEMFResponseReceiverConfig
extends PrivateReceiverConfig {
    private static Map keyStores = new Hashtable();
    private static Map certFactories = new Hashtable();
    private static Map certs = new Hashtable();
    private String origin = "non-ws-security";
    private static final TraceComponent tc = Tr.register(WSEMFResponseReceiverConfig.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSEMFResponseReceiverConfig.class.getName();

    public WSEMFResponseReceiverConfig(SecurityResponseReceiverBindingConfig resRecBnd, SecurityResponseReceiverServiceConfig resRecExt, String actorURI, VariableMap varMap, WSSecurityService service) throws SoapSecurityException {
        this(resRecBnd, resRecExt, actorURI, varMap, service, null, null);
    }

    public WSEMFResponseReceiverConfig(SecurityResponseReceiverBindingConfig resRecBnd, SecurityResponseReceiverServiceConfig resRecExt, String actorURI, VariableMap varMap, WSSecurityService service, ClassLoader appClassLoader) throws SoapSecurityException {
        this(resRecBnd, resRecExt, actorURI, varMap, service, null, null);
    }

    public WSEMFResponseReceiverConfig(SecurityResponseReceiverBindingConfig resRecBnd, SecurityResponseReceiverServiceConfig resRecExt, String actorURI, VariableMap varMap, WSSecurityService service, ClassLoader appClassLoader, PortQnameBinding portQnBnd) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFResponseReceiverConfig(SecurityResponseReceiverBindingConfig, SecurityResponseReceiverServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader, portQnBnd):", new Object[]{resRecBnd, resRecExt, actorURI, varMap, service, appClassLoader});
        }
        this.init(resRecBnd, resRecExt, actorURI, varMap, service, appClassLoader, portQnBnd);
        this.origin = "ws-security";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSEMFResponseReceiverConfig()");
        }
    }

    WSEMFResponseReceiverConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFResponseReceiverConfig()");
            Tr.exit(tc, "WSEMFResponseReceiverConfig()");
        }
    }

    final void init(SecurityResponseReceiverBindingConfig resRecBnd, SecurityResponseReceiverServiceConfig resRecExt, String actorURI, VariableMap varMap, WSSecurityService service, ClassLoader appClassLoader, PortQnameBinding portQnBnd) throws SoapSecurityException {
        int i;
        int count;
        String name;
        int i2;
        ConfigValidation valid;
        EList p;
        Object dconfig;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(SecurityResponseReceiverBindingConfig, SecurityResponseReceiverServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader, portQnBnd):", new Object[]{resRecBnd, resRecExt, actorURI, varMap, service, appClassLoader});
        }
        AddReceivedTimestamp addReceivedTimestamp = null;
        RequiredConfidentiality requiredConfidentiality = null;
        RequiredIntegrity requiredIntegrity = null;
        if (varMap == null) {
            varMap = ClientVariableMap.getInstance();
        }
        WSSecurityDefaultConfiguration config = null;
        if (service != null && (dconfig = service.getConfig()) instanceof WSSecurityDefaultConfiguration) {
            config = (WSSecurityDefaultConfiguration)dconfig;
        }
        Map defaultProps = null;
        Map extProperties = null;
        Map bndProperties = null;
        Map bndParameters = null;
        this._properties = new HashMap();
        if (config != null) {
            WSSConsumerConfig dcconfig = config.getDefaultConsumerBinding();
            if (dcconfig != null) {
                defaultProps = dcconfig.getProperties();
                if (defaultProps != null) {
                    this._properties.putAll(defaultProps);
                }
            } else {
                defaultProps = config.getProperties();
                if (defaultProps != null) {
                    this._properties.putAll(defaultProps);
                }
            }
        }
        if (resRecExt != null && (p = resRecExt.getProperties()) != null && (extProperties = ConfigConstants.getProperties(p, varMap)) != null) {
            this._properties.putAll(extProperties);
        }
        if (portQnBnd != null && (p = portQnBnd.getParameters()) != null && (bndParameters = ConfigConstants.getProperties(p, varMap)) != null) {
            this._properties.putAll(bndParameters);
        }
        if (resRecBnd != null && (p = resRecBnd.getProperties()) != null && (bndProperties = ConfigConstants.getProperties(p, varMap)) != null) {
            this._properties.putAll(bndProperties);
        }
        if (resRecExt != null) {
            addReceivedTimestamp = resRecExt.getAddReceivedTimeStamp();
            requiredConfidentiality = resRecExt.getRequiredConfidentiality();
            requiredIntegrity = resRecExt.getRequiredIntegrity();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Response Receiver Service Config (ReceivedTimeStamp, RequiredConfidentiality, RequiredIntegrity):", new Object[]{addReceivedTimestamp, requiredConfidentiality, requiredIntegrity});
            }
        }
        if (!(valid = new ConfigValidation(varMap, config)).requiredConfidentialityValid(requiredConfidentiality)) {
            throw new SoapSecurityException("Invalid RequiredConfidentiality");
        }
        if (!valid.requiredIntegrityValid(requiredIntegrity)) {
            throw new SoapSecurityException("Invalid RequiredIntegrity");
        }
        if (actorURI != null) {
            String tmpActor = actorURI.trim();
            if (tmpActor.length() != 0) {
                this.myactor = tmpActor;
            }
        } else {
            this.myactor = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "actorURI = " + this.myactor);
        }
        this.enableReceivedTimestamp = false;
        if (addReceivedTimestamp != null) {
            this.enableReceivedTimestamp = addReceivedTimestamp.isFlag();
        }
        if (requiredIntegrity != null) {
            int count2 = requiredIntegrity.getReferences().size();
            for (i2 = 0; i2 < count2; ++i2) {
                Reference ref = (Reference)requiredIntegrity.getReferences().get(i2);
                ReferencePart refPart = ref.getPart();
                name = refPart.getName();
                this.requiredIntegralParts.add(name);
            }
        }
        if (requiredConfidentiality != null) {
            int count3 = requiredConfidentiality.getConfidentialParts().size();
            for (i2 = 0; i2 < count3; ++i2) {
                ConfidentialPart confPart = (ConfidentialPart)requiredConfidentiality.getConfidentialParts().get(i2);
                ConfidentialPartPart confPartPart = confPart.getPart();
                name = confPartPart.getName();
                this.requiredConfidentialParts.add(name);
            }
        }
        CertStoreList certStoreList = null;
        EList encryptionInfos = null;
        EList keyLocators = null;
        EList signingInfos = null;
        EList trustAnchors = null;
        if (resRecBnd != null) {
            certStoreList = resRecBnd.getCertStoreList();
            encryptionInfos = resRecBnd.getEncryptionInfos();
            keyLocators = resRecBnd.getKeyLocators();
            signingInfos = resRecBnd.getSigningInfos();
            trustAnchors = resRecBnd.getTrustAnchors();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Response Receiver Binding Config (CertStoreList, EncryptionInfos, KeyLocators, SigningInfos, TrustAnchors):", new Object[]{certStoreList, encryptionInfos, keyLocators, signingInfos, trustAnchors});
            }
        }
        this._bypassSecurityHeader = ConfigUtil.getIsTruePropertyEnv((Map)this._properties, (String)"com.ibm.wsspi.wssecurity.config.disableWSSIfApplicationSecurityDisabled");
        if (!valid.receiverSigningInfoValid(signingInfos, trustAnchors, certStoreList, requiredIntegrity)) {
            throw new SoapSecurityException("Invalid receiver SigningInfo");
        }
        if (!valid.encryptionInfosValid(encryptionInfos, keyLocators, requiredConfidentiality)) {
            throw new SoapSecurityException("Invalid EncryptionInfo");
        }
        if (encryptionInfos != null) {
            count = encryptionInfos.size();
            for (i = 0; i < count; ++i) {
                EncryptionInfo encryptionInfo = (EncryptionInfo)encryptionInfos.get(i);
                EncryptionKey encryptionKey = encryptionInfo.getEncryptionKey();
                String encKeyName = null;
                String encKeyLocRef = null;
                if (encryptionKey != null) {
                    encKeyName = encryptionKey.getName();
                    encKeyLocRef = encryptionKey.getLocatorRef();
                }
                KeyLocator locator = ConfigConstants.findKeyLocator(keyLocators, encKeyLocRef, varMap, config, appClassLoader);
                DataEncryptionMethod dataEncryptionMethod = encryptionInfo.getEncryptionMethod();
                String dataEncAlg = null;
                if (dataEncryptionMethod != null) {
                    dataEncAlg = dataEncryptionMethod.getAlgorithm();
                }
                KeyEncryptionMethod keyEncryptionMethod = encryptionInfo.getKeyEncryptionMethod();
                String keyEncAlg = null;
                if (keyEncryptionMethod != null) {
                    keyEncAlg = keyEncryptionMethod.getAlgorithm();
                }
                if (dataEncAlg == null || encKeyName == null || locator == null) {
                    String msgKey = "security.wssecurity.IncompleteEncryptionInfo";
                    if (dataEncAlg == null) {
                        Tr.warning(tc, msgKey, "Data Encryption Algorithm");
                    }
                    if (encKeyName == null) {
                        Tr.warning(tc, msgKey, "Encryption Key Name");
                    }
                    if (locator == null) {
                        Tr.warning(tc, msgKey, "Key Locator");
                    }
                }
                this.encryptionSettingsList.add(new EncryptionSettings(dataEncAlg, keyEncAlg, encKeyName, locator));
            }
        }
        if (signingInfos != null) {
            count = signingInfos.size();
            for (i = 0; i < count; ++i) {
                CertPathSettings certPathSettings;
                TrustAnyCertificate trustAnyCertificate;
                PKIXBuilderParameters params = null;
                Provider provider = null;
                HashSet<java.security.cert.X509Certificate> eeCerts = new HashSet<java.security.cert.X509Certificate>();
                String anchorRef = null;
                String storeRef = null;
                boolean trustAny = false;
                SigningInfo signingInfo = (SigningInfo)signingInfos.get(i);
                CanonicalizationMethod c14nMethod = signingInfo.getCanonicalizationMethod();
                String c14nAlgorithm = null;
                if (c14nMethod == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No CanonicalizationMethod defined");
                    }
                } else {
                    c14nAlgorithm = c14nMethod.getAlgorithm();
                }
                SignatureMethod signatureMethod = signingInfo.getSignatureMethod();
                String signatureAlgorithm = null;
                if (signatureMethod == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No SignatureMethod defined");
                    }
                } else {
                    signatureAlgorithm = signatureMethod.getAlgorithm();
                }
                DigestMethod digestMethod = signingInfo.getDigestMethod();
                String digestAlgorithm = null;
                if (digestMethod == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No DigestMethod defined");
                    }
                } else {
                    digestAlgorithm = digestMethod.getAlgorithm();
                }
                if ((trustAnyCertificate = (certPathSettings = signingInfo.getCertPathSettings()).getTrustAnyCertificate()) != null) {
                    trustAny = true;
                } else {
                    String csp;
                    HashMap tempMap;
                    String msgKey;
                    KeyStore keyStore = null;
                    TrustAnchorRef trustAnchorRef = certPathSettings.getTrustAnchorRef();
                    anchorRef = trustAnchorRef.getRef();
                    boolean foundTA = false;
                    for (int j = 0; j < trustAnchors.size(); ++j) {
                        TrustAnchor trustAnchor = (TrustAnchor)trustAnchors.get(j);
                        if (!anchorRef.equals(trustAnchor.getName())) continue;
                        com.ibm.etools.webservice.wscommonbnd.KeyStore keyStoreData = trustAnchor.getKeyStore();
                        String file = null;
                        file = varMap == null ? keyStoreData.getPath() : varMap.expand(keyStoreData.getPath());
                        keyStore = ConfigUtil.getKeyStore((String)keyStoreData.getType(), (String)file, (char[])keyStoreData.getStorepass().toCharArray());
                        foundTA = true;
                        break;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "(from application binding) Keystore for TrustAnchor: " + anchorRef + " = " + keyStore + "Found = " + foundTA);
                    }
                    if (!foundTA && config != null) {
                        keyStore = config.getTrustAnchor(anchorRef);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "(from default binding) Keystore for TrustAnchor: " + anchorRef + " = " + keyStore);
                        }
                    }
                    if (keyStore == null) {
                        throw SoapSecurityException.format("security.wssecurity.ConfigValidation.keystore.taref.open", anchorRef);
                    }
                    try {
                        X509CertSelector selector = new X509CertSelector();
                        params = new PKIXBuilderParameters(keyStore, (CertSelector)selector);
                        params.setDate(null);
                    }
                    catch (InvalidAlgorithmParameterException e) {
                        msgKey = "security.wssecurity.CommonReceiverConfig.s12";
                        FFDCFilter.processException((Throwable)e, clsName + ".WSEMFResponseReceiverConfig", "384", (Object)this);
                        Tr.error(tc, msgKey);
                        throw SoapSecurityException.format(msgKey, e);
                    }
                    catch (KeyStoreException e) {
                        msgKey = "security.wssecurity.CommonReceiverConfig.s12";
                        FFDCFilter.processException((Throwable)e, clsName + ".WSEMFResponseReceiverConfig", "389", (Object)this);
                        Tr.error(tc, msgKey);
                        throw SoapSecurityException.format(msgKey, e);
                    }
                    CertStoreRef certStoreRef = certPathSettings.getCertStoreRef();
                    if (certStoreRef != null) {
                        storeRef = certStoreRef.getRef();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "CertStoreRef = " + storeRef);
                    }
                    boolean certStoreFound = false;
                    if (certStoreList != null) {
                        String msgKey2;
                        EList collectionCertStores = certStoreList.getCollectionCertStores();
                        int length = collectionCertStores.size();
                        for (int j = 0; j < length; ++j) {
                            CollectionCertStore collectionStore = (CollectionCertStore)collectionCertStores.get(j);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "collectionCertStores.get(" + j + ") = " + collectionStore.getName());
                            }
                            if (storeRef == null || !storeRef.equals(collectionStore.getName())) continue;
                            provider = Security.getProvider(collectionStore.getProvider());
                            EList x509s = collectionStore.getX509Certificates();
                            int length2 = x509s.size();
                            HashMap<String, CertificateFactory> cache = new HashMap<String, CertificateFactory>();
                            for (int k = 0; k < length2; ++k) {
                                X509Certificate x509 = (X509Certificate)x509s.get(k);
                                String path = null;
                                path = varMap == null ? x509.getPath() : varMap.expand(x509.getPath());
                                String provider2 = "";
                                CertificateFactory cfac = (CertificateFactory)cache.get(provider2);
                                if (cfac == null) {
                                    cfac = ConfigUtil.createCertificateFactory((String)provider2);
                                    cache.put(provider2, cfac);
                                }
                                File f = new File(path);
                                eeCerts.add(ConfigUtil.getX509Certificate((File)f, (CertificateFactory)cfac));
                            }
                            String algorithm = "Collection";
                            CollectionCertStoreParameters cparams = null;
                            try {
                                cparams = new CollectionCertStoreParameters(eeCerts);
                                CertStore certStore = null;
                                certStore = "".equals(provider) ? CertStore.getInstance(algorithm, cparams) : CertStore.getInstance(algorithm, (CertStoreParameters)cparams, provider);
                                params.addCertStore(certStore);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found CertStore for " + storeRef);
                                }
                                certStoreFound = true;
                                break;
                            }
                            catch (NoSuchAlgorithmException e) {
                                msgKey2 = "security.wssecurity.CommonReceiverConfig.s20";
                                Tr.error(tc, msgKey2, new Object[]{algorithm});
                                throw SoapSecurityException.format(msgKey2, algorithm, (Throwable)e);
                            }
                            catch (InvalidAlgorithmParameterException e) {
                                msgKey2 = "security.wssecurity.CommonReceiverConfig.s21";
                                Tr.error(tc, msgKey2, new Object[]{cparams.toString() == null ? "" : cparams.toString()});
                                throw SoapSecurityException.format(msgKey2, cparams.toString() == null ? "" : cparams.toString(), (Throwable)e);
                            }
                            catch (Throwable e) {
                                msgKey2 = "security.wssecurity.load.collectioncertstore.failed";
                                Tr.error(tc, msgKey2, new Object[]{collectionStore.getName(), e});
                                String message = MessageFormat.format(ConfigUtil.getMessage((String)msgKey2), collectionStore.getName(), e.getMessage());
                                throw new SoapSecurityException(message);
                            }
                        }
                        if (!certStoreFound) {
                            EList ldapCertStores = certStoreList.getLdapCertStores();
                            int length2 = ldapCertStores.size();
                            for (int j = 0; j < length2; ++j) {
                                CertStore certStore;
                                int port;
                                LDAPCertStore ldapCertStore = (LDAPCertStore)ldapCertStores.get(j);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "ldapCertStores.get(" + j + ") = " + ldapCertStore.getName());
                                }
                                if (storeRef == null || !storeRef.equals(ldapCertStore.getName())) continue;
                                LDAPServer ldapServer = ldapCertStore.getLdapServer();
                                String host = ldapServer.getHost();
                                try {
                                    port = Integer.parseInt(ldapServer.getPort());
                                }
                                catch (NumberFormatException e) {
                                    msgKey2 = "security.wssecurity.CommonReceiverConfig.s19";
                                    String arg = ldapServer.getPort();
                                    FFDCFilter.processException((Throwable)e, clsName + ".CommonReceiverConfig", "493", (Object)this);
                                    Tr.error(tc, msgKey2, arg);
                                    throw SoapSecurityException.format(msgKey2, arg, (Throwable)e);
                                }
                                String algorithm = "LDAP";
                                provider = Security.getProvider(ldapCertStore.getProvider());
                                LDAPCertStoreParameters ldapParams = new LDAPCertStoreParameters(host, port);
                                try {
                                    certStore = "".equals(provider) ? CertStore.getInstance(algorithm, ldapParams) : CertStore.getInstance(algorithm, (CertStoreParameters)ldapParams, provider);
                                }
                                catch (NoSuchAlgorithmException e) {
                                    String msgKey3 = "security.wssecurity.CommonReceiverConfig.s20";
                                    FFDCFilter.processException((Throwable)e, clsName + ".CommonReceiverConfig", "509", (Object)this);
                                    Tr.error(tc, msgKey3, algorithm);
                                    throw SoapSecurityException.format(msgKey3, algorithm);
                                }
                                catch (InvalidAlgorithmParameterException e) {
                                    String msgKey4 = "security.wssecurity.CommonReceiverConfig.s21";
                                    FFDCFilter.processException((Throwable)e, clsName + ".CommonReceiverConfig", "514", (Object)this);
                                    Tr.error(tc, msgKey4, params.toString());
                                    throw SoapSecurityException.format(msgKey4, params.toString());
                                }
                                params.addCertStore(certStore);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found CertStore for " + storeRef);
                                }
                                certStoreFound = true;
                                break;
                            }
                        }
                    }
                    if (!certStoreFound && storeRef != null && config != null) {
                        CertStore cs = config.getCertStore(storeRef);
                        if (cs == null) {
                            String msgKey5 = "security.wssecurity.ConfigValidation.csref.notfound";
                            Tr.error(tc, msgKey5, new Object[]{storeRef});
                            throw SoapSecurityException.format(msgKey5, storeRef);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found CertStore for " + storeRef);
                        }
                        params.addCertStore(cs);
                    }
                    if (anchorRef != null && provider == null && (provider = ConfigUtil.setupCertStoreProvider((Map)this._properties, tempMap = new HashMap(), null)) == null && ConfigUtil.hasValue((String)(csp = (String)tempMap.get("com.ibm.wsspi.wssecurity.config.CertStore.Provider")))) {
                        throw new SoapSecurityException("The cert store security provider '" + csp + "' does not exist.  The cert store security provider is " + "configured on the '" + "com.ibm.wsspi.wssecurity.config.CertStore.Provider" + "' property.");
                    }
                }
                this.verificationSettingsList.add(new VerificationSettings(c14nAlgorithm, digestAlgorithm, signatureAlgorithm, params, provider, eeCerts, anchorRef, storeRef, trustAny));
            }
        }
        this.processPrivateConfig(DOMUtil.getPrivateConfig((boolean)false));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.getLogProperties(defaultProps, bndParameters, extProperties, bndProperties, "response", "receiver"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    final String getOrigin() {
        return this.origin;
    }
}

