/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wsbnd.PCBinding;
import com.ibm.etools.webservice.wsbnd.SecurityRequestReceiverBindingConfig;
import com.ibm.etools.webservice.wscommonbnd.CanonicalizationMethod;
import com.ibm.etools.webservice.wscommonbnd.CertPathSettings;
import com.ibm.etools.webservice.wscommonbnd.CertStoreList;
import com.ibm.etools.webservice.wscommonbnd.CertStoreRef;
import com.ibm.etools.webservice.wscommonbnd.CollectionCertStore;
import com.ibm.etools.webservice.wscommonbnd.DataEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.DigestMethod;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.EncryptionKey;
import com.ibm.etools.webservice.wscommonbnd.KeyEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.LDAPCertStore;
import com.ibm.etools.webservice.wscommonbnd.LDAPServer;
import com.ibm.etools.webservice.wscommonbnd.LoginMapping;
import com.ibm.etools.webservice.wscommonbnd.SignatureMethod;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchor;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchorRef;
import com.ibm.etools.webservice.wscommonbnd.TrustAnyCertificate;
import com.ibm.etools.webservice.wscommonbnd.TrustedIDEvaluatorRef;
import com.ibm.etools.webservice.wscommonbnd.X509Certificate;
import com.ibm.etools.webservice.wscommonext.AddReceivedTimestamp;
import com.ibm.etools.webservice.wscommonext.AuthMethod;
import com.ibm.etools.webservice.wscommonext.ConfidentialPart;
import com.ibm.etools.webservice.wscommonext.ConfidentialPartPart;
import com.ibm.etools.webservice.wscommonext.IDAssertion;
import com.ibm.etools.webservice.wscommonext.Reference;
import com.ibm.etools.webservice.wscommonext.ReferencePart;
import com.ibm.etools.webservice.wscommonext.RequiredConfidentiality;
import com.ibm.etools.webservice.wscommonext.RequiredIntegrity;
import com.ibm.etools.webservice.wsext.LoginConfig;
import com.ibm.etools.webservice.wsext.SecurityRequestReceiverServiceConfig;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.wsspi.wssecurity.id.TrustedIDEvaluator;
import com.ibm.xml.soapsec.confimpl.PrivateReceiverConfig;
import com.ibm.xml.soapsec.dsig.VerificationSettings;
import com.ibm.xml.soapsec.enc.EncryptionSettings;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import java.io.File;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class WSEMFRequestReceiverConfig
extends PrivateReceiverConfig {
    private static Map keyStores = new Hashtable();
    private static Map certFactories = new Hashtable();
    private static Map certs = new Hashtable();
    private String wsseNS = null;
    private String wsuNS = null;
    private String origin = "non-ws-security";
    static final String WS_SEC = "ws-security";
    static final String NON_WS_SEC = "non-ws-security";
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSEMFRequestReceiverConfig.class.getName();
    private static final TraceComponent tc = Tr.register(WSEMFRequestReceiverConfig.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");

    public WSEMFRequestReceiverConfig(SecurityRequestReceiverBindingConfig reqRecBnd, SecurityRequestReceiverServiceConfig reqRecExt, String actorURI, VariableMap varMap, WSSecurityService service) throws SoapSecurityException {
        this(reqRecBnd, reqRecExt, actorURI, varMap, service, null, null);
    }

    public WSEMFRequestReceiverConfig(SecurityRequestReceiverBindingConfig reqRecBnd, SecurityRequestReceiverServiceConfig reqRecExt, String actorURI, VariableMap varMap, WSSecurityService service, ClassLoader appClassLoader) throws SoapSecurityException {
        this(reqRecBnd, reqRecExt, actorURI, varMap, service, null, null);
    }

    public WSEMFRequestReceiverConfig(SecurityRequestReceiverBindingConfig reqRecBnd, SecurityRequestReceiverServiceConfig reqRecExt, String actorURI, VariableMap varMap, WSSecurityService service, ClassLoader appClassLoader, PCBinding portCmpBnd) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFRequestReceiverConfig (SecurityRequestReceiverBindingConfig, SecurityRequestReceiverServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader, portCmpBnd):", new Object[]{reqRecBnd, reqRecExt, actorURI, varMap, service, appClassLoader});
        }
        this.init(reqRecBnd, reqRecExt, actorURI, varMap, service, appClassLoader, portCmpBnd);
        this.origin = WS_SEC;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSEMFRequestReceiverConfig()");
        }
    }

    WSEMFRequestReceiverConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFRequestReceiverConfig");
            Tr.exit(tc, "WSEMFRequestReceiverConfig");
        }
    }

    final void init(SecurityRequestReceiverBindingConfig reqRecBnd, SecurityRequestReceiverServiceConfig reqRecExt, String actorURI, VariableMap varMap, WSSecurityService service, ClassLoader appClassLoader, PCBinding portCmpBnd) throws SoapSecurityException {
        int count;
        com.ibm.xml.soapsec.token.LoginMapping lm;
        String name;
        int i;
        ConfigValidation valid;
        EList p;
        Object dconfig;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(SecurityRequestReceiverBindingConfig, SecurityRequestReceiverServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader, portCmpBnd):", new Object[]{reqRecBnd, reqRecExt, actorURI, varMap, service, appClassLoader});
        }
        AddReceivedTimestamp addReceivedTimestamp = null;
        IDAssertion idAssertion = null;
        LoginConfig loginConfig = null;
        RequiredConfidentiality requiredConfidentiality = null;
        RequiredIntegrity requiredIntegrity = null;
        WSSecurityDefaultConfiguration config = null;
        if (service != null && (dconfig = service.getConfig()) instanceof WSSecurityDefaultConfiguration) {
            config = (WSSecurityDefaultConfiguration)dconfig;
        }
        Map defaultProps = null;
        Map extProperties = null;
        Map bndProperties = null;
        Map bndParameters = null;
        this._properties = new HashMap();
        if (config != null) {
            WSSGeneratorConfig dgconfig = config.getDefaultGeneratorBinding();
            if (dgconfig != null) {
                defaultProps = dgconfig.getProperties();
                if (defaultProps != null) {
                    this._properties.putAll(defaultProps);
                }
            } else {
                defaultProps = config.getProperties();
                if (defaultProps != null) {
                    this._properties.putAll(defaultProps);
                }
            }
        }
        if (reqRecExt != null && (p = reqRecExt.getProperties()) != null && (extProperties = ConfigConstants.getProperties(p, varMap)) != null) {
            this._properties.putAll(extProperties);
        }
        if (portCmpBnd != null && (p = portCmpBnd.getParameters()) != null && (bndParameters = ConfigConstants.getProperties(p, varMap)) != null) {
            this._properties.putAll(bndParameters);
        }
        if (reqRecBnd != null && (p = reqRecBnd.getProperties()) != null && (bndProperties = ConfigConstants.getProperties(p, varMap)) != null) {
            this._properties.putAll(bndProperties);
        }
        if (reqRecExt != null) {
            addReceivedTimestamp = reqRecExt.getAddReceivedTimestamp();
            idAssertion = reqRecExt.getIdAssertion();
            loginConfig = reqRecExt.getLoginConfig();
            requiredConfidentiality = reqRecExt.getRequiredConfidentiality();
            requiredIntegrity = reqRecExt.getRequiredIntegrity();
            if (tc.isDebugEnabled()) {
                if (extProperties != null) {
                    Tr.debug(tc, "Request Receiver Deployment Descriptor (AddReceivedTimestamp, IdAssertion, LoginConfig, RequiredConfidentiality, RequiredIntegrity, Property):", new Object[]{addReceivedTimestamp, idAssertion, loginConfig, requiredConfidentiality, requiredIntegrity, extProperties});
                } else {
                    Tr.debug(tc, "Request Receiver Deployment Descriptor (AddReceivedTimestamp, IdAssertion, LoginConfig, RequiredConfidentiality, RequiredIntegrity):", new Object[]{addReceivedTimestamp, idAssertion, loginConfig, requiredConfidentiality, requiredIntegrity});
                }
            }
        }
        if (!(valid = new ConfigValidation(varMap, config)).requiredConfidentialityValid(requiredConfidentiality)) {
            throw new SoapSecurityException("Invalid RequiredConfidentiality");
        }
        if (!valid.requiredIntegrityValid(requiredIntegrity)) {
            throw new SoapSecurityException("Invalid RequiredIntegrity");
        }
        if (!valid.idAssertionValid(idAssertion)) {
            throw new SoapSecurityException("Invalid IDAssertion");
        }
        if (actorURI != null) {
            String tmpActor = actorURI.trim();
            if (tmpActor.length() != 0) {
                this.myactor = tmpActor;
            }
        } else {
            this.myactor = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "actorURI = " + this.myactor);
        }
        this.enableReceivedTimestamp = false;
        if (addReceivedTimestamp != null) {
            this.enableReceivedTimestamp = addReceivedTimestamp.isFlag();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding enableReceivedTimestamp: " + this.enableReceivedTimestamp);
            }
        }
        this.idType = null;
        this.trustMode = null;
        if (idAssertion != null) {
            this.idType = idAssertion.getIdType();
            String string = this.idType = this.idType == null ? this.idType : this.idType.trim();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding IDAssertion Type: " + this.idType);
            }
            this.trustMode = idAssertion.getTrustMode();
            String string2 = this.trustMode = this.trustMode == null ? this.trustMode : this.trustMode.trim();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding IDAssertion TrustMode: " + this.trustMode);
            }
        }
        if (requiredIntegrity != null) {
            int count2 = requiredIntegrity.getReferences().size();
            for (i = 0; i < count2; ++i) {
                Reference ref = (Reference)requiredIntegrity.getReferences().get(i);
                ReferencePart refPart = ref.getPart();
                name = refPart.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding integrity part: " + name);
                }
                this.requiredIntegralParts.add(name);
            }
        }
        if (requiredConfidentiality != null) {
            int count3 = requiredConfidentiality.getConfidentialParts().size();
            for (i = 0; i < count3; ++i) {
                ConfidentialPart confPart = (ConfidentialPart)requiredConfidentiality.getConfidentialParts().get(i);
                ConfidentialPartPart confPartPart = confPart.getPart();
                name = confPartPart.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding confidentiality part: " + name);
                }
                this.requiredConfidentialParts.add(name);
            }
        }
        if (loginConfig != null) {
            int count4 = loginConfig.getAuthMethods().size();
            boolean bBasicAuth = false;
            for (int i2 = 0; i2 < count4; ++i2) {
                AuthMethod authMethod = (AuthMethod)loginConfig.getAuthMethods().get(i2);
                if (authMethod == null) continue;
                name = authMethod.getText();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding authMethod name: " + name);
                }
                this.authMethods.add(name);
                bBasicAuth = "BasicAuth".equals(name);
            }
            if (extProperties != null && !extProperties.isEmpty()) {
                String nonceTimestampRequired;
                String nonceRequired = (String)extProperties.get("com.ibm.ws.wssecurity.config.token.BasicAuth.NonceRequired");
                if (nonceRequired != null && (nonceRequired = nonceRequired.trim()).length() != 0) {
                    this.checkNonce = Boolean.valueOf(nonceRequired);
                    if (this.checkNonce) {
                        if (!bBasicAuth) {
                            this.checkNonce = false;
                            this.checkNonceTimestamp = false;
                            StringBuffer buf = new StringBuffer();
                            for (int i3 = 0; i3 < this.authMethods.size(); ++i3) {
                                buf.append(this.authMethods.get(i3)).append(",");
                            }
                            String tmp = buf.toString();
                            tmp = tmp.substring(0, tmp.length() - 1);
                            Tr.warning(tc, "security.wssecurity.WSEC0113W", new Object[]{tmp});
                        } else {
                            this.checkNonceTimestamp = true;
                        }
                    }
                }
                if ((nonceTimestampRequired = (String)extProperties.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.timestampRequired")) != null && (nonceTimestampRequired = nonceTimestampRequired.trim()).length() != 0) {
                    this.checkNonceTimestamp = Boolean.valueOf(nonceTimestampRequired);
                    if (this.checkNonceTimestamp && !this.checkNonce) {
                        this.checkNonceTimestamp = false;
                        Tr.warning(tc, "security.wssecurity.WSEC0114W");
                    }
                }
            }
        }
        CertStoreList certStoreList = null;
        EList encryptionInfos = null;
        EList keyLocators = null;
        EList loginMappings = null;
        EList signingInfos = null;
        EList trustAnchors = null;
        com.ibm.etools.webservice.wscommonbnd.TrustedIDEvaluator trustedIDEvaluator = null;
        TrustedIDEvaluatorRef trustedIDEvaluatorRef = null;
        if (reqRecBnd != null) {
            String tmpNS;
            certStoreList = reqRecBnd.getCertStoreList();
            encryptionInfos = reqRecBnd.getEncryptionInfos();
            keyLocators = reqRecBnd.getKeyLocators();
            loginMappings = reqRecBnd.getLoginMappings();
            signingInfos = reqRecBnd.getSigningInfos();
            trustAnchors = reqRecBnd.getTrustAnchors();
            trustedIDEvaluator = reqRecBnd.getTrustedIDEvaluator();
            trustedIDEvaluatorRef = reqRecBnd.getTrustedIDEvaluatorRef();
            if (tc.isDebugEnabled()) {
                if (bndProperties != null) {
                    Tr.debug(tc, "Request Receiver Binding (CertStoreList, EncryptionInfos, KeyLocators, LoginMappings, SigningInfos, TrustAnchors, TrustedIDEvaluator, TrustedIDEvaluatorRef, Property):", new Object[]{certStoreList, encryptionInfos, keyLocators, loginMappings, signingInfos, trustAnchors, trustedIDEvaluator, trustedIDEvaluatorRef, bndProperties});
                } else {
                    Tr.debug(tc, "Request Receiver Binding (CertStoreList, EncryptionInfos, KeyLocators, LoginMappings, SigningInfos, TrustAnchors, TrustedIDEvaluator, TrustedIDEvaluatorRef):", new Object[]{certStoreList, encryptionInfos, keyLocators, loginMappings, signingInfos, trustAnchors, trustedIDEvaluator, trustedIDEvaluatorRef});
                }
            }
            if ((bndProperties != null || bndProperties.size() != 0) && (tmpNS = (String)bndProperties.get("com.ibm.ws.wssecurity.config.WSSE.Namespace")) != null && tmpNS.length() != 0) {
                if (!NamespaceUtil.isWsse((String)tmpNS)) {
                    throw SoapSecurityException.format("security.wssecurity.WSEC0152E", tmpNS);
                }
                this.wsseNS = tmpNS;
                this.wsuNS = NamespaceUtil.getCorrespondingWSUNS((String)this.wsseNS);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Namespace configured to be used to send the request, wsse=" + this.wsseNS + ", wsu=" + this.wsuNS);
            }
        }
        this._bypassSecurityHeader = ConfigUtil.getIsTruePropertyEnv((Map)this._properties, (String)"com.ibm.wsspi.wssecurity.config.disableWSSIfApplicationSecurityDisabled");
        if (!valid.receiverSigningInfoValid(signingInfos, trustAnchors, certStoreList, requiredIntegrity)) {
            throw new SoapSecurityException("Invalid receiver SigningInfo");
        }
        if (!valid.encryptionInfosValid(encryptionInfos, keyLocators, requiredConfidentiality)) {
            throw new SoapSecurityException("Invalid EncryptionInfo");
        }
        if (!valid.loginMappingValid(loginMappings, loginConfig)) {
            throw new SoapSecurityException("Invalid LoginMappings");
        }
        if (!valid.trustedIDEvaluatorRefValid(trustedIDEvaluatorRef)) {
            throw new SoapSecurityException("Invalid TrustedIDEvaluatorRef");
        }
        if (!valid.trustedIDEvaluatorValid(trustedIDEvaluator)) {
            throw new SoapSecurityException("Invalid TrustedIDEvaluator");
        }
        this.nonceMaxAge = (long)(config == null ? 300 : config.getNonceMaxAge()) * 1000L;
        this.nonceClockSkew = (long)(config == null ? 0 : config.getNonceClockSkew()) * 1000L;
        this.nonceManager = NonceManagerFactory.getInstance();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "default Nonce.maxAge = " + this.nonceMaxAge + " ms, default Nonce.clockSkew = " + this.nonceClockSkew + " ms");
            Tr.debug(tc, "NonceManager = " + this.nonceManager);
        }
        if (loginMappings != null) {
            int size = loginMappings.size();
            for (int i4 = 0; i4 < size; ++i4) {
                lm = ConfigConstants.readLoginMapping((LoginMapping)loginMappings.get(i4), varMap, appClassLoader);
                this.am2lm.put(lm.getAuthMethod(), lm);
                if (lm.getTokenValueType() != null) {
                    this.tvt2lm.put(lm.getTokenValueType(), lm);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding binding LoginMapping: ", new Object[]{lm});
                }
                this.processNonceBinding(lm.getAuthMethod(), lm.getProperties(), config);
            }
        }
        for (String am : this.authMethods) {
            if (this.am2lm.containsKey(am) || config == null) continue;
            lm = config.getLoginMapping(am);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding default LoginMapping: ", new Object[]{lm});
            }
            this.am2lm.put(am, lm);
            this.processNonceBinding(lm.getAuthMethod(), lm.getProperties(), config);
            if (lm.getTokenValueType() == null) continue;
            this.tvt2lm.put(lm.getTokenValueType(), lm);
        }
        if (trustedIDEvaluator != null) {
            TrustedIDEvaluator tie = ConfigConstants.readTrustedIDEvaluator(trustedIDEvaluator, varMap, appClassLoader);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding TrustID Evaluator.");
            }
            this.trustedIDEvaluator = tie;
        }
        if (encryptionInfos != null) {
            count = encryptionInfos.size();
            for (int i5 = 0; i5 < count; ++i5) {
                EncryptionInfo encryptionInfo = (EncryptionInfo)encryptionInfos.get(i5);
                EncryptionKey encryptionKey = encryptionInfo.getEncryptionKey();
                String encKeyName = null;
                String encKeyLocRef = null;
                if (encryptionKey != null) {
                    encKeyName = encryptionKey.getName();
                    encKeyLocRef = encryptionKey.getLocatorRef();
                }
                KeyLocator locator = ConfigConstants.findKeyLocator(keyLocators, encKeyLocRef, varMap, config, appClassLoader);
                DataEncryptionMethod dataEncryptionMethod = encryptionInfo.getEncryptionMethod();
                String dataEncAlg = null;
                if (dataEncryptionMethod != null) {
                    dataEncAlg = dataEncryptionMethod.getAlgorithm();
                }
                KeyEncryptionMethod keyEncryptionMethod = encryptionInfo.getKeyEncryptionMethod();
                String keyEncAlg = null;
                if (keyEncryptionMethod != null) {
                    keyEncAlg = keyEncryptionMethod.getAlgorithm();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding Encryption Info.", new Object[]{"Locator: " + locator, "dataEncAlg: " + dataEncAlg, "keyEncAlg: " + keyEncAlg, "encKeyName: " + encKeyName});
                }
                if (dataEncAlg == null || encKeyName == null || locator == null) {
                    String msgKey = "security.wssecurity.IncompleteEncryptionInfo";
                    if (dataEncAlg == null) {
                        Tr.warning(tc, msgKey, "Data Encryption Algorithm");
                    }
                    if (encKeyName == null) {
                        Tr.warning(tc, msgKey, "Encryption Key Name");
                    }
                    if (locator == null) {
                        Tr.warning(tc, msgKey, "Key Locator");
                    }
                }
                this.encryptionSettingsList.add(new EncryptionSettings(dataEncAlg, keyEncAlg, encKeyName, locator));
            }
        }
        if (signingInfos != null) {
            count = signingInfos.size();
            for (int i6 = 0; i6 < count; ++i6) {
                PKIXBuilderParameters params = null;
                Provider provider = null;
                HashSet<java.security.cert.X509Certificate> eeCerts = new HashSet<java.security.cert.X509Certificate>();
                String anchorRef = null;
                String storeRef = null;
                boolean trustAny = false;
                SigningInfo signingInfo = (SigningInfo)signingInfos.get(i6);
                CanonicalizationMethod c14nMethod = signingInfo.getCanonicalizationMethod();
                String c14nAlgorithm = null;
                if (c14nMethod == null) {
                    Tr.warning(tc, "security.wssecurity.nocanonicalization.algo");
                } else {
                    c14nAlgorithm = c14nMethod.getAlgorithm();
                }
                SignatureMethod signatureMethod = signingInfo.getSignatureMethod();
                String signatureAlgorithm = null;
                if (signatureMethod == null) {
                    Tr.warning(tc, "security.wssecurity.nosignature.algo");
                } else {
                    signatureAlgorithm = signatureMethod.getAlgorithm();
                }
                DigestMethod digestMethod = signingInfo.getDigestMethod();
                String digestAlgorithm = null;
                if (digestMethod == null) {
                    Tr.warning(tc, "security.wssecurity.nodigest.algo");
                } else {
                    digestAlgorithm = digestMethod.getAlgorithm();
                }
                CertPathSettings certPathSettings = signingInfo.getCertPathSettings();
                TrustAnyCertificate trustAnyCertificate = certPathSettings.getTrustAnyCertificate();
                if (trustAnyCertificate != null) {
                    trustAny = true;
                } else {
                    String csp;
                    HashMap tempMap;
                    String msgKey;
                    KeyStore keyStore = null;
                    TrustAnchorRef trustAnchorRef = certPathSettings.getTrustAnchorRef();
                    anchorRef = trustAnchorRef.getRef();
                    boolean foundTA = false;
                    for (int j = 0; j < trustAnchors.size(); ++j) {
                        TrustAnchor trustAnchor = (TrustAnchor)trustAnchors.get(j);
                        if (!anchorRef.equals(trustAnchor.getName())) continue;
                        com.ibm.etools.webservice.wscommonbnd.KeyStore keyStoreData = trustAnchor.getKeyStore();
                        String file = null;
                        file = varMap == null ? keyStoreData.getPath() : varMap.expand(keyStoreData.getPath());
                        keyStore = ConfigUtil.getKeyStore((String)keyStoreData.getType(), (String)file, (char[])keyStoreData.getStorepass().toCharArray());
                        foundTA = true;
                        break;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "(from application binding) Keystore for TrustAnchor: " + anchorRef + " = " + keyStore + "Found = " + foundTA);
                    }
                    if (!foundTA && config != null) {
                        keyStore = config.getTrustAnchor(anchorRef);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "(from default binding) Keystore for TrustAnchor: " + anchorRef + " = " + keyStore);
                        }
                    }
                    if (keyStore == null) {
                        throw SoapSecurityException.format("security.wssecurity.ConfigValidation.keystore.taref.open", anchorRef);
                    }
                    try {
                        X509CertSelector selector = new X509CertSelector();
                        params = new PKIXBuilderParameters(keyStore, (CertSelector)selector);
                        params.setDate(null);
                    }
                    catch (InvalidAlgorithmParameterException e) {
                        msgKey = "security.wssecurity.CommonReceiverConfig.s12";
                        FFDCFilter.processException((Throwable)e, clsName + ".WSEMFResponseReceiverConfig", "567", (Object)this);
                        Tr.error(tc, msgKey);
                        throw SoapSecurityException.format(msgKey, e);
                    }
                    catch (KeyStoreException e) {
                        msgKey = "security.wssecurity.CommonReceiverConfig.s12";
                        FFDCFilter.processException((Throwable)e, clsName + ".WSEMFResponseReceiverConfig", "572", (Object)this);
                        Tr.error(tc, msgKey);
                        throw SoapSecurityException.format(msgKey, e);
                    }
                    CertStoreRef certStoreRef = certPathSettings.getCertStoreRef();
                    if (certStoreRef != null) {
                        storeRef = certStoreRef.getRef();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "CertStoreRef = " + storeRef);
                    }
                    boolean certStoreFound = false;
                    if (certStoreList != null) {
                        String msgKey2;
                        EList collectionCertStores = certStoreList.getCollectionCertStores();
                        int certLength = collectionCertStores.size();
                        for (int j = 0; j < certLength; ++j) {
                            CollectionCertStore collectionStore = (CollectionCertStore)collectionCertStores.get(j);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "collectionCertStores.get(" + j + ") = " + collectionStore.getName());
                            }
                            if (storeRef == null || !storeRef.equals(collectionStore.getName())) continue;
                            provider = Security.getProvider(collectionStore.getProvider());
                            EList x509s = collectionStore.getX509Certificates();
                            int length2 = x509s.size();
                            HashMap<String, CertificateFactory> cache = new HashMap<String, CertificateFactory>();
                            for (int k = 0; k < length2; ++k) {
                                X509Certificate x509 = (X509Certificate)x509s.get(k);
                                String path = null;
                                path = varMap == null ? x509.getPath() : varMap.expand(x509.getPath());
                                String provider2 = "";
                                CertificateFactory cfac = (CertificateFactory)cache.get(provider2);
                                if (cfac == null) {
                                    cfac = ConfigUtil.createCertificateFactory((String)provider2);
                                    cache.put(provider2, cfac);
                                }
                                File f = new File(path);
                                eeCerts.add(ConfigUtil.getX509Certificate((File)f, (CertificateFactory)cfac));
                            }
                            String algorithm = "Collection";
                            CollectionCertStoreParameters cparams = null;
                            try {
                                cparams = new CollectionCertStoreParameters(eeCerts);
                                CertStore certStore = null;
                                certStore = "".equals(provider) ? CertStore.getInstance(algorithm, cparams) : CertStore.getInstance(algorithm, (CertStoreParameters)cparams, provider);
                                params.addCertStore(certStore);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found CertStore for " + storeRef);
                                }
                                certStoreFound = true;
                                break;
                            }
                            catch (NoSuchAlgorithmException e) {
                                msgKey2 = "security.wssecurity.CommonReceiverConfig.s20";
                                Tr.error(tc, msgKey2, new Object[]{algorithm});
                                throw SoapSecurityException.format(msgKey2, algorithm, (Throwable)e);
                            }
                            catch (InvalidAlgorithmParameterException e) {
                                msgKey2 = "security.wssecurity.CommonReceiverConfig.s21";
                                Tr.error(tc, msgKey2, new Object[]{cparams.toString() == null ? "" : cparams.toString()});
                                throw SoapSecurityException.format(msgKey2, cparams.toString() == null ? "" : cparams.toString(), (Throwable)e);
                            }
                            catch (Throwable e) {
                                msgKey2 = "security.wssecurity.load.collectioncertstore.failed";
                                Tr.error(tc, msgKey2, new Object[]{collectionStore.getName(), e});
                                throw SoapSecurityException.format(msgKey2, collectionStore.getName(), e);
                            }
                        }
                        if (!certStoreFound) {
                            EList ldapCertStores = certStoreList.getLdapCertStores();
                            int length = ldapCertStores.size();
                            for (int j = 0; j < length; ++j) {
                                CertStore certStore;
                                int port;
                                LDAPCertStore ldapCertStore = (LDAPCertStore)ldapCertStores.get(j);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "ldapCertStores.get(" + j + ") = " + ldapCertStore.getName());
                                }
                                if (storeRef == null || !storeRef.equals(ldapCertStore.getName())) continue;
                                LDAPServer ldapServer = ldapCertStore.getLdapServer();
                                String host = ldapServer.getHost();
                                try {
                                    port = Integer.parseInt(ldapServer.getPort());
                                }
                                catch (NumberFormatException e) {
                                    msgKey2 = "security.wssecurity.CommonReceiverConfig.s19";
                                    String arg = ldapServer.getPort();
                                    FFDCFilter.processException((Throwable)e, clsName + ".CommonReceiverConfig", "677", (Object)this);
                                    Tr.error(tc, msgKey2, arg);
                                    throw SoapSecurityException.format(msgKey2, arg, (Throwable)e);
                                }
                                String algorithm = "LDAP";
                                provider = Security.getProvider(ldapCertStore.getProvider());
                                LDAPCertStoreParameters ldapParams = new LDAPCertStoreParameters(host, port);
                                try {
                                    certStore = "".equals(provider) ? CertStore.getInstance(algorithm, ldapParams) : CertStore.getInstance(algorithm, (CertStoreParameters)ldapParams, provider);
                                }
                                catch (NoSuchAlgorithmException e) {
                                    String msgKey3 = "security.wssecurity.CommonReceiverConfig.s20";
                                    FFDCFilter.processException((Throwable)e, clsName + ".CommonReceiverConfig", "693", (Object)this);
                                    Tr.error(tc, msgKey3, algorithm);
                                    throw SoapSecurityException.format(msgKey3, algorithm);
                                }
                                catch (InvalidAlgorithmParameterException e) {
                                    String msgKey4 = "security.wssecurity.CommonReceiverConfig.s21";
                                    FFDCFilter.processException((Throwable)e, clsName + ".CommonReceiverConfig", "698", (Object)this);
                                    Tr.error(tc, msgKey4, params.toString());
                                    throw SoapSecurityException.format(msgKey4, params.toString());
                                }
                                params.addCertStore(certStore);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found CertStore for " + storeRef);
                                }
                                certStoreFound = true;
                                break;
                            }
                        }
                    }
                    if (!certStoreFound && storeRef != null && config != null) {
                        CertStore cs = config.getCertStore(storeRef);
                        if (cs == null) {
                            String msgKey5 = "security.wssecurity.ConfigValidation.csref.notfound";
                            Tr.error(tc, msgKey5, new Object[]{storeRef});
                            throw SoapSecurityException.format(msgKey5, storeRef);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found CertStore for " + storeRef);
                        }
                        params.addCertStore(cs);
                    }
                    if (anchorRef != null && provider == null && (provider = ConfigUtil.setupCertStoreProvider((Map)this._properties, tempMap = new HashMap(), null)) == null && ConfigUtil.hasValue((String)(csp = (String)tempMap.get("com.ibm.wsspi.wssecurity.config.CertStore.Provider")))) {
                        throw new SoapSecurityException("The cert store security provider '" + csp + "' does not exist.  The cert store security provider is " + "configured on the '" + "com.ibm.wsspi.wssecurity.config.CertStore.Provider" + "' property.");
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding Signing Info.", new Object[]{"c14nAlgorithm: " + c14nAlgorithm, "digestAlgorithm: " + digestAlgorithm, "signatureAlgorithm: " + signatureAlgorithm, "provider: " + provider, "eeCerts: " + eeCerts, "anchorRef: " + anchorRef, "storeRef: " + storeRef, "trustAny: " + trustAny});
                }
                this.verificationSettingsList.add(new VerificationSettings(c14nAlgorithm, digestAlgorithm, signatureAlgorithm, params, provider, eeCerts, anchorRef, storeRef, trustAny));
            }
        }
        if (trustedIDEvaluator == null && trustedIDEvaluatorRef != null) {
            String tieRef = trustedIDEvaluatorRef.getRef();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding TrustID Evaluator Reference: " + tieRef);
            }
            this.trustedIDEvaluator = config.getTrustedIDEvaluator(tieRef);
        }
        this.processPrivateConfig(DOMUtil.getPrivateConfig((boolean)false));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.getLogProperties(defaultProps, bndParameters, extProperties, bndProperties, "request", "receiver"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    private void processNonceBinding(String am, Map p, WSSecurityDefaultConfiguration config) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processNonceBinding", new Object[]{am, p});
        }
        if (p != null && !p.isEmpty()) {
            String maxAge = (String)p.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.maxAge");
            String clockSkew = (String)p.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.clockSkew");
            boolean bBasicAuth = "BasicAuth".equals(am);
            if (bBasicAuth && this.checkNonce && this.checkNonceTimestamp) {
                if (config == null) {
                    if (maxAge != null) {
                        this.nonceMaxAge = (long)ConfigConstants.processNonceMaxAge(maxAge, 600) * 1000L;
                    }
                    if (clockSkew != null) {
                        this.nonceClockSkew = (long)ConfigConstants.processNonceClockSkew(clockSkew, (int)(this.nonceMaxAge / 1000L)) * 1000L;
                    }
                } else {
                    if (maxAge != null) {
                        this.nonceMaxAge = (long)ConfigConstants.processNonceMaxAge(maxAge, config.getNonceCacheTimeout()) * 1000L;
                    }
                    if (clockSkew != null) {
                        this.nonceClockSkew = (long)ConfigConstants.processNonceClockSkew(clockSkew, (int)(this.nonceMaxAge / 1000L)) * 1000L;
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nonce.maxAge = " + this.nonceMaxAge + " ms, Nonce.clockSkew = " + this.nonceClockSkew + " ms");
            }
            p.remove("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.maxAge");
            p.remove("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.clockSkew");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processNonceBinding");
        }
    }

    final String getOrigin() {
        return this.origin;
    }

    final String getWSSENS() {
        return this.wsseNS;
    }

    final String getWSUNS() {
        return this.wsuNS;
    }
}

